/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 3/93
 *
 */

#include <prm-copyr.h>

#include <comm.h>
#include <pdap.h>


PTEXT
PDAP_copy_to_pkts(RREQ req, char *dataptr, char *startp, int tot_len)
{

  PTEXT firstpkt = NOPKT, pkt_i;
  char *msg;
  int last_pdata_len, tot_pkts, pkt_num;


  last_pdata_len = tot_len % PDAP_DATA_PKT_SZ;
  tot_pkts = tot_len/PDAP_DATA_PKT_SZ + (last_pdata_len > 0);

  if (tot_pkts == 1) {
    bcopy(dataptr, startp, tot_len);
    req->outpkt->length += tot_len;
  }
  else {
    for (pkt_num = 1; pkt_num <= tot_pkts; pkt_num++) {
      int this_pkt_dat_len = (((pkt_num == tot_pkts)  && last_pdata_len) ?
			      last_pdata_len : PDAP_DATA_PKT_SZ );
      pkt_i = ardp_ptalloc();
      bcopy(dataptr, pkt_i->start, this_pkt_dat_len);
      dataptr += PDAP_DATA_PKT_SZ;
      pkt_i->length = this_pkt_dat_len;
      APPEND_ITEM(pkt_i,req->outpkt);
    }
  }
}


PDAP_extract_from_pkts(PTEXT pkt_list, char *msgp, char *rcv_buffer, 
		       int xpctd_len)
{
  PTEXT pkt_i;
  int len;

  u_long rcvd_len, bytes_remng, copied_len = 0;
  
  DECODE_ASN1_LENGTH(msgp,rcvd_len);
  bytes_remng = MIN(rcvd_len, xpctd_len);
  
  if (rcvd_len <= 1024) {
    bcopy(msgp, rcv_buffer, bytes_remng);
    copied_len = bytes_remng;
  }
  else {
    pkt_i = pkt_list->next;
    
    while(pkt_i && (bytes_remng > 0) ) {
      len = MIN(bytes_remng,PDAP_DATA_PKT_SZ); 
      bcopy(pkt_i->start, rcv_buffer, len);
      copied_len += len;
      rcv_buffer += len;
      bytes_remng -= len;
      
      pkt_i = pkt_i->next;
    }
  }
  return copied_len;
}

