/*
 * Copyright (c) 1989, 1990, 1991 by the University of Washington
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <uw-copyright.h> and <usc-copyr.h>
 *
 * Written  by bcn 1989     as part of psite.h
 * Modified by bcn 1/19/93  to leave only server specific definitions
 */

#include <uw-copyright.h>
#include <usc-copyr.h>

/*
 * pserver.h - server specific parameters for Prospero
 *
 * This file contains local definitions for the Prospero server.
 * It is expected that it will be different on different systems.
 */

/* 
 * SERVER_SUPPORT_V1 indicates that the server is to reply to version 1
 * Prospero Protocol requests.  It is recommended that you define
 * this for the time being since there are many Version 1 clients still
 * in use.  Note that version 1 clients will *not* be able to speak
 * to certain new services so t's a good idea to upgrade your clients.
 */
#define     SERVER_SUPPORT_V1
#define     SERVER_DONT_FLAG_V1

/*
 * P_DIRSRV_BINARY defines the full path by which pstart will
 * find the binary for the directory server.
 */
#define P_DIRSRV_BINARY       "/usr/pfs/bin/dirsrv"

/*
 * PROSPERO_CONTACT specifies the e-mail address of the individual
 * or individuals responsible for running the Prospero server on the 
 * local system.  If specified, this string will appear in responses to 
 * status requests.  This definition is optional.
 *
 * #define PROSPERO_CONTACT "yourname@host.org.domain"
 */

/* 
 * PSRV_HOSTNAME specifies the name of the host on which the server 
 * will run.  It only needs to be defined if gethostbyname does not 
 * return the name of the host as a fully qualified domain name.
 *
 * #define PSRV_HOSTNAME	      "HOST.ORG.DOMAIN"
 *
 */

/* 
 * PSRV_USER_ID specifies the user name under which the Prospero
 * server will run.  The server will run under the home group of
 * PSRV_USER_ID, but (in systems which support membership in multiple
 * groups) not under any supplementary groups to which that user may
 * belong.
 */
#define PSRV_USER_ID             "pfs"

/* 
 * P_RUNDIR is the name of the directory under which the Prospero
 * server will run.  If left out, it defaults to /tmp.
 *
 * #define PSRV_RUNDIR	      "/tmp"
 */

/*
 * PSRV_LOGFILE is the name of the file in which events are logged.  
 * By default Prospero logs all requests if PSRV_LOGFILE is defined.  If you 
 * would like to change the list of events that are logged, or if you would
 * like to use syslog for logging, edit the file plog.h.
 */
#define PSRV_LOGFILE             "/usr/pfs/pfs.log"

/*
 * PSRV_ROOT defines that part of the system's directory tree for which
 * directory information will be readable over the network.  Directory
 * information will also be available for files under AFTPDIRECTORY and
 * AFSDIRECTORY if these access methods are supported.
 *
 * If PSRV_ROOT is not defined, then directory information will only be
 * available for those files under AFTPDIRECTORY or AFSDIRECTORY.
 *
 * #define PSRV_ROOT "/" 
 */

/*
 * PSRV_READ_ONLY specifies that the server is only to accept
 * operations that read the directory structure. No changes to virtual
 * directories stored on this system will be allowed.  NODOTDOT is used to
 * disallow the use of path names that include "..".  If you are
 * restricting the part of the directory tree which will be accessible
 * (i.e. if PSRV_ROOT is other than "/"), NODOTDOT should be set.
 *
 * #define PSRV_READ_ONLY
 * #define NODOTDOT
 */
#define PSRV_READ_ONLY
#define NODOTDOT


/*
 * PSRV_SHADOW is the name of the shadow hierarchy that contains additional 
 * information about Prospero files.  PSRV_STORAGE is the name of the directory
 * under which new files can be created, if that option is supported by
 * your distribution.  Both names are relative to the home directory for the
 * user ID specified by P_USER_ID.  
 */
#define PSRV_SHADOW              "shadow"
#define PSRV_STORAGE             "pfsdat"

/*
 * If PSRV_UNDER_UDIR is defined, pstart calculates the full path names of
 * of the directories corresponding to PSRV_SHADOW and PSRV_STORAGE by
 * finding the home directory for the Prospero user ID, then appending
 * PSRV_SHADOW or PSRV_STORAGE.
 *
 * If PSRV_UNDER_UDIR is not defined, or if dirsrv is called directly,
 * the full path names are taken from PSRV_FSHADOW and PSRV_FSTORAGE.  These
 * should be stable names for those directories.  They may be aliases
 * (symbolic links) if the directories move around.  If they are symbolic
 * links, the links should be updated whenever the directories move.
 *
 * Note that if PSRV_UNDER_UDIR is set, the full path names are calculated 
 * only when the Prospero server is started by pstart.  If you expect
 * to start the server by hand (for example, when debugging), PSRV_FSHADOW 
 * and PSRV_FSTORAGE should also be defined.
 */
#define PSRV_UNDER_UDIR

#define PSRV_FSHADOW	      "/usr/pfs/shadow"
#define PSRV_FSTORAGE	      "/usr/pfs/pfsdat"

/*
 * AFTPDIRECTORY contains the name of the root directory as seen through
 * anonymous FTP.  It is used to determine which files may be accessed
 * using the anonymous FTP access mechanism, and to determine the file name
 * that must be used when doing so.  It also adds to the set of files about 
 * which directory information is available.
 *
 * Note: AFTPDIRECTORY should be a stable name for the FTP directory.
 *       It may be an alias (symbolic link) if the FTP directory
 *       moves around.  If it is a symbolic link, that symbolic link should
 *       be updated whenever the directory moves.
 */
#define AFTPDIRECTORY           "/usr/ftp"

/*
 * AFTPUSER contains the name of the anonymous FTP user (usually ftp)
 * If defined, pstart will look up the home directory for this user
 * and use it instead of AFTPDIRECTORY.  If it fails, the value of
 * AFTPDIRECTORY (defined above) will be used.  
 *
 * Note that if AFTPUSER is set, the path name of the FTP directory is
 * calculated only when the Prospero server is started by pstart. 
 * If you expect to start the server by hand (for example, when
 * debugging), AFTPDIRECTORY should also be defined.
 *
 * Also note that when started by pstart, if AFTPUSER is defined, the
 * path taken from the password file will override that specified by
 * AFTPDIRECTORY.  If AFTPDIRECTORY is a stable path, do not define 
 * AFTPUSER.
 *
 * #define AFTPUSER 		"ftp"
 */

/*
 * NFS_EXPORT should be defined if your system allows others to 
 * access files using NFS.  If defined, you will have to modify
 * lib/psrv/check_nfs.c so that the directory server is aware of 
 * your system's policy for NFS mounts (this is necessary so that 
 * the directory server will not tell the client to use NFS when
 * such access is not supported).
 *
 * #define NFS_EXPORT
 */

/*
 * AFSDIRECTORY contains the name of the root of the AFS directory
 * hierarchy.  It should only be defined if your host supports AFS
 * and you are willing to make information about AFS files available
 * through your server.  AFSDIRECTORY is used to to determine which files
 * may be accessed using the AFS access mechanism.  It also adds to
 * the set of files about which directory information is available.
 *
 * Note: AFSDIRECTORY must be the true name for the directory
 *       after all symbolic links have been expanded.
 *
 * #define AFSDIRECTORY           "/afs"
 */

/*
 * PSRV_KERBEROS, if defined, means that the server will understand
 * Kerberos (version 5) authentication information. This should be
 * #defined if your site uses Kerberos authentication; otherwise, you
 * won't have a use for it.  If you #define this, then you also need
 * to use the Kerberos versions of the Makefiles.
 *
 * Note that most Kerberos sites still use the older version 4,
 * which is not supported by Prospero.
 *
 * #define PSRV_KERBEROS
 */

/*
 * KERBEROS_SRVTAB, if defined, tells the server the location of the
 * server's keytab file that contains its Kerberos key. Define this
 * only if, firstly, you are using Kerberos (i.e. KERBEROS is
 * defined), and, secondly, if you want to keep this key in a location
 * different from its default location (typically /etc/v5srvtab).
 *
 * #define KERBEROS_SRVTAB "/usr/pfs/v5srvtab"
 */

/*
 * PSRV_P_PASSWORD, if defined, means that server will understand
 * password authentication information.
 *
 * #define PSRV_P_PASSWORD
 */

/* PSRV_PW_FILE contains the name of the servers password file used
 * for P_PASSWORD authentication. Define this only if you are using
 * this type of authentication.
 *
 * #define PSRV_PW_FILE "/usr/pfs/ppasswd"
 */
#define PSRV_PW_FILE "/usr/pfs/ppasswd"

/* 
 * DEFAULT_ACL, SYSTEM_ACL, OVERRIDE_ACL and MAINT_ACL are access
 * control lists used to control access to Prospero directories.
 * DEFAULT_ACL applies to those directories for which no individual
 * access control list has been specified.  All access control lists
 * initially include SYSTEM_ACL, but the entry may be explicitly
 * removed by the administrator of a directory or link.  OVERRIDE_ACL
 * grants rights to a directory regardless of the contents of any
 * other access control list.  MAINT_ACL is an access control list
 * for performing remote maintenance on the server.
 */
#define DEFAULT_ACL  {{ACL_ANY,      NULL, "YvlGgr"                       }}

#define SYSTEM_ACL   {{ACL_ASRTHOST, NULL, "ALRWD", "pfs@%.%.%.%"}, \
                      {ACL_ASRTHOST, NULL, "ALRWD",   "pfs@128.9.*.*"}}

#define OVERRIDE_ACL {{ACL_TRSTHOST, NULL, "A",       "root@%.%.%.%"},\
                      {ACL_OWNER,    NULL, "A"}}

#define MAINT_ACL    {{ACL_ASRTHOST, NULL, "STUP",    "root@%.%.%.%"},\
                      {ACL_ANY,      NULL, "Y"}}


/*
 * PSRV_ARCHIE, if defined, indicates that your server is to 
 * make available information from the archie database. You
 * must already have the archie database installed on your
 * machine and you must follow the additional directions in
 * lib/psrv/archie2 or lib/psrv/archie3 to configure the server.
 *
 * #define PSRV_ARCHIE
 */

/*
 * PSRV_GOPHER, if defined, indicates that your server is to 
 * make available information from gopher. You must already have
 * gopher installed on your machine and you must follow the additional
 * directions in lib/psrv/gopher to configure the server.  This option
 * is not presently supported.
 *
 * #define PSRV_GOPHER
 */

/*
 * SHARED_PREFIXES, if defined, indicates that the host on which your
 * server runs shares some part of its filesystem with other specified
 * hosts (perhaps via an NFS auto-mounter).  If you define
 * SHARED_PREFIXES appropriately, then Prospero clients on machines
 * with access to the shared part of the filesystem will be able to
 * retrieve files on the server that might be unreachable via another
 * access method.  
 * 
 * You should specify SHARED_PREFIXES only if you want the server to
 * return a LOCAL access-method for files in these areas on your
 * server.  If you don't understand this definition, just leave it
 * undefined.
 * 
 * The format of the SHARED_PREFIXES definition is a concatenated series of
 * entries, each one describing a particular subtree of the filesystem
 * that is exported.    Each entry is composed of 4 subitems.  The subitems
 * are:
 * 
 *  a) Name (or names, if alternate names for directories are present) of
 *     the subtree on the server host.  The last name is followed by a NULL
 *  b) Name of the subtree on the client host(s).  There must be no more
 *     than one of these entries.  This subitem is followed by a NULL.
 *  c) Internet addresses of the hosts which have this subtree as part
 *     of the local filesystem namespace.  These can be wildcarded;
 *      - any octet may be replaced with a '*' (indicating match any).
 *	- any octet may be replaced with a '%' (indicating to match
 *        with the value of this octet in the server host's address)
 *     This subitem is followed by a NULL.
 *  d) exception list: a list of hosts which do NOT have this subtree
 *     as part of the local filesystem namespace.  This lets one exclude
 *     special hosts or subnets that don't share in an organization's
 *     overall networked filesystem.  This subitem is followed by a NULL.
 * 
 * 
 * An example may make this clearer.  Here is the entry we use on the
 * server on PROSPERO.ISI.EDU:
 *
 * #define SHARED_PREFIXES { \
 *    "/nfs", NULL, "/nfs", NULL, "128.9.*.*", NULL, NULL, \
 *    "/ftp", NULL, "/auto/gum/gum/ftp", NULL, "128.9.*.*", NULL, NULL, \
 *    "/afs", NULL, "/nfs/afs", NULL, "128.9.*.*", NULL, NULL }
 */



/******************************************************************
 * You should not need to change any definitions below this line. *
 ******************************************************************/

/*
 * DSHADOW and DCONTENTS are the names of the file in the shadow
 * directory used to store information about directories.  There
 * should be no need to change them.
 */
#define DSHADOW			".directory#shadow"
#define DCONTENTS		".directory#contents"

/* 
 * ARCHIE_PREFIX is an entry for archie that will appear
 * in the DATABASE_PREFIXES definition.  It should not be set
 * directly but is instead set automatically if PSRV_ARCHIE is
 * defined.  If not, it will be empty.  If set, it must be 
 * followed by a ,.
 */
#ifdef PSRV_ARCHIE
#define ARCHIE
#define ARCHIE_PREFIX {"ARCHIE", arch_dsdb},
#define DATABASE_PREFIX "ARCHIE"
#else 
#define ARCHIE_PREFIX
#endif


/*
 * GOPHER_PREFIXES are the entries for gopher that will appear
 * in the DATABASE_PREFIXES definition.  It should not be set
 * directly but is instead set automatically if PSRV_GOPHER is
 * defined.  If not, it will be empty.  If set, it must be 
 * followed by a ,.
 *
 * XXX This is not yet a supported part of the distribution. 
 *
 * If you run a Gopher server, define GOPHER to be a list of 
 * pairs of Gopher hierarchy root directories and TCP ports.  This list
 * must be terminated with the record {"", 0}.
 *
 * #define GOPHER {{"/nfs/pfs/gopherroot", 70}, {"", 0}}
 *
 */
#ifdef PSRV_GOPHER
#define GOPHER_PREFIXES {"GOPHER", gopher_dsdb}
#else
#define GOPHER_PREFIXES
#endif


/*
 * DATABASE_PREFIXES is an array of structures, each representing
 * a particular database prefix and its acompanying prospero query
 * function.  It is for use when the Prospero server provides information
 * from sources other than the file system.  It should be set
 * automatically if the appropriate database has been configured.  
 * you should not need to set it directly. The last element in the
 * array must be a NULL pointer.
 *
 * DATABASE_PREFIXES supersedes the old DATABASE_PREFIX option.
 *                              
 */

#define DATABASE_PREFIXES { ARCHIE_PREFIX GOPHER_PREFIXES }

/* 
 * If DIRSRV_EXPLAIN_LAST_RESTART is defined and the server detects an
 * internal error and restarts itself, the message that caused the
 * error will be explained in the logfile and in the message returned
 * by pstatus.
 */

#define DIRSRV_EXPLAIN_LAST_RESTART

