/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Originally managers.h. Modified by srao.
 *
 */

#include <prm-copyr.h>

#ifndef _PRM_H_INCLUDED
#define _PRM_H_INCLUDED


/* Uncomment this if you are compiling as root */
/* 
#define ROOT
*/

/* protocol version of prm messages */

#define PRM_PROTO_V  0  


/*  Every message contains an opcode indicating the service requested by the 
    client. The opcode also decides how the rest of the message is interpreted.
    The opcode is of type u_char, and is placed at offset PRM_OPCODE_OFF from 
    the start of the message (pkt->start). Multipacket messages need to have 
    the opcode specified only in the first packet.
*/


/* Operations that change status of tasks and jobs */

#define PRM_CREAT_TASK  1   /* Initialize task on node, schedule it for exec */
#define PRM_TCREAT_RESP 2   /* Response to task initiation request           */
#define PRM_TASK_STAT   3   /* Status of a task has changed                  */
#define PRM_TSTAT_RESP  4   /* Response to task-status-changed message       */
#define PRM_JOB_DONE    5   /* All tasks (and hence job) completed execution */
#define PRM_JDONE_RESP  6   /* Response to job_done                          */

/*  Operations affecting the system status */

#define PRM_NSTAT_QRY  16   /* Node status query from sysmngr                */
#define PRM_NSTAT_UPDT 17   /* Node status update                            */
#define PRM_RSC_REQ    18   /* Resource allocation request from jobmngr      */
#define PRM_RSC_GNT    19   /* Resource grant by sysmngr                     */
#define PRM_AUTH_JOB   20   /* Authorization msg from sysmngr to nodemngr    */
#define PRM_AUTH_RESP  21   /* Response to authorization message             */
#define PRM_LOGIN_NTFY 22   /* Notification from login program to nodemngr   */
#define PRM_LOGIN_RESP 23   /* Response to login program                     */

/*  Operations requested by tasks */

#define PRM_NTASKS_JOB 32   /* Request total number of tasks in job          */
#define PRM_TASK_CNT   33   /* Response to task count request                */
#define PRM_APP_MSG    34   /* Application-level message                     */
#define PRM_AMSG_RESP  35   /* Response to application message               */
#define PRM_SYNC_TASKS 36   /* Synchronization all tasks                     */
#define PRM_SYNC_RESP  37   /* Response to synchronization                   */
#define PRM_IO_PRINT   38   /* Print string to terminal (thru term_iotask)   */
#define PRM_PRINT_RESP 39   /* Response to io_print                          */

/* Operations involving address translation and caching */

#define PRM_THMAP_UPDT 48   /* Update task-to-host mapping                   */
#define PRM_MPUPD_RESP 49   /* Response to mapping update                    */
#define PRM_ADDR_XLAT  50   /* Request port/hostaddr of task                 */
#define PRM_XLAT_RESP  51   /* Response to address translation request       */
#define PRM_ASGN_PORT  53   /* Request NM to assign a UDP port for comm      */
#define PRM_PORT_RESP  54   /* Response to port request                      */

/* Abnormal situations */

#define PRM_WRONG_VERSION 80  /* Wrong PRM message protocol version  */
#define PRM_APPL_ERR      82  /* Error occurred at application level */
#define PRM_APERR_RESP    83  /* Response to application error       */



/* Offsets (from beginning of message text) of various fields in message. 
   Some fields may be used for different types of information.
*/


#define PRM_OPCODE_OFF 1  /*  Offset at which opcode is inserted             */
#define PRM_STATUS_OFF 2  /*  Usually for status codes.                      */
#define PRM_ADINF_OFF  3  /*  Additional info in some messages               */
#define PRM_JOBID_OFF  4  /*  Messages sent by the job manager and the tasks 
			      always carry a jobid at the beginning          */
#define PRM_TINFO_OFF  8  /*  Information about task(s) goes here            */
#define PRM_DLEN_OFF  12  /*  Length of data in the variable length field    */
#define PRM_FLEN_OFF  14  /*  Used when the DLEN field is divided into 2 
			      subfields */
#define PRM_DATA_OFF  16  /*  Offset at which variable length field begins   */

#define PRM_APPDT_OFF 20  /*  Data sent by appln-tasks are copied at this 
			      offset.                                        */


/*** Length of application message in a single packet.  NOTE that the max
  value of this must be less than  ARDP_PTXT_LEN - PRM_APPL_MSG_OFFSET. ***/

#define PRM_APP_MSG_LEN 1024


/* OS type used in task creation */

#define OS_UNIX 0    /* Create task using Unix fork/exec                     */
#define OS_MACH 1    /* Create task using task_create(). Not supported yet   */


/* Task status maintained by nodemngr */

#define T_RUNNING 1
#define T_KILLED  2
#define T_DEAD    3 
#define T_STOPPED 4
#define T_EXITED  5


/* Node status, maintained by sysmngr and nodemngr */

#define NODE_UNUSED    0 /* Node is free; No users or tasks running.         */
#define NODE_USER_ON   1 /* user is logged into this workstation node        */
#define NODE_JOB_ON    2 /* nodemngr is running tasks on behalf of a jobmngr */
#define NODE_UNAVAIL   3 /* Unknown status; used when sysmngr does not recv
			    reply from nodemngr                              */


/* Exit codes for jobmngr */

#define J_NORM_EXIT 0  /* Job completed normal execution                     */
#define J_NO_SM     1  /* Jobmngr couldn't establish connection with sysmngr */
#define J_INSF_RSC  2  /* Job aborted due to insufficient resources          */
#define J_NO_LOCIO  3  /* Could not create an IOtask on local node           */
#define J_NO_NM     4  /* Could not establish connection with nodemngr       */
#define J_TOO_MANY  5  /* Too many tasks requested in job description        */
#define J_KBD_SIG   6  /* Terminated by signal from keyboard                 */
#define J_AUTH_FAIL 7  /* Authorization on node manager failed               */
#define J_ARDP_ERR  8  /* Ardp library error                                 */
#define J_HOST_TYPE 9  /* Binary image task does not match with host type    */
#define J_TASK_INIT 10 /* Could not initialize task on node                  */
#define J_APPL_ERR  11 /* Error occured at application level (term_iotask)   */


/* status codes for reply messages and return values */

#define SUCCESS 0 
#define FAILURE 1
#define ERRORCODE -1


/* Support for Heterogeneity */


#define MAX_HOST_TYPES  3  /* Sun3, Sparc, and HPrisc. Add more after we
			      test on other platforms */
#define SUN3   0
#define SUN4   1
#define HP700  2

#define HOSTTYPE(hostname) ((strcasecmp(hostname,"sun3") == 0) ? 0 : \
			    ((strcasecmp(hostname,"sun4") == 0) ? 1 : \
			     ((strcasecmp(hostname,"hp700") == 0) ? 2 : -1)))

#undef MULTI_HOST  /* Do not modify. This is for future use. */



/* Officially assigned UDP-port numbers */ 

#define PRM_SM_PRIV_PORT    408
#define PRM_SM_UNPRIV_PORT 1402

#define PRM_NM_PRIV_PORT    409
#define PRM_NM_UNPRIV_PORT 1403

#ifndef NODEMNGR_PORT
#   ifdef ROOT
#      define NODEMNGR_PORT PRM_NM_PRIV_PORT
#      define SYSMNGR_PORT PRM_SM_PRIV_PORT
#   else
#      define NODEMNGR_PORT PRM_NM_UNPRIV_PORT
#      define SYSMNGR_PORT PRM_SM_UNPRIV_PORT
#   endif
#endif



#ifndef TRUE
#  define TRUE 1
#  define FALSE 0
#endif


/*
 *  getrusage function for HPUX
 */
#if defined(HPUX)
#define getrusage       hp_getrusage
#endif


typedef u_int jid_t;
typedef u_long tid_t;

typedef struct sockaddr_in  prm_node_addr;
typedef struct sockaddr_in *prm_node_addr_t;

#define LONG_SZ sizeof(long)

#define PRM_AD_SZ sizeof(prm_node_addr)

#define ADDR_COMPLETE(addr) ((addr)->sin_port && (addr)->sin_addr.s_addr)
#define ADDR_REMOTE(tgt_addr,my_addr) \
                    ((tgt_addr)->sin_addr.s_addr != (my_addr)->sin_addr.s_addr)

#define htonj htonl
#define ntohj ntohl

#define NPORTS 4   /* default number of ports per task; */

#define gettid() ((initdone && (_my_taskid >= 0) ) ? _my_taskid : ERRORCODE)

#define getjid() ((initdone && (_my_jobid  >  0) ) ? _my_jobid  : ERRORCODE)


#define SEARCH_LIST(head,item,key_field,key_val) \
     item = head; while(item && (item->key_field != (key_val))) \
                      item = item->next

#define PRM_FILE_XFER_REQD(x)    (strncasecmp((x), "io:", 3) == 0)


#endif  /* _PRM_H_INCLUDED */

