/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Modified by srao 6/92 - 9/92
 *
 */

#include <prm-copyr.h>


#include <prm.h>

#ifndef DFL_SM
#   define DFL_SM "atg.isi.edu"
#endif

#define FIRST_USR_PORT 40000

#define TIMER_INTERVAL 60    /* Default value for the timer, on whose expiry,
				the availability status of node is checked */

/* interval between checks for users, when the workstation is idle and
   when a user is logged on */

#define UNUSED_CHK_INTVL 60
#define USER_ON_CHK_INTVL 900

/* Flags for utmp checking */

#define UT_SET    0x0001  /* Activate utmp checking for this run             */
#define TM_ENBL   0x0002  /* Enable the timer alarm                          */
#define DIS_TMP   0x0004  /* Timer temporarily disabled to fork child process*/


#ifndef LOC_BIN_DIR
#  define LOC_BIN_DIR "/nfs/pfs/divirs/jmsm/new/bin"
#endif

#ifndef min
#   define min(x,y) ((x<y)? x:y)
#endif

typedef char *prm_cache_tag_t;

struct prm_task {
  tid_t              tid;           /*  Task identifier                      */
  prm_node_addr      hostaddr;      /*  Address of task's node               */
  short              t_status;      /*  current status of task               */
  u_short            nports;        /*  Number of comm. ports for this task  */
  u_short            *ports;        /*  Pointer to array port numbers        */
  struct prm_process *pid_tbl_p;    /*  Pointer to process entry in pid_tbl  */
  struct timeval     start_time;    /*  Real time at which task was started  */
  struct prm_task    *next;         /*  Pointer to next entry                */
  struct prm_task    *previous;     /*  Pointer to previous entry            */
};

typedef struct prm_task  *prm_task_t;


struct prm_job {
  jid_t              jid;            /*  Job identifier                      */
  int                numtasks;       /*  Number of tasks in job              */
  u_long             auth_key;       /*  Sysmngr furnished authorization key */
  prm_task_t         taskptr;        /*  Pointer to entries for tasks        */
  prm_node_addr      jmaddr;         /*  Addr of jobmngr's node              */
  prm_node_addr      iotaddr;        /*  Addr of term-iotask's node          */
  prm_node_addr      fioaddr;        /*  Addr of file-iotask's node          */
  prm_cache_tag_t    ctag;           /*  Tag bits to indicate whether info 
					 about a task has been cached        */
  struct prm_job     *next;          /*  Pointer to next entry               */
  struct prm_job     *previous;      /*  Pointer to previous entry           */
};

typedef struct prm_job *prm_job_t;


struct prm_process {
  int                pid;            /*  Unix process-id of task             */
  prm_task_t         taskptr;        /*  Pointer to task-info in job table   */
  prm_job_t          jobptr;         /*  Pointer to job-info in job table    */
  struct prm_process *next;          /*  Pointer to next entry               */
  struct prm_process *previous;      /*  Pointer to previous entry           */
};

typedef struct prm_process *prm_process_t;
