/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 * 
 * Written by srao 7/92 - 5/93
 *
 */

#include <prm-copyr.h>

#include <ardp.h>

#include <sys/socket.h>
#include <netdb.h>

#include <pmachine.h>
#include <pprot.h>
#include <perrno.h>
#include <prm.h>


/* Wildcard task and tag. The receiver task specifies ANY_TASK to match 
   a message from any sender and/or ANY_TAG to ignore the tag value  in
   retrieving a message  */ 

#define ANY_TASK -1
#define ANY_TAG  -1


#define RNEIGH(x,tot)    ((x<tot)?x+1:1)
  
struct tasklist {
  tid_t           tid;
  prm_node_addr_t host_addrp;  
  u_short         nports;
  u_short         *ports;         
};

struct cache {
  u_short tag;
  struct tasklist *tinfo;
};



/*     Global variables used by managers and tasks    */

#ifdef MAIN_PROG

u_long   tag = 0;
u_long  _ntasks = 0;               /*  Total number of tasks                 */
u_short _my_portnum;               /*  UDP Port number of internet socket    */
int      pfs_debug;                /*  Debug flag for Prospero               */
int      prm_debug = 0;            /*  Debug flag for PRM                    */
int      perrno;                   /*  Global error number var for prospero  */
int      pdap_errno;               /*  Global error number var for PDAP      */
int      initdone = FALSE;         /*  Set to TRUE after init routine called */
int      app_debug_lev;            /*  For debugging the application         */
char   *_progname;                 /*  Name of file containing executables   */
char     errlog[64];               /*  File for logging errors               */
jid_t   _my_jobid;                 /*  Job identifier. Used only by tasks    */
tid_t   _my_taskid;                /*  Task identifier. A small integer,     */
				   /*  unique for each task within a job     */

struct cache    *trsln_cache;      /*  Translation cache for tid/hostaddr    */
prm_node_addr_t _jm_host_addr;     /*  Host address of jobmngr               */
prm_node_addr_t _fio_host_addr;    /*  Host address of term_iotask           */
prm_node_addr_t _tio_host_addr;    /*  Host address of file_iotask           */

char _jm_hostname[MAXHOSTNAMELEN]; /*  Hostname of jobmngr host              */
char _my_hostname[MAXHOSTNAMELEN]; /*  Hostname of this process              */
char  p_err_string[P_ERR_STRING_SZ];


#else

extern  u_long   tag;
extern  u_long  _ntasks;               
extern  u_short _my_portnum;               
extern  int      pfs_debug;                
extern  int      prm_debug;            
extern  int      perrno;                   
extern  int      pdap_errno;               
extern  int      initdone;
extern  int      app_debug_lev;            
extern  char   *_progname;                 
extern  char     errlog[];               
extern  jid_t   _my_jobid;                 
extern  tid_t   _my_taskid;                

extern  struct cache    *trsln_cache;      
extern  prm_node_addr_t _jm_host_addr;     
extern  prm_node_addr_t _fio_host_addr;    
extern  prm_node_addr_t _tio_host_addr;    

extern  char _jm_hostname[]; 
extern  char _my_hostname[]; 
extern  char  p_err_string[];

#endif  /* MAIN_PROG */


/*     Functions defined in the communication library        */

extern int    vsend();
extern int    vrecv();
extern int    vsend_v();
extern int    vrecv_v();
extern int    vsendrecv();
extern int    msg_pending(int, int);
extern int    msg_sender(void);
extern int    msg_tag(void);

extern int    io_printf();
extern int    io_open(char *, int, int);
extern int    io_close(int);
extern int    io_read(int, char *, int, int);
extern int    io_write(int, char *, int, int);
extern int    io_seek(int, int, int);
extern int    io_stat();
extern int    io_delete(char *);


extern int    numtasks();
extern RREQ   get_message(); 
extern prm_node_addr_t get_dest_addr();

