/*
 *
 * Authors  : Brad Clark and Ron Wood
 * Start Dt: December 10, 1992
 * Modified: December 28, 1992 by Santosh Rao
 * Purpose : Compatibility functions for CM-5 CMMD library
 */


#include <stdio.h>
#include <comm.h>
#include <CMMDlib.h>

int
CMMD_reduce_int(value,  combiner)
     int value;
     int combiner;
{
  int redn_op_tag, ret_val;
  
  if (combiner > 4)
    redn_op_tag = ( LOGIC_REDN | combiner);
  else
    redn_op_tag = ( INT_REDN | combiner);

/*  io_printf("Calling reduce_int with tag 0x%x and value %d", redn_op_tag,
            value, (char *)0); */

  if (vsend(0, 1, redn_op_tag, (char *)&value, sizeof(int)) == ERRORCODE) {
    io_printf("vsend in CMMD_reduce_int%s", &p_err_string, (char*)0);
    return ERRORCODE;
  }
  
  vrecv(0, 1, redn_op_tag, (char *)&ret_val, sizeof(int));
  return ret_val;
} 


float
CMMD_reduce_float(value,  combiner)
     float value;
     int combiner;
{
  int redn_op_tag;
  float ret_val;
  
  redn_op_tag = ( FLOAT_REDN | combiner);
  
  if (vsend(0, 1, redn_op_tag, (char *)&value, sizeof(float)) == ERRORCODE) {
    io_printf("vsend in CMMD_reduce_float%s", &p_err_string, (char*)0);
    return ERRORCODE;
  }
  vrecv(0, 1, redn_op_tag, (char *)&ret_val, sizeof(float) );
  return ret_val;
} 


double
CMMD_reduce_double(value,  combiner)
     double value;
     int combiner;
{
  int redn_op_tag;
  double ret_val;
  
  redn_op_tag = ( DOUBLE_REDN | combiner);
  
  if (vsend(0, 1, redn_op_tag, (char *)&value, sizeof(double)) == ERRORCODE) {
    io_printf("vsend in CMMD_reduce_double%s", p_err_string, (char*)0);
    return ERRORCODE;
  }
  
  vrecv(0, 1, redn_op_tag, (char *)&ret_val, sizeof(double) );
  return ret_val;
} 




