/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 */

#include <prm-copyr.h>

#include <stdio.h>

#define  MAIN_PROG
#include <comm.h>   /* 	This file defines certain constants, and declares
			some global variables used by the message passing
			routines.  */

#ifndef RNEIGH
#   define RNEIGH(x,tot)    ((x<tot)?x+1:1) /* right neighbor of x in ring */
#endif

#ifndef LNEIGH
#   define LNEIGH(y,tot)    ((y==1)?tot:y-1)
#endif

#define MAXTIME 12                        /* Maximum computation time in sec.*/
#define INT_SZ sizeof(int)

char *progname;

main(argc, argv)
int argc;
char **argv;
{
  int ntasks, my_tid, i;
  int comp_time, intime, timeleft, iter_cnt;
  int sendto_task, rcvfrom_task;
  int data[280];
  char largeb[1120], tmp[4];

  init_task(argv);    /* Initialization is required for all tasks in every
			 application */
  pfs_debug=0;
  my_tid = gettid(); 
  if (my_tid == -1) {
    io_printf(" task could not get its tid!", (char *)0);
    exit(1);
  }
  
  largeb[0] = 0;
  if (my_tid == 1) {
    for (i = 0; i< 280; i++) data[i] = i;

    io_printf("Sending every fourth element of array to task 2", (char *)0);
    vsend_v (2, 1, 10, data, 4, 4, 279);
  }
  if (my_tid == 2) {
    for (i = 0; i< 280; i++) data[i] = 280-i;
    for (i=0; i < 280; i++) {
      sprintf(tmp, "%d ", data[i]);
      strcat(largeb, tmp);
    }
    io_printf("Initial array: %s", largeb);

    vrecv_v(1, 1, -1, data, 4, 4, 279);
    largeb[0]=0;
    for (i=0; i < 280; i++) {
      sprintf(tmp, "%d ", data[i]);
      strcat(largeb, tmp);
    }
    io_printf("Recvd array: %s from task 1", largeb);
  }
  io_printf("done.\n", (char *)0 );
  
  exit(0);
}

