/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 */

#include <prm-copyr.h>


#include <stdio.h>
#include <stdlib.h>

#define  MAIN_PROG
#include <comm.h>   /* 	This file defines certain constants, and declares
			some global variables used by the message passing
			routines.  */


char *progname;
char pathname[80], *arch;
char *tchar, *jchar;


main(argc, argv, envp)
int argc;
char *argv[], *envp[];
{
  int ntasks, my_tid, i, j ;

  init_task(argv);    /* Initialization is required for all tasks in every
			 application */
  
  pfs_debug=0;
  my_tid = gettid(); 
  if (my_tid == -1) {
    io_printf(" task could not get its tid!", (char *)0);
    exit(1);
  }
  
  tchar = argv[1]; jchar = argv[2];
  arch = getenv("ARCH");
  sprintf(pathname,"/nfs/pfs/divirs/jmsm/ardpcoll/obj/hp700/appl/ringsim",
	  arch);
  
  for (i = 0; i < 2; i++) {
    for (j = 0; j < 2; j ++) 
      run_compute_task(envp);
  }

  io_printf ("done", (char *)0);
  exit(0);
}


run_compute_task(char **ep)
{
  int status, pid;

  if ((pid = vfork()) == -1) {
    return (ERRORCODE);    /* Could not create a child process */
  }
  else if (pid) {       /* PARENT PROCESS */
    
    wait(&status);
  }
  else {
    if (execle(pathname, "ringsim", tchar, jchar, (char *)0, ep) == -1)
      fprintf(stderr, "(%s) Could not exec child program %s: ", 
	      progname, pathname);
    
    perror("");
    /* EXECV error -- return failure indicator */
    _exit (ERRORCODE);
  }
}
