/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 9/92
 *
 */

#include <prm-copyr.h>


#include <stdio.h>
#include <fcntl.h>
#include <math.h>

#define  MAIN_PROG
#include <comm.h>

#ifdef MACH386   
#  include <sys/file.h>
#  define  SEEK_SET L_SET
#  define log2(x) log(x)/log(2.0)
#else
#  ifdef HPUX
#    define srandom srand
#    define random rand
#  endif
#  include <unistd.h>
#endif


#define MAXSIZE 16384
#define K_NEIGH(x,dist) (x-dist)

char *progname;
u_char my_portid=1;
int my_tid;

struct message {
  int start_index, nitems;
  char dflname[80];
};

main(argc, argv)
int argc;
char **argv;
{
  int tmp, ntasks, msg_length;
  float *a;
  u_long jnum;
  char  *outflname;
  int dfd, mergetimes, k, two2k, two2km1, dest, first_posn, offset;
  struct message msg;
  extern char *(write_output_file());

  init_task(argv);    /* Initialization is required for all tasks in every
			 application */
  my_tid = gettid(); 
  if (my_tid == -1) {
    io_printf(" task could not get its tid!", (char *)0);
    exit(1);
  }

  
  ntasks = numtasks() ;   /* Get number of tasks in this job */
  msg_length = sizeof(struct message);

  two2km1 = 0;

  for (two2k=1; two2k <= ntasks ; two2k *= 2) {
    if ((my_tid-1)%two2k == 0) {   /* If my task number is a multiple of
					 2^k I receive data  */
      
      vrecv(-1, my_portid, -1, &msg, msg_length ); 
      /* Recv message containing name of file to read, offset into 
	 array and length */
      
      if ((dfd = io_open(msg.dflname, O_RDONLY, 0)) < 0) {
	io_printf("iter=%d, Opening file %s failed: %s", k, msg.dflname, 
		  p_err_string);
	exit(1);
      }
      if (two2k == 1) { /* In the first iteration, input data is read is from  
			   a shared data file. I have to allocate an array of 
			   the appropriate size, open the remote file through
			   the file-iotask and seek to the appropriate location
			   in the and read a subarray from that position */
	
	a = (float *)calloc(ntasks * msg.nitems, sizeof(float));

	offset = msg.start_index * sizeof(float);
#if 0
	if( io_seek(dfd, msg.start_index*sizeof(float), SEEK_SET) == -1) {
	  io_printf("seek: descriptor = %d; %s", dfd, p_err_string);
	  exit(1);
	}
#endif
      }
      else offset = 0;

      /* read data from file */
      if (io_read(dfd, a + msg.start_index, msg.nitems*sizeof(float), 
		  offset) == -1) {
	io_printf("read: pdap_errno = %d ; %s", pdap_errno, p_err_string);
	exit(1);
      }
      io_close(dfd);
      
      if(two2k == 1)  { /* in the first iteration, we do a quicksort */
	first_posn = msg.start_index;
	qsort(a, msg.start_index, msg.start_index+msg.nitems-1 );
      }
      else   {  /* in all other iterations, we merge two sorted subarrays. */
	io_delete(msg.dflname);
	msg.nitems=2* msg.nitems;
	merge(a, first_posn, msg.start_index, msg.nitems);
      }
      
      /* write the sorted subarray to an output data file */
      outflname = write_output_file(msg.dflname, a, first_posn, msg.nitems, 
				    two2k);
      
    }  /* if i had recvd data */
    
    else  { /* if i don't receive data in this iteration wheck whether i
	       need to send any data */
      if ( (my_tid-1+two2km1)%two2k == 0) { /* i send data */
	
	dest = K_NEIGH(my_tid, two2km1); /* destination is my sibling on the
					       kth level of binary tree */ 
	msg.start_index = first_posn;
	strcpy(msg.dflname, outflname);

	vsend(dest, 1, 10, &msg, msg_length);  /* send to sibling */
      }
    }
    two2km1 = two2k;

  }  /* for */

  if(my_tid == 1)  /* if i am the root of the tree, send filename to iotsk*/
    vsend(0, 1, 10, outflname, strlen(outflname)+1);

  exit(0);
}
