/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 */

#include <prm-copyr.h>


#include <stdio.h>

#define  MAIN_PROG
#include <comm.h>   /* 	This file defines certain constants, and declares
			some global variables used by the message passing
			routines.  */

#ifndef RNEIGH
#   define RNEIGH(x,tot)    (x<tot)?x+1:1 /* right neighbor of x in the ring */
#endif

#define MAX_ITER  5
#define INT_SZ sizeof(int)
#define SENDTO_PORT 1                     /* Port_id on destination task */
#define RCVON_PORT  1                     /* Port on which to rcv messages */

char *progname;

main(argc, argv)
int argc;
char **argv;
{
  int i, j, ntasks, my_tid;
  int time_dcrmt, timeleft, iter_cnt;
  int sendto_task;

  init_task(argv);    /* Initialization is required for all tasks in every
			 application */
  pfs_debug=0;
  my_tid = gettid(); 
  if (my_tid == -1) {
    io_printf(" task could not get its tid!", (char *)0);
    exit(1);
  }
  
  ntasks = numtasks();   /* Total number of tasks in this job */

  for (iter_cnt = 1; iter_cnt <= MAX_ITER; iter_cnt++) {
    if ( my_tid == 1 ) 
      for (j = 2; j <= ntasks; j++ ) {
	vrecv (j, RCVON_PORT, ANY_TAG, &i, INT_SZ);
	io_printf( "(Task %d) received iteration %d from task %d (%d)", my_tid,
		i, msg_sender(), j, (char *)0 );
      }	       
    else {
      io_printf ("(Task %d) sending  iteration %d to   task 1", my_tid, 
	       iter_cnt, (char *)0);
      vsend (1, SENDTO_PORT, ANY_TAG, &iter_cnt, INT_SZ);
    }
  }
  io_printf("task %d done.\n", my_tid, (char *)0 );
  
  exit(0);
}

