/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 */

#include <prm-copyr.h>

#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>
#define  MAIN_PROG
#include <comm.h>   /* 	This file defines certain constants, and declares
			some global variables used by the message passing
			routines.  */
#include <unistd.h>


main(argc, argv)
int argc;
char **argv;
{
  int ntasks, my_tid;
  int fd, len, fd2, len2;
  char buf[100001], *file;
  struct stat stat_buf;

  file = "/nfs/pfs/divirs/jmsm/new/bin/sun4/nodemngr";
  init_task(argv);    /* Initialization is required for all tasks in every
			 application */
  pfs_debug=0;
  my_tid = gettid(); 
  if (my_tid == -1) {
    io_printf(" task could not get its tid!", (char *)0);
    exit(1);
  }
  
  if ((fd = io_open(file, O_RDONLY, 0)) == -1) {
    io_printf("Could not open file.", (char *)0);
    exit(1);
  }
  io_printf("opened file for reading. fd= %d", fd, (char *)0);
  
  io_stat(file, &stat_buf);
  
  if (io_seek(fd, 1000, SEEK_CUR) == -1) 
    io_printf("Could not seek file");

  if ((len = io_read(fd, buf, 50000, 0)) == -1) {
    io_printf("Could not open file for reading: %s", p_err_string);
    io_printf(" done.\n", my_tid, (char *)0 );
    exit(1);
  }  
  
  io_printf("read length: %d", len);
  io_close(fd);
  
  fd2 = io_open("/nfs/pfs/divirs/jmsm/testfile", O_CREAT|O_WRONLY, 0x1B4);
  if (fd2 == -1)  {
    io_printf("could not open file for writing. %s", p_err_string);
    io_printf(" done.\n", my_tid, (char *)0 );
    exit(1);
  }  

  io_printf("opened file for writing. fd = %d", fd2, (char *)0);
  if ((len2 = io_write(fd2, buf, len, 0)) == -1) {
    io_printf("file write failed: %s", p_err_string);
    exit(1);
  }
  else 
    io_printf("write length: %d", len2);

  io_printf(" done.\n", my_tid, (char *)0 );
  exit(0);
}

