/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 6/92
 *
 */

#include <prm-copyr.h>

#include <comm.h>

#ifdef DEBUG
#   ifdef HPUX
#      include <signal.h>
#   endif
#endif

/* vsend - send a specified number of bytes of data to a specific task in
   this job.
*/

int 
  vsend(dest_task_id, dest_port_id, msg_tag, dataptr, len)
int dest_task_id, msg_tag, len;
u_char dest_port_id;
char *dataptr;
{
  PTEXT rpkt;
  RREQ newreq, pending_req;
  int ntmp1;
  char *start;
  prm_node_addr_t dest_host_addr;
  extern prm_node_addr_t get_dest_addr();
  extern PTEXT copy_to_pkts();
  int reply_code;

  if (dest_task_id == _my_taskid) {
    strcpy(p_err_string, ": Cannot send message to myself.");
    return ERRORCODE;
  }

  /* Obtain the address of the host on which destination task is running.
     This could be from the local address cache of the task, local nodemngr's 
     cache, the remote nodemngr's cache, or from the jobmngr */

  dest_host_addr = get_dest_addr(dest_task_id, dest_port_id); 


  newreq = ardp_rqalloc();
  if ( (newreq->outpkt = copy_to_pkts(dataptr, len)) == NOPKT) {
    strcpy(p_err_string, ": No data to send.");
    return ERRORCODE;
  }
  start = newreq->outpkt->start;
  prm_headers(newreq->outpkt, (u_char)PRM_APP_MSG, (u_char)0, (u_char)0, 
	      _my_jobid);
  ntmp1 = htonl(_my_taskid);
  bcopy(&ntmp1, start + PRM_TINFO_OFF, LONG_SZ);
  ntmp1 = htonl(msg_tag);
  bcopy (&ntmp1, start + PRM_DATA_OFF, LONG_SZ);
  ntmp1 = htonl(len);
  bcopy(&ntmp1, start + PRM_DLEN_OFF, LONG_SZ);
  
  if ((perrno = ardp_send(newreq, 0, dest_host_addr, -1)) != ARDP_SUCCESS) {
    sprintf(p_err_string, ": ardp_send to %d returned %d", dest_task_id, 
	    perrno);
    return -1;
  }
  
  if(rpkt = newreq->rcvd)              /* reply recvd */
    reply_code = (int)*(rpkt->start + PRM_STATUS_OFF);
  else {
    reply_code = ERRORCODE;
    sprintf (p_err_string, ": Could not reach task %d", dest_task_id);
  }
  ardp_rqfree(newreq);
  return reply_code;
}
