/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 1/93
 *
 */

#include <prm-copyr.h>

#include <comm.h>


int
prm_server_respond(RREQ req, u_char op, u_char status, int info, 
		   char *status_msg)
{
  
  u_short smsglen, nelen;
  PTEXT rpkt;
  int ninfo;
  
  if (req->outpkt)
    ardp_ptlfree(req->outpkt);
  
  rpkt = req->outpkt = ardp_ptalloc();
  prm_headers(rpkt, op, status, 0, info);
  rpkt->length = PRM_JOBID_OFF + sizeof(int);

  if (status_msg && (smsglen = strlen(status_msg))) {
    nelen  = htons(++smsglen);
    bcopy(&nelen, rpkt->start + PRM_DLEN_OFF, 2);
    bcopy(status_msg, rpkt->start + PRM_DATA_OFF, smsglen);
    rpkt->length = PRM_DATA_OFF + smsglen;
  }
  return(ardp_respond(req, ARDP_R_COMPLETE));
}


/* prm_wrong_proto: PRM message protocol version of the client's message does not match
   with the server's. An error message is sent back to the client.
*/

prm_wrong_proto(RREQ req, u_char opcode)
{
  char *msg;
  req->outpkt = ardp_ptalloc();
  msg = req->outpkt->start;
  *msg = PRM_PROTO_V;
  *(msg + PRM_OPCODE_OFF) = (u_char)opcode;
  *(msg + PRM_STATUS_OFF) = (u_char)FAILURE;
  *(msg + PRM_ADINF_OFF ) = (u_char)PRM_WRONG_VERSION;
  req->outpkt->length = 4;

  return(ardp_respond(req, ARDP_R_COMPLETE));
}
