/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 7/92
 *
 */

#include <prm-copyr.h>


#include <stdio.h>

#include <comm.h>


int
  numtasks()
{
  PTEXT pkt, rpkt;
  RREQ newreq;
  char *msg, buf[64];
  u_long ntmp1;
  int rval;
  
  if (_ntasks) return _ntasks;

  if ( _my_hostname[0] == '\0' ) {
    gethostname(_my_hostname, MAXHOSTNAMELEN);
  }
  sprintf(buf, "%s(%d)", _my_hostname, NODEMNGR_PORT);

 again:
  
  pkt = ardp_ptalloc();
  msg =  pkt->start;
  prm_headers(pkt, (u_char)PRM_NTASKS_JOB, (u_char)0, (u_char)0, _my_jobid);
  pkt->length = PRM_TINFO_OFF;
  
  newreq = ardp_rqalloc();
  newreq->outpkt = pkt;
  ardp_send(newreq, buf, 0, -1);

  if( (rpkt = newreq->rcvd) == NOPKT) {
    fprintf(stderr,"%s (jobid=%lu taskid=%d) Task-count request to nodemngr %s timed out!\n", _progname, _my_jobid, _my_taskid, _my_hostname);
    sleep(3); 
    goto again;

  }
  msg = rpkt->start;
  if ( (*(msg + PRM_OPCODE_OFF) == PRM_TASK_CNT) && 
      (*(msg + PRM_STATUS_OFF) == SUCCESS)) {
    bcopy(msg + PRM_JOBID_OFF, &ntmp1, LONG_SZ);
    _ntasks = ntmp1 = ntohl(ntmp1);
    rval = _ntasks;
  }
  else {
    if(prm_debug)
      fprintf(stderr, "(task %d) Nodemngr could not provide task count!\n", 
	      _my_taskid);
    rval = ERRORCODE;
  }
  ardp_rqfree(newreq);
  return rval;
}
