/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 3/93
 *
 */

#include <prm-copyr.h>

#include <comm.h>
#include <pdap.h>

#include <unistd.h>   

extern int perrno;
extern prm_node_addr_t get_dest_addr();

io_seek(int fd, int offset, int whence)
{
  RREQ req;
  PTEXT pkt, rpkt;
  u_long length;
  char *msg, *mstart;
  
  if (_fio_host_addr == NULL)
    _fio_host_addr = get_dest_addr(0, 2);

  req = ardp_rqalloc();
  pkt = req->outpkt = ardp_ptalloc();
  msg = pkt->start;
  
  mstart = msg + 2;
  *msg = (char)PDAP_VERSION;  ++msg;
  *msg = (char)PDAP_SEEK;     msg += 2; 
  
  *msg = (char)PDAP_HNDL_INT; ++msg;
  *msg = (char)fd;            ++msg;
  ENCODE_ASN1_LENGTH(msg,offset);
  ENCODE_ASN1_LENGTH(msg,whence);
  ENCODE_ASN1_LENGTH(msg,_my_taskid);
  
  *mstart = (char)(msg - mstart);
  pkt->length = msg - pkt->start;
  
  if ((perrno = ardp_send(req, 0, _fio_host_addr, -1)) != ARDP_SUCCESS) {
    pdap_errno = PDAP_ARDP_ERR;
    sprintf(p_err_string, "ardp_send returned %d", perrno);
    return -1;
  }

  if( (rpkt = req->rcvd) == NOPKT) {
    pdap_errno = PDAP_NO_SRVR;
    strcpy(p_err_string, "No response from File-IO task " );
    return -1;
  }
  msg = rpkt->start;
  if (*msg == PDAP_VERSION) {
    if (*(++msg) != PDAP_SEEK_RESP) {
      pdap_errno = PDAP_WRONG_RESP;
      strcpy(p_err_string, "Unexpected response code");
      return -1;
    }
    ++msg;
    DECODE_ASN1_LENGTH(msg,length);
    if ( *msg == PDAP_SUCCESS) 
      return 0;
    else {
      if (length > 1) {
	pdap_errno = (int)*(msg+2);
	bcopy(msg + 3, p_err_string, length - 2);
      }
      else
	pdap_errno = PDAP_UNKNOWN;
      return -1;
    }
  }
  pdap_errno = PDAP_WRONG_VERSION;
  strcpy(p_err_string, "Wrong PDAP version");
  return -1;
}
