/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao. 6/92
 *
 */

#include <prm-copyr.h>

#include <comm.h>

#ifndef STDOUT
#   define STDOUT 1
#   define STDERR 2
#endif


extern prm_node_addr_t get_dest_addr();
extern PTEXT copy_to_pkts();



/* Format arguments according to format and send it to iotask for output on its
   terminal */

io_fprintf(stream, format, a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15)
int stream;
char *format;
char		*a1,*a2,*a3,*a4,*a5,*a6,*a7,*a8;
char		*a9,*a10,*a11,*a12,*a13,*a14,*a15;
{
  char 	buf[MAX_DIR_LINESIZE];
  u_long ntmp;
  int len;
  char *start;
  PTEXT pkt, rpkt;
  RREQ newreq;
  sprintf(buf,format,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
  len = strlen(buf) + 1;

  if(_tio_host_addr == NULL) 
    _tio_host_addr = get_dest_addr(0, 1); /* the addr of the iotask */
  
  newreq = ardp_rqalloc();
  if( (newreq->outpkt = copy_to_pkts(buf, len)) == NULL) {
    strcpy(p_err_string, ": could not create pkt.");
    return ERRORCODE;
  }
  start = newreq->outpkt->start;

  if ((stream != STDOUT) && (stream != STDERR))
    stream = STDOUT;

  prm_headers(newreq->outpkt, (u_char)PRM_IO_PRINT, 0, (u_char)stream, 
	      _my_jobid); 
  ntmp = htonl(_my_taskid);
  bcopy(&ntmp, start + PRM_TINFO_OFF, LONG_SZ);
  
  ntmp = htonl(len);
  bcopy (&ntmp, start + PRM_DLEN_OFF, LONG_SZ);
  
  ardp_send(newreq, 0, _tio_host_addr, -1);
  
  if ( (rpkt = newreq->rcvd) == NOPKT) {
    strcpy(p_err_string, ": couldn't reach iotask");
    ardp_rqfree(newreq);
    return ERRORCODE;
  }
  ardp_rqfree(newreq);
  return SUCCESS;
}


io_printf(format, a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15)
char *format;
char		*a1,*a2,*a3,*a4,*a5,*a6,*a7,*a8;
char		*a9,*a10,*a11,*a12,*a13,*a14,*a15;
{

  return (io_fprintf(STDOUT, format, a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,
		     a13,a14,a15));
}
