/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 2/93
 *
 */

#include <prm-copyr.h>

#include <comm.h>

#if defined(HPUX)
#   include <unistd.h>   
#endif

#include <pdap.h>

extern int perrno;
extern prm_node_addr_t get_dest_addr();

io_open(char *fname, int flags, int mode)
{
  RREQ req;
  PTEXT pkt, rpkt;
  char *msg;
  u_long flen, pdap_datalen, length, n_oct;
  int io_fd;
  
  if (_fio_host_addr == NULL)
    _fio_host_addr = get_dest_addr(0, 2);
  
  req = ardp_rqalloc();
  pkt = req->outpkt = ardp_ptalloc();
  msg = pkt->start;
  
  flen = strlen(fname) + 1;
  N_OCTETS(flags,n_oct);
  pdap_datalen = flen + n_oct + 1;
  
  *msg = (char)PDAP_VERSION; ++msg;
  *msg = (char)PDAP_OPEN; ++msg;
  ENCODE_ASN1_LENGTH(msg,pdap_datalen);
  ENCODE_ASN1_LENGTH(msg,flags);
  *msg = PDAP_FS; ++msg;
  bcopy(fname, msg, flen); msg += flen;
  ENCODE_ASN1_LENGTH(msg,_my_taskid);

  pkt->length = msg - pkt->start;

  if((perrno = ardp_send(req, 0, _fio_host_addr, -1)) ) {
    pdap_errno = PDAP_ARDP_ERR;
    sprintf(p_err_string, "ardp_send returned %d", perrno);
    return -1;
  }

  if( (rpkt = req->rcvd) == NOPKT) {
    pdap_errno = PDAP_NO_SRVR;
    strcpy(p_err_string, "No response from File-IO task " );
    return -1;
  }

  msg = rpkt->start;
  if (*msg == PDAP_VERSION) {
    if (*(++msg) != PDAP_OPEN_RESP) {
      pdap_errno = PDAP_WRONG_RESP;
      strcpy(p_err_string, "Unexpected response code");
      return -1;
    }
    ++msg;
    DECODE_ASN1_LENGTH(msg,length);
    if ( *msg == PDAP_SUCCESS) {
      if(*(++msg) != PDAP_HNDL_INT) {
	strcpy(p_err_string, "Unsupported Handle Type");
	return -1;
      }
      msg += 2;
      io_fd =  *msg;
      return (int)io_fd;
    }
    else {
      if (length > 1) {
	pdap_errno = (int)*(msg+2);
	bcopy(msg + 3, p_err_string, length-2);
      }
      else
	pdap_errno = PDAP_UNKNOWN;
      return -1;
    }
  }
  pdap_errno = PDAP_WRONG_VERSION;
  strcpy(p_err_string, "Wrong PDAP version");
  return -1;
}

