/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 8/92
 *
 */

#include <prm-copyr.h>

#include <stdio.h>

#include <comm.h>

#include <errno.h>

#if defined(HPUX)
#   include <unistd.h>   
#endif

extern char *sys_errlist[];


/* create socket and bind a name to it. */

create_srv_socket(lpnum, tid)
u_char lpnum;
u_long tid;
{
  PTEXT pkt, rpkt;
  RREQ newreq;
  int ntd, ntmp1;      
  char buf[64];
  struct sockaddr_in *dest;
  u_short port_num;
  u_long nlong;
  char *msg;
  u_char st;

  if (gethostname(_my_hostname, MAXHOSTNAMELEN) == -1) {
    sprintf(p_err_string, "gethostname: %s", sys_errlist[errno]);
    return ERRORCODE;
  }
  
  sprintf(buf, "%s(%d)", _my_hostname, NODEMNGR_PORT);

  do {             /* Get an unassigned udp-port number from nodemngr */
    
    newreq = ardp_rqalloc();
    pkt = newreq->outpkt = ardp_ptalloc();
    msg = pkt->start;
    prm_headers(pkt, (u_char)PRM_ASGN_PORT, (u_char)0, (u_char)lpnum, 
		_my_jobid);

    ntmp1 = htonl(tid);
    bcopy(&ntmp1, msg + PRM_TINFO_OFF, LONG_SZ);
    pkt->length = PRM_TINFO_OFF + LONG_SZ;
    
    if (ardp_send(newreq, buf, 0, -1) != ARDP_SUCCESS) {
      fprintf(stderr, "%s (Task %d) nodemngr on %s not responding\n",
	      _progname, _my_taskid, _my_hostname);
      ardp_rqfree(newreq);
      continue;
    }
    if ((st = *(newreq->rcvd->start + PRM_STATUS_OFF)) != SUCCESS)
      ardp_rqfree(newreq);
  } while (st != SUCCESS);
  
  bcopy(newreq->rcvd->start + PRM_JOBID_OFF, &nlong, 4);
  port_num = (u_short)ntohl(nlong);
      
  ardp_rqfree(newreq);
  
  sprintf(buf,"#%d", port_num);
  port_num = ardp_bind_port(buf);
  return port_num;
}

