/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 12/92
 *
 */

#include <prm-copyr.h>


#include <stdio.h>

#include <comm.h>

bcast_to_nodes( char *buf, int len, int tag)
{
  int dest_id, n;
  
  n = ( (_ntasks <= 0)? numtasks() : _ntasks );
  
  for (dest_id = 1; dest_id <= n; dest_id++) {
    if (dest_id == _my_taskid)
      continue;

    if (vsend(dest_id, 1, tag, buf, len) != SUCCESS) {
      if (_my_taskid)
	io_printf("vsend to task %d in bcast_data_to_nodes: %s", 
		dest_id, &p_err_string, (char *)0);
      else
	printf("vsend to task %d in bcast_data_to_nodes: %s\n", dest_id,
	       p_err_string);

      return ERRORCODE;
    }
  }
  return SUCCESS;
}

