/*
 *
 * Author  : Santosh Rao
 * Start Dt: December 1, 1992
 *
 * Purpose : These macros translate some CMMD library calls and macros to
 * equivalent  calls/macros in the PRM communication library, thus enabling
 * direct compilation of programs written for the CM-5 without modification.
 * Where a macro cannot be easily written, a library function has been written
 * to run in the PRM environment.
 * 
 */


#define SYNC_NODES      0x40000000	/* synchronize nodes */
#define BCAST_TO_NODES  0x40000004	/* broadcast to nodes */
#define BCAST_DONE      0x40000008      /* Broadcast done, sent by broadcasting
					   node after all nodes have
					   acknowledged receipt of message */


/* Tags for reduction operations: Those operations that start with a distinct 
   value from every task and leave the same final result value in every task.
*/

#ifndef REDN_TAGS
#   define REDN_TAGS
#   define INT_REDN       0x40000000
#   define LOGIC_REDN     0x50000000
#   define FLOAT_REDN     0x60000000
#   define DOUBLE_REDN    0x70000000
#endif


/* Tags used for messages that are for performing global combine operations.
   The first three combiner operations can be specified on any of integer,
   float or double types. The latter three operations are for integers only. 
   */

#ifndef COMBINER_TAGS
#  define COMBINER_TAGS
#  define CMMD_combiner_add  0x00000001   /* global add operation */
#  define CMMD_combiner_max  0x00000002   /* global maximum operation */
#  define CMMD_combiner_min  0x00000003   /* global minimum operation */
#  define CMMD_combiner_ior  0x00000005   /* global inclusive OR operation */
#  define CMMD_combiner_xor  0x00000006   /* global exclusive OR operation */
#  define CMMD_combiner_and  0x00000007   /* global AND operation */
#endif


/* Indices for the Global counter array */

#define IR_ADD  (INT_REDN | CMMD_combiner_add) /* combiner integer addition */
#define IR_MAX  (INT_REDN | CMMD_combiner_max) /* combiner integer maximum */
#define IR_MIN  (INT_REDN | CMMD_combiner_min) /* combiner integer minimum */

#define LR_IOR  (LOGIC_REDN | CMMD_combiner_ior) /* combiner integer incl OR */
#define LR_XOR	(LOGIC_REDN | CMMD_combiner_xor) /* combiner integer excl OR */
#define LR_AND	(LOGIC_REDN | CMMD_combiner_and) /* combiner integer AND */

#define FR_ADD	(FLOAT_REDN | CMMD_combiner_add)  /* combiner float addition */
#define FR_MAX	(FLOAT_REDN | CMMD_combiner_max)  /* combiner float maximum */
#define FR_MIN	(FLOAT_REDN | CMMD_combiner_min)  /* combiner float minimum */

#define DR_ADD	(DOUBLE_REDN | CMMD_combiner_add) /* combiner double addtion */
#define DR_MAX	(DOUBLE_REDN | CMMD_combiner_max) /* combiner double maximum */
#define DR_MIN	(DOUBLE_REDN | CMMD_combiner_min) /* combiner double minimum */


#define DATATYP(mtag) (mtag >> 26)

#define BARR_IND(tag) ((tag | DATATYP(tag)) & 0x0000000f)


extern void   Second_Set();
extern double Second_Look();


#define CMMD_host_node                     0  /* IOtask doubles as host node */


#ifndef CMMD_DEBUG

#define CMMD_send(d,t,b,l)                 vsend(d,1,t,b,l)

#define CMMD_receive(s,t,b,l)              vrecv(s,1,t,b,l)

#define CMMD_send_and_receive(s,st,ib,il,d,dt,ob,ol) \
                                           vsendrecv(s,st,ib,il,d,dt,ob,ol)

#define CMMD_send_v(d,t,b,el,st,ec)        vsend_v(d,1,t,b,el,st,ec)

#define CMMD_receive_v(s,t,b,el,st,ec)     vrecv_v(s,1,t,b,el,st,ec)

#else

#define CMMD_send(d,t,b,l)    while (vsend(d,1,t,b,l) == -1)       \
                                CMMD_msg_err("vsend in CMMD_send%s", \
                                &p_err_string, (char *)0)


#define CMMD_receive(s,t,b,l) if (vrecv(s,1,t,b,l) == -1)       \
                                CMMD_msg_err("vrecv in CMMD_recv%s", \
                                &p_err_string, (char *)0)


#define CMMD_send_and_receive(s,st,ib,il,d,dt,ob,ol) \
                              while (vsendrecv(s,st,ib,il,d,dt,ob,ol) == -1) \
                                CMMD_msg_err("vsendrecv in CMMD_sndnrcv%s",    \
                                &p_err_string, (char *)0)
                        

#define CMMD_send_v(d,t,b,el,st,ec) \
                              while (vsend_v(d,1,t,b,el,st,ec) == -1)    \
                                CMMD_msg_err("vsend_v in CMMD_send_v%s",  \
                                &p_err_string, (char *)0)

#define CMMD_receive_v(s,t,b,el,st,ec)  \
                              if (vrecv_v(s,1,t,b,el,st,ec) == -1)    \
                                CMMD_msg_err("vrecv_v in CMMD_recv_v%s",  \
                                &p_err_string, (char *)0)


#endif


#define CMMD_receive_bc_from_host(b,l)     CMMD_receive_bc_from_node(b,l)

#define CMMD_bc_from_host(b,l)             CMMD_bc_to_nodes(b,l)

#define CMMD_self_address                  gettid

