extern RREQ ardp_pendingQ;

/*******  Added by srao 12/10/92 ************/

#include <managers.h>
#define ANY_TASK -1
#define ANY_TAG  -1

static u_long last_msg_sndr_tid, last_msg_tag;

RREQ
get_message(src_taskid, tag)
int src_taskid, tag;
{
  RREQ	cur_req;
  int	msg_sndr, curmsg_tag, tmp;
  char *curdatp;
  extern PREQ poll_for_message();

 tryagain:

  ardp_accept();

  if (ardp_pendingQ) {   /* If there are messages ardp_pendingQ          */
                   /* Check whether one of them is the requested message */

    cur_req = poll_for_message(src_taskid, tag);

    if (cur_req) {    
      /* Remove that message from the ardp_pendingQ list */

      EXTRACT_ITEM(cur_req, ardp_pendingQ);

      pQlen--; if(cur_req->priority > 0) pQNlen--;
      APPEND_ITEM(cur_req, ardp_runQ);
      return(cur_req);
    }
  }
  
  /* if requested message is not available, then wait till somethings comes */
  /* in, then go back to start                          */
  FD_ZERO(&readfds);
  if(ardp_srvport != -1) FD_SET(ardp_srvport, &readfds);
  if(ardp_prvport != -1) FD_SET(prvport, &readfds); 
  tmp = select(max(ardp_srvport,ardp_prvport) + 1, &readfds, 
	       (fd_set *)0, (fd_set *)0, NULL);

  goto tryagain;
}


RREQ
poll_for_message(req_tid, req_tag)
int req_tid, req_tag;
{
  char *curdatp;
  RREQ cur_req = ardp_pendingQ;

  while (cur_req) {
    int msg_sndr, msg_tag;

    curdatp = cur_req->rcvd->start;
    bcopy (curdatp + SNDR_TID_OFF, &msg_sndr, LONG_SZ);
    msg_sndr = ntohl(msg_sndr);
    bcopy(curdatp + TAG_OFFSET, &msg_tag, LONG_SZ);
    msg_tag = ntohl(msg_tag);
    
    if (cur_req == ardp_pendingQ) {       /* first message in queue */
      last_msg_sndr_tid = msg_sndr;
      last_msg_tag = msg_tag;
    }
    
    if ((req_tid == ANY_TASK) || (msg_sndr == req_tid))  /* sndr id matches */
      if ( (req_tag == ANY_TAG) || (msg_tag == req_tag) ) { /* tag matches */
	last_msg_sndr_tid = msg_sndr;
	last_msg_tag = msg_tag;
	return cur_req;
      }
    cur_req = cur_req->next;
  } /* while */
  
  return (RREQ)0 ;
}


msg_pending(from, tag)
int from, tag;
{
  if (poll_for_message (from, tag) )
    return 1;
  else 
    return 0;
}


msg_sender()
{
  return last_msg_sndr_tid;
}


msg_tag()
{
  return last_msg_tag;
}
