/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Author: srao
 *
 */

#include <prm-copyr.h>

#include <sys/time.h>
#include <comm.h>
#include <errno.h>
extern int errno;
extern char sys_errlist[];

/* CM-5 provides counters for measuring execution time on the nodes. PRM 
   provides only one such counter which is ITIMER_VIRTUAL, provided by
   Unix. Second_Set resets this timer and Second_Look returns the virtual
   time since the setting of the timer.
*/


void
Second_Set(i)
int i; /* We only have one counter, whatever the value of i */
{
  struct itimerval time_val, otimeval;  

  time_val.it_value.tv_sec = time_val.it_interval.tv_sec = 0x0000ffff;
  time_val.it_value.tv_usec = time_val.it_interval.tv_usec = 0;
  if(setitimer(ITIMER_REAL, &time_val, &otimeval) == -1)
    io_printf("setitimer: errno=%d", errno);

}


double
Second_Look(i)
int i;
{
  struct itimerval timeval;

  if(getitimer(ITIMER_REAL, &timeval) == -1) 
    io_printf("getitimer returned -1!", (char *)0);
  return (( (double) (0x0000ffff - timeval.it_value.tv_sec)) + 
          ((double)(0x0 - timeval.it_value.tv_usec))/1.0e+6);
}
