/*
 * Author  : Brad Clark and Ron Wood
 * Start Dt: December 10, 1992
 * Modified: December 28, 1992 by Santosh Rao
 * Purpose : Compatibility functions for CM-5 CMMD library
 *
 */


#include <comm.h>
#include <CMMDlib.h>

int
CMMD_bc_to_nodes(buffer, len)
     char *buffer;
     int len;
{
  /* Actual broadcast of data */
  if (bcast_to_nodes(buffer, len, BCAST_TO_NODES) == ERRORCODE) 
    return ERRORCODE;
  
  /* A bcast_done message */
  if (bcast_to_nodes(buffer, 1, BCAST_DONE) == ERRORCODE) 
      return ERRORCODE;

  return SUCCESS;
}


int
CMMD_receive_bc_from_node(buffer6, len)
     char *buffer6;
     int len;
{
  int rcv_len, bcast_src_id;
  
  if ( (rcv_len = vrecv (ANY_TASK, 1, BCAST_TO_NODES, buffer6, len)) == -1) {
    io_printf("vrecv in CMMD_receive_bc_from_node%s", &p_err_string, 
	      (char*)0);
    return ERRORCODE;
  }
  bcast_src_id = msg_sender();
  
  if ( vrecv(bcast_src_id, 1, BCAST_DONE, (char *)0, 0) == -1) {
    io_printf("vrecv in CMMD_receive_bc_from_node%s", &p_err_string, 
	      (char*)0);
    return ERRORCODE;
  }  
  return rcv_len;
}


