/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 */

#include <prm-copyr.h>


#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/times.h>

#define  MAIN_PROG
#include <comm.h>   /* 	This file defines certain constants, and declares
			some global variables used by the message passing
			routines.  */

#ifdef HPUX
#   define srandom srand
#   define random rand
#endif

#ifndef RNEIGH
#   define RNEIGH(x,tot)    (x<tot)?x+1:1 /* right neighbor of x in the ring */
#endif

#define MAXTIME 12                        /* Maximum computation time in sec.*/
#define INT_SZ sizeof(int)
#define SENDTO_PORT 1                     /* Port_id on destination task */
#define RCVON_PORT  1                     /* Port on which to rcv messages */


char *progname;

main(argc, argv)
int argc;
char **argv;
{
  int ntasks, my_tid, arraysize;
  int time_dcrmt, timeleft, iter_cnt;
  int sendto_task, nbytes, rbytes;
  int time_secs, time_usecs;
  double time;
  float *a;
  char fname[32];
  struct rusage rusage1, rusage2;
  FILE *ifd, *ofd;
  register int i;
  struct timeval tp1, tp2;
  struct timezone tzp;

  init_task(argv);    /* Initialization is required for all tasks in every
			 application */

  pfs_debug=0;
  my_tid = gettid(); 
  if (my_tid == -1) {
    io_printf(" task could not get its tid!", (char *)0);
    exit(1);
  }

  if( (ifd = fopen("timesend.in", "r")) == NULL) {
    perror("fopen");
    exit(1);
  }
  fscanf(ifd, "%d %d", &arraysize, &iter_cnt);
  a = (float *)calloc(arraysize, sizeof(float));
  nbytes = sizeof(float) * arraysize;

  if (my_tid == 1) { 
    vsend(2, SENDTO_PORT, ANY_TAG, a, 4); 

    gettimeofday(&tp1, &tzp);  
    for (i = 1; i<= iter_cnt; i++) 
      vsend(2, SENDTO_PORT, ANY_TAG, a, nbytes); 
    gettimeofday(&tp2, &tzp);


    time = ((double)(tp2.tv_sec - tp1.tv_sec)) +
		     ((double)(tp2.tv_usec - tp1.tv_usec)) / 1.0E+6;
    sprintf(fname, "send_timings_%d", nbytes);
    ofd = fopen(fname, "a");
    fprintf(ofd, "%d\t %f \n", iter_cnt, time);
    fclose(ofd);
  }

  else {
    vrecv(ANY_TASK, RCVON_PORT, ANY_TAG, a, 4);

    for (i=1; i<= iter_cnt; i++) 
      vrecv(ANY_TASK, RCVON_PORT, ANY_TAG, a, nbytes);
  }

  io_printf("done", (char *)0);
  exit(0);
}

