/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 9/92
 *
 *
 */

#include <prm-copyr.h>


#include <stdio.h>
#include <math.h>
#include <sys/time.h>
#include <fcntl.h>
#include <sys/param.h>

#include <comm.h>

#ifdef MACH386
#  include <sys/file.h>
#else
#  ifdef HPUX
#    define srandom srand
#    define random rand
#  endif
#  include <unistd.h>
#endif

         /* Seed for random number */

          static long state1[32]  =  {       3,       0x9a319039,
          0x32d9c024,  0x9b663182,  0x5da1f342,       0x7449e56b,
          0xbeb1dbb0,  0xab5c5918,  0x946554fd,       0x8c2e680f,
          0xeb3d799f,  0xb11ee0b7,  0x2d476b86,       0xda672e2a,
          0x1588ca88,  0xe489735d,  0x904f35f7,       0xd7158fd6,
          0x6fa6f051,  0x616e6b96,  0xac94efdc,       0xde3b81e0,
          0xdf0a6fb5,  0xf103bc02,  0x48f340fb,       0x36413f93,
          0xc622c298,  0xf5a42ab8,  0x8a88d77b,       0xf5ad9d0e,
          0x8999220b, 0x27fb47b9      };

char *progname, filename[MAXPATHLEN];

float *A;
int nelems;

struct message {
  int start_index, nitems;
  char dflname[MAXPATHLEN];
} msg;


/* THIS IS THE INITIALIZATION PROCEDURE WRITTEN BY APPLICATION PROGRAMMER */

TIO_init_procedure()
{
  int i, tmp, length, npernode, numnodes, start_index, ntasks;
  u_long jnum, ntmp1;
  FILE *dfd;
  
  do {
    printf("Enter the size of the array: "); 
    scanf("%d", &nelems);
    if (nelems > 32767)
      printf("Number too large.\n");
  } while (nelems > 32767);

  ntasks = numtasks();
  A = (float *)calloc(nelems + 1, sizeof(float));

  /* Calculate the number of items each task will get to sort initially */
  npernode = floor((double)nelems/(double)ntasks+0.5);
  
  printf("Name of data file (without suffix): ");
  scanf("%s", filename);
  if (filename[0] != '/') {  
    getwd(msg.dflname);
    strcat(msg.dflname, "/");
    strcat(msg.dflname, filename);
  }
  if ( rndgen(nelems, msg.dflname) == -1) {
    fprintf(stderr, "Could not generate random number array.\n");
    return -1;
  }

  for(i=1; i<=ntasks; i++) {  /* send filename, start_index of array and
				 length of subarray to sort to each task */

    length = (i<ntasks)? npernode: nelems-(ntasks-1)*npernode;

    msg.start_index = (i-1)*npernode;
    msg.nitems = length;

    if (vsend(i, 1, 10, &msg, sizeof(struct message)) == SUCCESS)
      printf("sent to task %d\n", i);
    else {
      printf("send error\n");
      return -1;
    }
  }
  return 0;
}


/* get output - Get a message from task 1 containing the name of output
   data file. Read the data and print it to an ascii file */

TIO_procedure(int sndr_taskid, int msg_tag, char *msg_data, int msg_len)
{
  int ofd, i;
  FILE  *od;
  char *outflname;

  outflname = msg_data;
  if( (ofd = open(outflname, O_RDONLY, 0)) < 0) {
    fprintf(stderr, "could not open %s:", outflname);
    sleep(3);
    perror("");
    exit(1);
  }
  
  /* Read sorted data file */
  if( read(ofd, A, sizeof(float)*nelems) == 0) {
    fprintf(stderr, "Error reading sorted data file!\n");
    close(ofd);
    return;
  }
  close(ofd);

  unlink(msg.dflname);
  printf("\n Sort complete. Input data file=%s.in, sorted data file=%s.out\n",
	 filename, filename);
  strcat(filename, ".out");
  od = fopen(filename, "w");
  for (i=0; i< nelems; i++)
    fprintf(od, "%f\n", A[i]);
  fclose(od);
  unlink(outflname);  /* Remove the output data file */

}




/* Generate an array of random floating point numbers */

rndgen(int n, char *datafile)
{
  int i, j, k, r1, r2;
  FILE  *fp1, *fp2;
  char datafile1[100];

  initrand(20);

  fprintf(stderr, "generating data ...");
  fflush(stderr);
  sprintf (datafile1, "%s.in", datafile); /* Open the input file for writing */
  fp1 = fopen(datafile1, "w");
  if (fp1 == NULL) {
    fprintf(stderr, "Couldn't open %s for write\n", datafile);  
    return -1;
  }
  
  for (i = 0; i< n; i++) {
    
    if ( random()&01)
      A[i]= (float) (random()%1000000)/1000-500;
    else
      A[i] = (float) (random()%1000)-500;

    fprintf(fp1, "%f\n", A[i]);
  }
  fclose(fp1);

  fp2 = fopen(datafile, "w");   /* The input file to all tasks */
  if (fp2 == NULL) {
    fprintf(stderr, "Couldn't open %s for write\n", datafile);  
    return -1;
  }
  
  fwrite(A, sizeof(float), n, fp2);
  fclose(fp2);
  fprintf(stderr, "done\n");
  return 0;
}

initrand(num)
int num;

{      
  unsigned seed;      int n;
  struct timeval tx;
  struct timezone tzx;

  gettimeofday(&tx,&tzx);

  seed =tx.tv_sec%(num*100);       n  =  128;
#if defined(HPUX)
  srand(seed);
#else
  initstate(seed,state1, n);
  setstate(state1);  
#endif
}
