/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 6/92
 *
 */

#include <prm-copyr.h>


#include <stdio.h>

#define  MAIN_PROG
#include <comm.h>   /* 	This file defines certain constants, and declares
			some global variables used by the message passing
			routines.  */

#ifdef HPUX
#   define srandom srand
#   define random rand
#endif

#ifndef RNEIGH
#   define RNEIGH(x,tot)    (x<tot)?x+1:1 /* right neighbor of x in the ring */
#endif

#define MAXTIME 25                        /* Maximum computation time in sec.*/
#define INT_SZ sizeof(int)
#define SENDTO_PORT 1                     /* Port_id on destination task */
#define RCVON_PORT  1                     /* Port on which to rcv messages */

char *progname;

main(argc, argv)
int argc;
char **argv;
{
  int ntasks, my_tid;
  int time_dcrmt, timeleft, iter_cnt;
  int sendto_task;

  init_task(argv);    /* Initialization is required for all tasks in every
			 application */
  pfs_debug=0;
  my_tid = gettid(); 
  if (my_tid == -1) {
    io_printf(" task could not get its tid!", (char *)0);
    exit(1);
  }
  
  iter_cnt = 1; 
  timeleft = MAXTIME;
  ntasks = numtasks();   /* Total number of tasks in this job */
  
  sendto_task = RNEIGH(my_tid,ntasks);   /* My right neighbor in the ring */

  srandom(_my_jobid);

  time_dcrmt = random()&7+4;   /* Number of seconds for which computation is 
				  performed */

  if (my_tid == 1) {           /* Task 1 begins sending message */
    
    sleep(time_dcrmt);         /* Simulate computation by sleeping */
    
    io_printf("**** completed iteraton %d.  ...sending message to task %d...", 
	    iter_cnt++, sendto_task, (char *)0);
    
    /* Send message to right neighbor. */ 
    while (vsend (sendto_task, SENDTO_PORT, ANY_TAG, &time_dcrmt, INT_SZ) != SUCCESS)  
      io_printf("vsend to task %d timed out!\n", sendto_task, (char *)0 );

    timeleft = timeleft - time_dcrmt;
  }

  while(timeleft > 0) {
    /* Receive message from left neighbor */
    if ( vrecv(ANY_TASK, RCVON_PORT, ANY_TAG, &time_dcrmt, INT_SZ) == -1)
      io_printf("%s", p_err_string);

    if(my_tid == 1) 
      time_dcrmt = random()&7+4;   /* task 1 calculates the computation time */
    
    io_printf("received message from task %d", (my_tid==1 ? ntasks:(my_tid-1)), 
	    (char *)0 );
    sleep(time_dcrmt);
    io_printf("**** completed iteraton %d.  ....sending message to task %d...", 
	    iter_cnt++, sendto_task, 0 );
    
    while ( vsend(sendto_task, SENDTO_PORT, ANY_TAG, &time_dcrmt, INT_SZ) != SUCCESS) 
      io_printf("vsend to task %d timed out!\n", sendto_task, (char *)0 );
    
    timeleft = timeleft - time_dcrmt;
  } /* while */
  
  if (my_tid == 1)    /* Task 1 terminates after receiving last message */
    vrecv(ANY_TASK, RCVON_PORT, ANY_TAG, &time_dcrmt, INT_SZ);

  io_printf(" done.\n", my_tid, (char *)0 );
  
  exit(0);
}

