/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 */

#include <prm-copyr.h>


#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/times.h>

#define  MAIN_PROG
#include <comm.h>   /* 	This file defines certain constants, and declares
			some global variables used by the message passing
			routines.  */

#ifdef HPUX
#   define srandom srand
#   define random rand
#endif

#ifndef NUM_ITER 
#  define NUM_ITER 500
#endif

#ifndef ASIZE
#  define ASIZE 4
#endif


#ifndef RNEIGH
#   define RNEIGH(x,tot)    (x<tot)?x+1:1 /* right neighbor of x in the ring */
#endif

float a[ASIZE];

char *progname;

main(argc, argv)
int argc;
char **argv;
{
  int i, j, ntasks, my_tid;
  int time_dcrmt, timeleft, iter_cnt, nbytes;
  int sendto_task;
  double time;
  char fname[32];
  struct rusage rusage1, rusage2;
  FILE *fd;

  init_task(argv);    /* Initialization is required for all tasks in every
			 application */

  nbytes = ASIZE * sizeof(float);
  pfs_debug=0;
  my_tid = gettid(); 
  if (my_tid == -1) {
    io_printf(" task could not get its tid!", (char *)0);
    exit(1);
  }
  
  ntasks = numtasks();   /* Total number of tasks in this job */
  
  if ( my_tid == 1 ) {
    getrusage(RUSAGE_SELF, &rusage1);
    
    for (iter_cnt = 1; iter_cnt <= NUM_ITER; iter_cnt++) {
      CMMD_bc_to_nodes(a, nbytes);
    }
    getrusage(RUSAGE_SELF, &rusage2);
    time = (double) ((rusage2.ru_utime.tv_sec - rusage1.ru_utime.tv_sec) +
		     (rusage2.ru_stime.tv_sec - rusage1.ru_stime.tv_sec) ) +
		       ((double)((rusage2.ru_utime.tv_usec - rusage1.ru_utime.tv_usec) +
				 (rusage2.ru_stime.tv_usec - rusage1.ru_stime.tv_usec)) 
			) / 1.0E+6;
    sprintf(fname, "bcast_timings_%d", nbytes);
    fd = fopen(fname, "a");
    fprintf(fd, "%d\t %d\t %f \n", NUM_ITER, ntasks, time);
    fclose(fd);
  }

  else {
    for (iter_cnt = 1; iter_cnt <= NUM_ITER; iter_cnt++) 
    CMMD_receive_bc_from_node(a, nbytes);
    
  }

  io_printf("task %d done.\n", my_tid, (char *)0 );
  
  exit(0);
}

