/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 9/92
 *
 */

#include <prm-copyr.h>


#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>

#if defined(SUNOS)
#include <vfork.h>
#endif

#include <sys/param.h>

#include <comm.h>

#if defined(HPUX)
   extern char *getcwd();
#else
   extern char *getwd();
#endif


/* 
   spawn_io: Called by the jobmngr to create a term_iotask process, using the 
   path provided in the argument list. Command line arguments passed to the 
   child are the jobid, and the udp port number assigned to the task. 
*/

spawn_io(char *disp, char *dir, char *fname, u_short pnum) 
{
  int pid, pathtrue = FALSE;
  char pathname[MAXPATHLEN], cjob[16], cport[16];
  extern char *getpath();
  
  sprintf(cjob,"%lu", _my_jobid);
  sprintf(cport,"%hu", pnum);
  
  if (dir) {
    pathtrue = TRUE;
    sprintf(pathname, "%s/%s", dir, fname); 
  }
  if ((pid = vfork()) == -1) {
    perror("vfork");
    return (ERRORCODE);
  }

  if (pid) {
    
    /* PARENT PROCESS */
    if(prm_debug > 1)
      fprintf(stderr,"(%s) Forked child process. %s pid=%d.\n", _progname,
	      pathname, pid);
    
    return (pid);
  }
    
  /* CHILD PROCESS */
  
  /* Overlay my code with requested program */
  
  if (pathtrue) {
    if( (disp == NULL) || (*disp == '\0'))
      execl(pathname, fname, cjob, cport, (char *)0); 
    else
      execlp("xterm", "xterm", "-geometry", "80x30+520+10", "-display", 
	     disp,  "-e", pathname, cjob, cport, (char *)0); 
    fprintf(stderr, "execl %s", pathname);
  }      
  else {
    execlp(fname, fname, cjob, cport, (char *)0); 
    fprintf(stderr, "execl %s", fname);
  }
  
  /* EXECV error --  */
  perror("execlp");
  _exit (ERRORCODE);
}

