/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 6/93
 *
 */

#include <prm-copyr.h>

#include <comm.h>


/* PRM_wrong_porto: Protocol version of client's request does not match with 
   that of server. Send an error message */

PRM_wrong_proto(RREQ req, u_char opcode)
{
  PTEXT pkt;

  pkt = req->outpkt = ardp_ptalloc();
  prm_headers(pkt, opcode, (u_char)FAILURE, (u_char)PRM_WRONG_VERSION, 0);
  ardp_respond(req, ARDP_R_COMPLETE);
}


prm_headers(PTEXT pkt, u_char opcode, u_char status, u_char info, jid_t jid)
{
  char *msg = pkt->start;
  jid_t tmp;

  *msg = PRM_PROTO_V;
  *(msg + PRM_OPCODE_OFF) = opcode;
  *(msg + PRM_STATUS_OFF) = status;
  *(msg + PRM_ADINF_OFF)  = info;
  tmp = htonj(jid);
  bcopy(&tmp, msg + PRM_JOBID_OFF, sizeof(u_long));

}
