/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 4/93
 *
 */

#include <prm-copyr.h>

#include <comm.h>
#include <pdap.h>

extern prm_node_addr_t get_dest_addr();

io_delete(char *fname)
{
  RREQ req;
  PTEXT pkt, rpkt;
  char *msg;
  int flen;
  u_long length, pdap_datalen ;
  
  if (_fio_host_addr == NULL)
    _fio_host_addr = get_dest_addr(0, 2);

  req = ardp_rqalloc();
  pkt = req->outpkt = ardp_ptalloc();
  msg = pkt->start;
  
  flen = strlen(fname) + 1;
  pdap_datalen = flen  + 1;
  
  *msg = (char)PDAP_VERSION;  ++msg;
  *msg = (char)PDAP_DEL;   ++msg;
  ENCODE_ASN1_LENGTH(msg,pdap_datalen);
  *msg = PDAP_FS; ++msg;
  bcopy(fname, msg, flen); msg += flen;
  ENCODE_ASN1_LENGTH(msg,_my_taskid);
  
  pkt->length = msg - pkt->start;
  
  if ((perrno = ardp_send(req, 0, _fio_host_addr, -1)) != ARDP_SUCCESS) {
    pdap_errno = PDAP_ARDP_ERR;
    sprintf(p_err_string, "ardp_send returned %d", perrno);
    return -1;
  }

  if( (rpkt = req->rcvd) == NOPKT) {
    pdap_errno = PDAP_NO_SRVR;
    strcpy(p_err_string, "No response from File-IO task " );
    return -1;
  }
  msg = rpkt->start;
  if (*msg == PDAP_VERSION) {
    if (*(++msg) != PDAP_DEL_RESP) {
      pdap_errno = PDAP_WRONG_RESP;
      strcpy(p_err_string, "Unexpected response code");
      return -1;
    }
    ++msg;
    DECODE_ASN1_LENGTH(msg,length);
    if ( *msg == PDAP_SUCCESS) 
      return 0;
    else {
      if (length > 1) {
	pdap_errno = (int)*(msg+2);
	bcopy(msg + 3, p_err_string, length - 2);
      }
      else
	pdap_errno = PDAP_UNKNOWN;
      return -1;
    }
  }
  pdap_errno = PDAP_WRONG_VERSION;
  strcpy(p_err_string, "Wrong PDAP version");
  return -1;

}
