/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 8/92.
 *
 */

#include <prm-copyr.h>

#include <stdio.h>

#include <comm.h>

#include <sys/time.h>

#if defined(HPUX)
#   include <unistd.h>   
#   include <sys/times.h>
#endif

static struct tasklist *tlist, *curtask;

get_t2h_map(remote_task_id, port_id, destp)
int remote_task_id;
u_char port_id;
struct sockaddr_in  *destp;
{
  PTEXT pkt, rpkt;
  RREQ newreq;
  char *msg, buf[64];
  u_long ntmp1;
  
  pkt = ardp_ptalloc();
  prm_headers(pkt, (u_char)PRM_ADDR_XLAT, (u_char)0, (u_char)port_id, 
	      _my_jobid);
  
  ntmp1 = htonl(remote_task_id);
  bcopy(&ntmp1, pkt->start + PRM_TINFO_OFF, LONG_SZ);
  pkt->length = PRM_TINFO_OFF + LONG_SZ;
  
  sprintf(buf, "%s(%d)", _my_hostname, NODEMNGR_PORT);
  
  newreq = ardp_rqalloc();
  newreq->outpkt = pkt;
  ardp_send(newreq, buf, 0, -1);
  
  if( (rpkt = newreq->rcvd) == NOPKT) {
    fprintf(stderr, 
	    "(jid=%lu tid=%d) Address request to nodemngr %s timed out.\n",
	    _my_jobid, _my_taskid, _my_hostname);
    return FAILURE;
  }
  msg = rpkt->start;
  if ( (*(msg + PRM_OPCODE_OFF) == PRM_XLAT_RESP) && 
      (*(msg + PRM_STATUS_OFF) == SUCCESS)) {
    bcopy(msg + PRM_DATA_OFF, destp, S_AD_SZ);
    destp->sin_family = AF_INET;
  }
  else {
    if(prm_debug)
      fprintf(stderr, "(jid=%lu tid=%d) Nodemngr could not perform t -> h translation!\n", _my_jobid, _my_taskid);
    ardp_rqfree(newreq);
    return FAILURE;
  }
  ardp_rqfree(newreq);
  if(destp->sin_port)
    return(SUCCESS);
  else
    return(FAILURE);
}


prm_node_addr_t
get_dest_addr(dest_task_id, dest_port_id)
int dest_task_id;
u_char dest_port_id;
{

  prm_node_addr_t dest_addrp;
  
  if ((dest_task_id && (trsln_cache[dest_task_id].tag == 0)) ||
      (!dest_task_id && (((dest_port_id == 0) && !_jm_host_addr) ||
			 ((dest_port_id == 1) && !_tio_host_addr) ||
			 ((dest_port_id == 2) && !_fio_host_addr) ))) {

    /* addr not cached; query nodemngr */
    dest_addrp = (prm_node_addr_t)malloc(PRM_AD_SZ);
    
    while( get_t2h_map(dest_task_id, dest_port_id, dest_addrp)  == FAILURE ) 
        /*  port address was not found. Try again. */
      sleep(5);

    /* cache the address locally */
    if (dest_task_id) {
      curtask = (struct tasklist *) malloc (sizeof(struct tasklist));
      curtask->tid = dest_task_id;
      curtask->host_addrp = dest_addrp;
      curtask->nports = NPORTS;
      curtask->ports = (u_short *)calloc(NPORTS, sizeof(u_short));
      if (dest_port_id > curtask->nports) {
	curtask->nports = dest_port_id;
	curtask->ports = (u_short *)realloc(curtask->ports, 
					    dest_port_id*2);
      }
      *(curtask->ports + dest_port_id) = dest_addrp->sin_port;
      trsln_cache[dest_task_id].tinfo = curtask;
      trsln_cache[dest_task_id].tag  = 1;
    }
    else {
      if (dest_port_id == 0)
	_jm_host_addr = dest_addrp;
      else
	if (dest_port_id == 1)
	  _tio_host_addr = dest_addrp;
	else
	  _fio_host_addr = dest_addrp;
    }
  }
  else {   /* addess has already been cached, retrieve cached info */
    if (dest_task_id) {
      curtask = trsln_cache[dest_task_id].tinfo ;
      dest_addrp = curtask->host_addrp;
      if( (dest_port_id > curtask->nports) || 
	 ( *(curtask->ports + dest_port_id) == 0)){
	/* port addr is not known. */
	while( get_t2h_map(dest_task_id, dest_port_id, dest_addrp) == FAILURE) 
	  /* port address was not found. Try again. */
	  sleep(5);
	curtask->host_addrp = dest_addrp;
	if (dest_port_id > curtask->nports) {
	  curtask->nports = dest_port_id;
	  curtask->ports = (u_short *)realloc(curtask->ports, 
					      dest_port_id*2);
	}
	*(curtask->ports + dest_port_id) = dest_addrp->sin_port;
      }
    }
    else {
      if (dest_port_id == 0)
	dest_addrp = _jm_host_addr;
      else
	if (dest_port_id == 1)
	  dest_addrp = _tio_host_addr;
	else
	  dest_addrp = _fio_host_addr;
    }
  } /* else */
  return(dest_addrp);
}

