/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 6/92
 *
 */

#include <prm-copyr.h>

#include <comm.h>

extern RREQ ardp_completeQ;

/* asend - asynchronously send a specified number of bytes of data to a 
   specific task in this job.
   dest_task_id - task identifier of destination
   dest_port_id - Always 1 in the current implementation
   msg_tag - A tag given by the application
   dataptr - pointer to the data to be sent
   len - length of the data to be sent
   req_p - A request buffer pointer in which a handle to the request is 
   returned, for use later to complete the request.
*/

int 
  asend(dest_task_id, dest_port_id, msg_tag, dataptr, len, req_p)
int dest_task_id, msg_tag, len;
u_char dest_port_id;
char *dataptr;
RREQ *req_p;
{
  PTEXT rpkt;
  RREQ newreq, pending_req;
  int ntmp1;
  char *start;
  struct sockaddr_in *dest_host_addr;
  extern struct sockaddr_in *ardp_get_dest_addr(), *get_dest_addr();
  extern void complete_pending_addr_req();
  extern PTEXT copy_to_pkts();
  int reply_code;

  if (dest_task_id == _my_taskid) {
    strcpy(p_err_string, ": Cannot send message to myself.");
    return ERRORCODE;
  }

  /* Obtain the address of the host on which destination task is running.
     This could be from the local address cache of the task, local nodemngr's 
     cache, the remote nodemngr's cache, or from the jobmngr */

  dest_host_addr = get_dest_addr(dest_task_id, dest_port_id); 


  *req_p = newreq = ardp_rqalloc();
  if ( (newreq->outpkt = copy_to_pkts(dataptr, len)) == NOPKT) {
    strcpy(p_err_string, ": No data to send.");
    return ERRORCODE;
  }
  start = newreq->outpkt->start;
  prm_headers(newreq->outpkt,  (u_char)PRM_APP_MSG, (u_char)0, (u_char)0, 0);

  ntmp1 = htonl(_my_taskid);
  bcopy(&ntmp1, start + PRM_TINFO_OFF, LONG_SZ);
  ntmp1 = htonl(msg_tag);
  bcopy (&ntmp1, start + PRM_DATA_OFF, LONG_SZ);
  ntmp1 = htonl(len);
  bcopy(&ntmp1, start + PRM_DLEN_OFF, LONG_SZ);
  

  ardp_send(newreq, 0, dest_host_addr, 0);
  return SUCCESS;
}



/* asend_done - Completes a previous asynchronous send request. Returns a 
   positive value on success, and -1 if the send was unsuccessful.
   */

asend_done(req)
     RREQ req;
{
  RREQ cmpreq;
  int reply_code, rc;
  
  if (req->status != ARDP_STATUS_COMPLETE) {
    if ((rc = ardp_retrieve(req, -1)) != ARDP_SUCCESS) {
      sprintf(p_err_string, ": ardp_retrieve returned %d", rc);
      return ERRORCODE;
    }
  }
  else {
    cmpreq = ardp_completeQ;
    while (cmpreq && (cmpreq != req))
      cmpreq = cmpreq->next;
    if (cmpreq)
      EXTRACT_ITEM(req, ardp_completeQ);
  }
  
  if(req->rcvd) {             /* reply recvd */
    reply_code = (int)*(req->rcvd->start + PRM_STATUS_OFF);
    if (reply_code == ERRORCODE) 
      sprintf(p_err_string, ": Receiver returned error code");
  }
  else {
    reply_code = ERRORCODE;
    sprintf (p_err_string, ": No response from receiver");
  }
  ardp_rqfree(req);
  return reply_code;
}
