/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 4/93
 *
 */

#include <prm-copyr.h>

#include <comm.h>
#include <pdap.h>

#include <errno.h>

extern char *sys_errlist[];

PDAP_fsrv_err(RREQ req, int err_code, char *err_msg)
{
  char *rmsg;
  int sl, len;
  
  if (req->outpkt == NOPKT) {
    req->outpkt = ardp_ptalloc();
    rmsg  = req->outpkt->start;
    *rmsg = (char)PDAP_VERSION; ++rmsg;
    *rmsg = (char)PDAP_READ_RESP; ++rmsg;
  }
  else 
    rmsg = req->outpkt->start + 2;

  sl = ((err_msg) ? strlen(err_msg) + 1 : 0);
  len = 3 + sl;
  
  ENCODE_ASN1_LENGTH(rmsg,len);
  *rmsg = (char)PDAP_FAILURE; ++rmsg;
  *rmsg = (char)0;  ++rmsg;
  *rmsg = (char)err_code; ++rmsg;
  if (err_msg) 
    bcopy(err_msg, rmsg, sl);
  req->outpkt->length = rmsg - req->outpkt->start + sl;

  ardp_respond(req, ARDP_R_COMPLETE);
}

