
/*
 * Copyright (c) 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Written by srao 3/93
 *
 */

#include <prm-copyr.h>

#include <unistd.h>
#include <errno.h>

#include <comm.h>
#include <pdap.h>

extern char *sys_errlist[];

PDAP_read_file_into_pkts(req, fd, tot_len)
int fd, tot_len;
RREQ req;
{
  PTEXT pkt_i;
  char *rmsg;
  int last_pdata_len, tot_pkts, pkt_num, read_len, copied_len=0;
  u_long nlen;

  last_pdata_len = tot_len % PDAP_DATA_PKT_SZ ;
  tot_pkts = tot_len/PDAP_DATA_PKT_SZ + (last_pdata_len > 0);
  
  if (!req->outpkt)  
    req->outpkt = ardp_ptalloc(); /* First pkt contains PDAP header info */

  for (pkt_num = 1; pkt_num <= tot_pkts; pkt_num++) {
      int this_pkt_dat_len = (((pkt_num == tot_pkts) && last_pdata_len) ?
			      last_pdata_len : PDAP_DATA_PKT_SZ);
    
    pkt_i = ardp_ptalloc();
    read_len = read(fd, pkt_i->start, this_pkt_dat_len);
    if (read_len == -1) {
      if (pkt_num > 1) {  /* Some pkts already filled. This is not the first */
	ardp_ptfree(pkt_i);
	break;
      }
      else 
	return ERRORCODE;
    }
    APPEND_ITEM(pkt_i, req->outpkt); 
    if (read_len == 0) {
      pkt_i->length = this_pkt_dat_len;
      copied_len += this_pkt_dat_len;
      break;
    }
    else {
      pkt_i->length = read_len;
      copied_len += read_len;
    }    
  }
  return copied_len;
}


PDAP_write_pkts_to_file(PTEXT pkt_list, int fd, int len, int offset)
{
  
  u_long bytes_remng, tot_bytes = 0;
  char *msg;
  PTEXT pkt_i;
  int write_len;
  
  bytes_remng = len;
  
  if (offset != 0) 
    if (lseek(fd, offset, SEEK_CUR) == -1) return -1;

  pkt_i = pkt_list;

  while(pkt_i && (bytes_remng > 0) ) {
    write_len = MIN(bytes_remng, PDAP_DATA_PKT_SZ);
    
    if (write(fd, pkt_i->start, write_len) == -1) 
      return (tot_bytes ? tot_bytes : -1);
    
    tot_bytes += write_len;
    bytes_remng -= write_len;
    pkt_i = pkt_i->next;
  }
  
  return tot_bytes;
}
