/*
 * Copyright (c) 1992, 1993 by the University of Southern California
 *
 * For copying and distribution information, please see the files
 * <prm-copyr.h>.
 *
 * Modified by srao 6/92 - 12/92
 *
 */

#include <prm-copyr.h>


#include <prm.h>

#define MAXNTASKS 32  /* Maximum number of tasks in a job. */


#define MAX_SM_HOSTS 8  /* Maximum number of sysmngrs that jobmngr can contact
			   to acquire resources from */


/* Command line option flags for jobmngr */

#define JDFILE      0x0001     /*  Job description file specified            */
#define HOSTFLAG    0x0002     /*  For historical purposes                   */
#define COMFLAG     0x0004     /*  -do-                                      */
#define SMFLAG      0x0008     /*  Sysmngr hostname specified                */
#define IOPFLAG     0x0010     /*  Termio-task path specified                */
#define TIONFLAG    0x0020     /*  Termio-executable file name specified     */
#define FIONFLAG    0x0040     /*  Fileio-executable file name specified     */
#define CMATFLAG    0x0080     /*  Adjacency matrix of communication graph   */
#define HETFLAG     0x0100     /*  Job's virtual system is a heterogeneous 
				   collection of nodes                       */

struct namelist {
  prm_node_addr_t ngbaddr;
  struct namelist *next;
};

struct taskdes {
  char            *fname;      /*  Name of executable code file              */
  char            *dirname;    /*  Directory in which above file resides     */
  prm_node_addr_t nodeaddr;    /*  Address of node on which task will run    */
  int             ndegree;     /*  Number of neighbors that I communicate w/ */
  struct namelist *ngbr;       /*  list of neighbors                         */
  u_short         port;        /*  Udp port number                           */
  int             status;      /*  Status of task, such as running, dead etc.*/
  char            *smname;     /*  Sys manager name, for later use           */
#if 0
  int             numports;    /*  number of comm. ports that this task has  */
  int             ctopo;       /*  communication topology                    */
  struct taskdes *next;
#endif

};


typedef struct taskdes *TDES;

#ifdef HPUX 
#   define exp2(x) exp(x*log(2.0))
#endif


#ifdef MAIN_PROG
  u_long *host_type;
  char *htype_list[] = { "SUN3", "SUN4", "HP700" };
#else
  extern u_long *host_type;
#endif 

