@Device(PostScript)
@Make(Manual)
@Textform{Cm="@b[@Parm(Text)]@Index[@i<@Parm(Text)>]"}
@Textform{In="@Parm(Text)@Index(@Parm[Text])"}
@Modify(ProgramExample, Size 10)
@Modify(IndexEnv, Columns 2, ColumnMargin .5 inch, Boxed)
@Style(Date="March 8, 1952")
@Style(FontFamily "TimesRoman", Size 12)
@Pagefooting(Left "Guide for OLC Consultants", Right "6 July 1990")
@pageheading(immediate)
@Tabclear()
@Tabdivide(4)

@Begin(TitlePage)
@Begin(TitleBox)
@MajorHeading(Project Athena On-Line Consulting)

@Heading(Guide for User Consultants and Volunteers)
@End(TitleBox)


7 January 1991
@CopyRightNotice(Massachusetts Institute of Technology)
@End(TitlePage)
@blankspace(6 inches)
@begin(transparent, size 8)
@i(Revision E)
Thomas Billadeau, On-line Consulting Manager

@i(Revision D)
Carla Fermann

@i(Revision C)
Tom Coppeto, Athena Systems Developer
and Chris VanHaren, Athena User Consultant

@i(Revision B)
Chris VanHaren, Athena User Consultant

@i(Revision A)
Marc Campos, Athena User Consultant
@end(transparent)
@newpage()

@set(page=1)
@pageheading(right = @value[page], immediate)
@Section(Introduction)


@Subsection(What is the On-Line Consulting System?)

The Project Athena On-Line Consulting system (OLC) allows Athena users
to ask questions of User Consultants or Volunteers logged in to other
Athena workstations.  The user begins by specifying a topic and a
question.  If a consultant@Foot(Unless otherwise mentioned,
@i[consultant] refers to either an Athena User Consultant or an OLC
Volunteer.) is available, a central program informs the two that they
are "connected".  The consultant and user can exchange messages, and
replay messages already sent during that conversation.  When the
question is answered to the user's satisfaction, he types a command
indicating that he is done.  The consultant can then review the question
and resolve it.  After resolution, a log of the conversation is saved
for later review and reference.

That is the "perfect" OLC situation: there is an available consultant
for the user, and the consultant knows the answer to the user's
question.  If a consultant is not available when the question is asked,
it is stored for the next available consultant.  If the user logs out
before the consultant can answer his question, the consultant sends a
reply via electronic mail.  If the consultant cannot answer the user's
question, he can forward it, placing it in a queue so that other
consultants can review it when they go on duty.


@SubSection[Who Should Read This Guide?]

This manual is intended for the use of Athena User Consultants and OLC
Volunteers.  User Consultants use OLC to answer user questions
electronically; it supplements phone and in-person coverage.  OLC
Volunteers are unpaid Athena users or staff who are willing to devote
some of their time and expertise in selected topics to helping other
Athena users.  OLC Volunteers offer help during User Consulting's busy
periods, and during hours that no User Consultant is on duty.@Foot(If
you are interested in becoming an OLC Volunteer, send mail to
@i[oconsult@@athena.mit.edu].)

This manual presumes a basic knowledge of Project Athena similar to the
material covered in "Getting Started on Athena" in @i(help) or the
"How to Get Around Athena" minicourse.  It describes the programs that
make up OLC, details basic commands of the consultant's response
program, explains OLC policies and procedures, and offers some hints
on how to answer OLC questions effectively. 

You will get the most from this manual if you read it while you are
logged in and using the @cm(olcr) program.  That way, you can try these
commands and see their actual output and effects.

@Subsection[Information about the Use of OLC]
From September 1, 1989 to May 21, 1990, 25,296 questions were answered
through OLC. This was done with a staff of about 16 part-time Student
Consultants, and about 30 volunteer consultants. During the 1986-87
academic year, 6,723 questions were answered.

As the system has changed and the number of users has grown,
adaptations have been made to the OLC software. Some of these changes
include Zephyr notification of new questions, allowing multiple
connections per consultant, and the ability to read through groups of
questions with one command. While these changes have greatly enhanced
the efficiency with which we are able to answer questions, they have
not increased the complexity of the OLC software.

We also develop efficiency tools which are used outside of OLC. These
include a @cm(dig) program for retrieving information from old OLC
questions, and the @cm(hes) program which is used to obtain hesiod
information easily. Also under development is an emacs-based @i(olcr)
client. 

@Subsection[If You Have Questions]

If you have any questions about this manual, using the OLC software,
or OLC in general, you should contact the OLC Manager
(@i(oconsult@@athena.mit.edu)). 

@newpage()


@Section[Components of the OLC System]


@SubSection[The @cm(olc) Program]

The @cm(olc) program is the user's side of OLC.  To start OLC, an
Athena user just types @cm(olc). Then he'll be told to type either
@b(answers), to get to the OLC answers (see section @ref[stock]), or
@b(ask), to enter a question. If he chooses ask, he'll be prompted for
one of the available question topics and the text of his question.
The @cm(olc) program allows the user to send messages to the
consultant, and to show messages sent by consultants.  He can review
the entire conversation, say that he is done with the question, or
cancel the question if he finds the answer on his own.


@SubSection[The @cm(olcr) Program]

The @cm(olcr) program is the consultant's side of OLC.  A consultant can
use @cm(olcr) in two ways.  First, a consultant can sign @i[on] to OLC,
indicating that he is willing to accept incoming OLC questions.  If a
user asks a question, and if there is an available signed-on consultant
on the priority list, then the two are connected (see section
@ref{Priorities}).  A consultant can also use @cm(olcr) in a more
selective fashion, by examining waiting questions and "grabbing" those
he can answer, rather than signing @i(on). 

In addition to the commands available to users, a consultant using
@cm(olcr) can "grab" waiting questions, resolve the current question,
send mail to the current user, forward the current question, and sign on
or off OLC.  Consultants can also refer to a set of stock answers to
common questions, and send those answers to users (see section
@ref[stock]). 

In the 7.0 Release of the Athena software, the OLCR client is version
3.0a. There are also emacs-based OLCR clients available. More
information about those clients can be found in the discuss meetings
@b(cfyi) and @b(olcd) (see section @ref[discuss]). Changes in version
of the client will be announced in @b(cfyi).


@SubSection[The @cm(olcd) Program]

The @cm(olcd) program, the OLC daemon, is the central controller for
the two other programs (olc and olcr).  The @cm(olcd) runs on one
Athena machine (currently MATISSE.MIT.EDU in building E40)@foot(The
location of the daemon can be determined by typing @b{hesinfo@ @ olc@
@ sloc} at the "athena%" prompt.).  The OLC daemon keeps track of
signed-on consultants and waiting users.  When a new question comes
in, the daemon selects an available consultant to take it (see Section
@Ref(specialties)).  All messages between the consultant and user are
sent through the OLC daemon, so that they may be logged for future
reference.  Currently, users may ask only one question at a time, but
consultants may be connected to many different questions.


The OLC daemon communicates with the consultant and user through the
@cm(olc) and @cm(olcr) programs, and through short messages sent to
their workstations.  If a consultant or user is using the
Zephyr notification system, @cm(olcd) sends him short WindowGrams
notifying him that he has been "connected", that there are new messages,
or that the question is done or forwarded.  If a consultant or user is
not using Zephyr, or if there are problems with Zephyr, @cm(olcd) uses
a @cm(write) message instead. 


@Section[Commands in @cm(olcr)]

These commands are available to consultants using @cm(olcr).  Note that
a user must be registered as an OLC consultant to use @cm(olcr).  In
order to use the correct version of @cm(olcr), you need to either be
using a 7.2 workstation, or you need to:

@begin(example)
@cm(attach olcdev)

@cm(/mit/olcdev/$bindir/olcr)
@End(Example)

The following commands can be typed at @cm(olcr)'s @t(olcr>) prompt.
Commands can be abbreviated to a unique prefix.  (For example, @b(r) is
a valid abbreviation for @cm(replay), but one must type @b(sh) for
@cm(show), as there are other commands begin with @b(s).)

Several commands have options.  For example, one can type @cm(@ send@ ), or
@cm(@ send -edit@ ) to @cm(olcr).



@SubSection[Help]

Help is available inside @cm(olcr).  Typing @cm(?) prints a list of
valid @cm(olcr) commands.  One can also type @Example(help @i[command])
to see a paragraph or two of help on that particular command.  There are
also on-line @cm(man) pages for @cm(olc) and @cm(olcr).


@SubSection[List]

The @cm(list) command can be used to list some or all of the the
questions. @cm (list) with no options will list all of the OLC queues.
An OLC queue is simply a list of current questions and the
corresponding consultants. There are currently three queues in use. 

@Begin(Itemize)
ACTIVE: questions that require a consultant's attention. Questions are
automatically placed in this queue at the time they are asked.

PICKUP: often a question is answered but for some reason the answer
cannot be mailed to the user.  This may include times when the user is
over quota, or the user's mail server is down.  The question is left in
this queue until the user re-connects to it and continues or done's the
question. Questions should also be put here when we are waiting for
information from the user.

REFER: specialized questions that require attention from a small set of
people.  Questions that you know will be answered by a particular person
may be put here @i(if you have made arrangements with the person ahead of
time).
@End(Itemize)
@newpage()
@Begin(verbatim, size 8)

olcr> l
User                     Status   Consultant   Stat ## Topic         Time
[active]
kaile@@W20-575-108   [0]  logout                      3 latex         04/12 1258
mess@@W20-575-80     [0]  active   web     [19]       3 zephyr        04/12 1435
abbott@@M34-501-12   [0]  active   pjb     [0]        2 xwindows      04/12 2000
costello@@LODGE      [0]  pending                     1 emacs         04/15 0647
brenstar@@M1-142-2   [0]  active   web     [12]       1 scribe        04/16 2005
yopat@@M16-034-9     [0]  done     carla   [1]  urg   2 scribe        04/17 0152
imbryan@@W20-575-44  [0]  active   vanharen[3]        1 scribe        04/17 0257
kaeli@@W20-575-46    [0]  active   jik     [30]       1 latex         04/17 1125
				  freda   [2]  sp1
[pickup]
miles@@M16-034-11    [0]  pickup                      4 accounts      04/12 1403
jabbedi@@M14S-010-1  [0]  logout                      2 other         04/15 0044
pjbera@@E40-008-9    [0]  logout                      1 rs1           04/15 1131
mjbel@@E40-008-8     [0]  logout                      1 emacs         04/17 1738

[refer]
crank@@M33-222-2     [0]  logout                      1 accounts      04/19 0904


@end(verbatim)



The first column of each question shows the user's username and the
machine from where he started OLC.  The second column shows the
@i(instance) of the user. In most cases, the user's instance will be
0. The only time it will be non-zero is when a consultant was
connected to a question while he asked a question. The third column
shows the status of the question.  The status can be @i[active]
(connected to a consultant), @i[unseen] (not yet seen by a
consultant), @i[pending] (seen at least once but not currently
connected), @i[logout] (the user logged out), @i[cancel] (the user
cancelled the question), @i[pickup] (the question is waiting to be
picked up by the user), @i[refer] (the question has been referred to
a particular person), or @i[done] (the user is done but the
consultant is not).  

The Consultant column shows the username of the consultant connected
to each question or signed on but not connected, and the @i(instance)
for each consultant. Only those consultants who signed on to OLC or
who grabbed a question show up in the list.  The Stat column will
indicate the level to which the consultant has signed on (sp1, dut,
sp2, urg). 

The next column shows the number of @i[different] consultants who have
been connected to the question.  (A consultant who just views the
question without taking it does not increase this count.)  When a
certain number of consultants (currently eighty) have seen a question,
it is marked as unanswered and forwarded to the unanswered questions
log for the OLC Manager's examination.  The next column shows the
topic of the question being asked.  An OLC consultant can change this
topic if the topic the user chose was incorrect, or if the topic of
the conversation changed. The last column shows when the question was
asked.

In the list above, there are eight user questions active, with five
consultants answering six questions. One consultant is signed on to
OLC and is connected, one  is signed on but is not connected, and the
rest of the consultants have @i(grabbed) questions. Four questions are
waiting for users in  the pickup queue, and one has been forwarded to
the referred queue.  

The following options are available for list:

@Begin(Itemize)
-display:  use '/usr/ucb/more' to display the list buffer

-queue <queue>: specify a queue to list exclusively (not yet available)

-status <status>: list questions of a certain status (unseen, logout, etc)

-l: a "long listing" which will display 1-line descriptions of the
questions 

-t <topic>: list questions in a certain topic
@End(Itemize)

You can combine various options. For example:

@cm(l -s logout -t scribe -display)

will give a listing of all the scribe questions from logged out users,
and display it with 'more'.

@SubSection[On and Off]

The @cm(on) command signs a consultant on to OLC, first checking that
the consultant is in the consultants' database.  The @cm(on -first)
command means that the consultant will have "first chance" at questions in
his specialties. The @cm(on -duty) command means that the consultant
is specially working on OLC duty, and may be connected to any
question.  The @cm(on -second) command means that the consultant will
be  connected to questions in his specialties after failing to match a
consultant in the above two levels.  The @cm(on -urgent) command means
that the consultant is only given a question if no other consultants
are available.  


The @cm(off) command signs a consultant off of OLC.  Typing @cm(off)
will leave you connected to your current question, but will prevent
you from being automatically connected to other questions when you
forward or done the current question. If the consultant
has a currently active question, he must resolve or forward it before
signing off.  There is a @cm[-off] options to the @cm(forward)
commands for times when a consultant wants to forward the
the current question and sign off of OLC.

User Consultants are required to sign @cm(on) to OLC whenever they are
on duty.  If possible, User Consultants on @In(Consulting Hotline)
duty should sign @cm(on -duty) with one instance. If things are too
busy in the office, consultants should sign @cm(on -urgent).  Of
course, Volunteers are not required to sign @cm(on) at any time;
questions they take and their hours are entirely up to them. 

Please remember to sign @cm(off) of OLC before you log out.  This
prevents users from being connected to a logged-out consultant.  If
OLC determines that a consultant has logged out, it will forward his
question to the next available consultant, or leave it in the queue
for future examination. 


@SubSection[Replay]

Without arguments, the @cm(replay) command displays a log of the current
conversation thus far.  The log begins with the user's real name and
username, followed by the date and time, the question topic, and the
initial question text.  Lines beginning with "---" or "***" and a
date/time notation are inserted for status messages or to indicate
that a user or consultant message follows. 

The @cm(replay username instance) command allows a consultant to see
the log of another question in progress.  @b(Username) can be
abbreviated, as long as it is unique. If the @b(instance) is 0, you
don't have to specify it.  Replaying a question allows a
consultant to preview the question before "grabbing" it.  To save a
copy of the conversation log into a file, use: @Example(replay@ @
[username]@ @ <instance>@ @ >@ @ @i[filename])  

For example, a typical log of a conversation in progress might be:
@Begin(Verbatim)

Log Initiated for user Joe R. User (jruser@@M1-142-5.MIT.EDU [0]).
    [Thu 12-Apr-90 12:58pm]

Topic:          other

Question:
How do I remove files?
--- Question grabbed by consultant carla@@NAVIGATOR.MIT.EDU [0].
    [Thu 12-Apr-90  1:07pm]

*** Reply from consultant carla@@NAVIGATOR.MIT.EDU [0].
    [Thu 12-Apr-90  1:09pm]

Use the 'delete' command, as in:

       delete  filename

--- User jruser read reply.
    [Thu 12-Apr-90  1:10pm]

*** Reply from user jruser@@M1-142-5.MIT.EDU [0].
    [Thu 12-Apr-90  1:12pm]
Okay, thanks!

--- User jruser is done with question.
    [Thu 12-Apr-90  1:13pm]

--- Resolved by carla@@NAVIGATOR.MIT.EDU.
    [Thu 12-Apr-90  1:14pm]

--- Conversation terminated at Thu 12-Apr-90  1:14pm

@End(Verbatim)


@cm(replay) can also be used to "auto-replay" groups of questions. For
example, @cm(replay -s unseen -t scribe) will replay all of the unseen
scribe questions.

@SubSection[Grab]

The @cm(grab) command allows a consultant to take a specific user's
question in the queue.  In order to grab a question, the consultant
must be below his instance limit@foot(by default, the limit is 2. To
have this increased, send mail to @i(oconsult)), and the user must not
be connected to another consultant.  Be sure to @cm(replay) a question
before grabbing it, so that you can see whether you can answer the
question.



@SubSection[Send]

The @cm(send) command sends a message to the user.  The consultant
enters the message, ending with a Control-D or a period on a line by
itself.  With the argument @cm(-edit), the @cm(send) command invokes an
editor to compose the message.  (The editor is specified by the EDITOR
environment variable, with @cm(emacs) the default.)

After the message is entered, @cm(send) asks "What now?"  The available
options are @b[s] to send the message, @b[e] to edit the message, @b[l]
to list the message on the terminal, @b[q] to quit without sending the
message, and @b[?] to get a description of the options.  The edit option
is particularly useful when one decides at the last minute to change a
message before sending it.

If the OLC daemon determines that the user has logged out when
attempting a @cm(send), it will notify you that the user has logged out.
The message you sent is not lost, however; it can be mailed to the user
via the @cm(mail) command.

When the user has read your reply, the daemon inserts a message in the
log: "User read the reply."  This is useful for ensuring that the user
has viewed all your messages before you resolve the question.


@SubSection[Show]

The @cm(show) command prints any new messages from the user or the
daemon.  You can also type @example(show@ @ >@ @ @i[filename]) to save these
messages into a file.  Note that the OLC daemon keeps track of what
messages the user and consultant have seen.  To see the entire
conversation, use the @cm(replay) command.

Note that to see the user's first message, with the topic and initial
question, you must use the @cm(replay) command.  The @cm(show) command
only works for messages the user sends using @cm(send).

It is also possible to see which messages the user has not "shown"
yet. Just do:

@cm(show -c)

and it will do a @b(show) as if you were the connected party.

@SubSection[Comment]

The @cm(comment) command inserts a comment into the conversation log.
The user is not notified of the comment but @i[can] view it if he
replays the log.  This command also has a @cm(-edit) option, and is
otherwise much like @cm(send).

One common use of the @cm(comment) command is for a consultant to leave
messages or hints for the next consultant, or for messages useful to
those reading the conversation log.  For example, a consultant might
comment on his guesses about a tough problem, or leave a comment saying
that he helped the user in person and describing the problem's solution.

You don not have to be connected to a question to put a comment in the
log. Typing @cm(comment username) will allow you to place a comment in
@i(username)'s conversation.

@SubSection[Mail]

The @cm(mail) command sends a mail message to the user.  It is usually
used when the user has logged out.  The EDITOR (or @cm(emacs) by
default) is called with "To:" and "Subject:" fields already filled
in.@footnote(Changing these fields @i[does] change the message's
destination, subject or "cc" recipients.)  Any messages the user has not
seen are automatically inserted into the editor, to save time when one
sends a long message and discovers that the user has logged out.  The
mail message is sent to the user when the editor exits, and a copy is
placed into the conversation log.

Generally, a consultant will resolve a question after sending mail.  An
exception is the case where a complete answer can't be given, so mail
lets the user know that his question is still active and someone is
working on it.  Also, it is courteous to either have your MH signature
set, or to sign your name and "User Consultant" or "OLC Volunteer"
afterwards.  That way, the user receives mail from a "real" person, not
just a username.

@SubSection[Who]

The @cm(who) command prints the real name, username, and machine of the
user your current instance is connected to.

@SubSection[Status]

The @cm(status) command will list all of your active instances. The
arrow (->) will point to the current instance. An asterisk in the NM
column means that there are new messages from that user.

@Subsection[Instance]

The @cm(instance -i @i[number]) will change you to instance
#@i[number] and tell you whom the new instance is connected to.


@SubSection[Topic]

The @cm(topic) prints the current topic. To change the topic, use
@cm(topic -t @i(new_topic)). @cm(topic ?) will give you the list of
topics. 
You should take care to make sure that the topic of the question is
correct before resolving it.  Often, a user will choose an incorrect
topic, for example thinking a problem is "emacs" when it is really
"scribe".  With a correct topic, people reading the OLC logs will see
the conversation in the correct discuss meeting.


@SubSection[Forward]

The @cm(forward) command forwards the question back into the queue.
The OLC daemon will send the question to the next available consultant,
or place it waiting in the queue if no consultant is currently
available.  If a question has been forwarded some number of times
(currently eighty), it is marked "unanswered" and becomes the
responsibility of the OLC Manager. When you forward a question, you
will be prompted for a one-line description of the question.

The @cm(-off) option signs the consultant off OLC after forwarding the
question, so the consultant will not automatically be connected to other
questions.

The @cm(-unanswered) option automatically places the conversation in the
unanswered questions log as unanswered.  This is useful in several cases:
@Begin(Itemize)

The question involves a decision on policy best left to either the OLC
Manager or the Manager of Consulting.

The question has been in the queue for more than a couple of weeks,
and it is clear that no one is able to answer it.

@End(Itemize)
If you forward a question as unanswered, it needs resolution, and you do
not intend to resolve it later, send mail to @i(oconsult) mentioning the
question and the topic.  This will ensure a speedier response.

The @cm(-s) option allows you to forward a question to a particular
status.  You must specify the status (currently @i{pending,pickup, or
refer}).

Options may be combined.  For example: 
@example(forward -off -status pickup) 
would forward the question to the pickup queue and sign the consultant
off of OLC. 

In general, User Consultants are responsible for making every attempt to
answer a question before forwarding it.  However, some reasons for
forwarding would be:
@Begin(Itemize)
You do not have time to answer the question.  (For example, you are
going off duty, or you are swamped with other "live" questions.)

You are certain that you don't know the complete answer.  A halfway
response is better than none; just send the user a message or mail, and
forward the question.

You do not have the resources necessary to answer the question, such as
a manual or handout that would be available in the Consultants' office.

You know that the question requires expertise beyond yours in the
subject, and it would take far too much time to learn enough material to
answer the question.
@End(Itemize)

If you do need to forward the question without answering, you should
send a message to the user explaining that you are forwarding his
question and why.

@Subsection[Describe]

The @cm(describe) command can be used to add a description to
question, and to get information about a question. 

@cm(describe username) will give you the name of the user, the
question status, which consultant is currently connected to the
question, the topic, the number of consultants that have been
connected, the one-line description of the question, and any
additional comments.

@cm(describe username -note) will allow you to add a one-line
description. If no username is specified, it will add the description
to the current conversation. These descriptions are displayed with
@cm(describe) or @cm(l -l)

@cm(describe username -comment) will allow you to add a longer summary
of the question. If no username is specified, it will add the summary
to the current conversation. These descriptions are displayed with
@cm(describe) only.

@SubSection[Done]

The @cm(done) command breaks the connection between the user and the
consultant.  If the user typed @cm(done), this indicates that the
question was satisfactorily answered by the consultant.  If the user
typed @cm(cancel), the @cm(done) command allows the consultant to
terminate the conversation.

Since this command terminates the user's question, the consultant should
make sure that a logged-in user has understood the given answer and
typed @cm(done) first.  Once a consultant has typed @cm(done), the
question goes to the OLC logs.  If the user wishes to use OLC again, he
must start another question.  

If there are messages which the user has not read yet, you'll be given
the option of displaying them, and then asked again if you want to
resolve the question. When the question is resolved, the consultant
will be asked to give a title for the log of this conversation.  

Consultants often wonder when they should @cm(done) questions from a
logged-out user.  In general, try to resolve questions instead of
leaving them in the queue; this leaves fewer questions for consultants
to answer later.  If you can answer the question, send the user
@cm(mail) and @cm(done) the question.

@Subsection[Cancel]

The @cm(cancel) command is used to cancel questions that are
inappropriate for OLC, such as jokes.

@SubSection[Quit]

The @cm(quit) command exits the @cm(olcr) program.  @i[Note] that
@cm(quit) just terminates the program; any active question is still
active until it is resolved or cancelled, and a signed-on consultant is
still signed on.  This command allows a consultant to temporarily exit
the program, perform other operations, and then return to @cm(olcr)
again.

@Subsection[!: Shell Escapes]

By prefacing a Unix command with @cm(!), you can execute the command
while inside the @i(olcr) program.

For example:
@begin(verbatim)
olcr> !f @@e40-008-4
@end(verbatim)

is the same as doing:

@begin(verbatim)
athena% f @@e40-008-4
@end(verbatim)
@Section[Specialties: Who Gets Which Question]
@Label(specialties)


@SubSection[What are Specialties?]

Recall that when a user asks a question in @cm(olc), he is prompted
for a topic.  The current topics are:

@begin(verbatim, size 8)
#########  Supported software
emacs             # the standard Athena editor
ez                # Andrew's near-WYSIWYG word processor
latex             # text formatter
mail              # how to send/receive/delete mail, including other sites
rs1               # statistical analysis, plotting, curve fitting and more
unix              # operating system commands and other unix utilities
xwindows          # how to manipulate/create/manage windows on the screen
zephyr            # how to send "instant notices" to friends
#########  Programming languages (syntax and how to compile programs)
c                 # how to use the C language compiler
fortran           # how to use the f77 fortran compiler
lisp              # also covers the topic "scheme"
#########  Hardware and services
#          (Hardware problem reports: call 253-1410 or send mail to 'hotline')
accounts          # problems with passwords and quota
documentation     # where and how to get athena documentation
networks          # networks accessible by Athena
operations        # fileserver down, broken hardware, printer needs paper, etc.
printing          # how to print, printer locations/capabilities
workstations      # how to reboot, using floppy drives
#########  Unsupported topics
#  We cannot guarantee that we will be able to answer these questions,
#  but we will try.
dialup            # how to dial-up to athena, terminal configuration
matlab            # multi-purpose math program (matrices, plotting, transforms)
scribe            # text formatter
#########  Other topics
other             # anything not covered by the topics listed above
#########  For test questions only
test              # use this topic for test questions only
@end(verbatim)



A @in(specialist) in one of these topics knows enough about the
subject to answer all basic and some fairly detailed questions about
it.  The OLC daemon makes an effort to connect a user to a consultant
who specializes in that question topic.

User Consultants are required to specify some of these topics as
specialties.  Volunteers may specify any they and the OLC Manager think
they are qualified for; however, a volunteer must specify at least one
to get questions when he or she signs @cm(on) to OLC.  Volunteers may
@cm(grab) questions in any topic, but they will only get assigned
questions in their specialties.

To change your specialties, contact the OLC Manager.

@SubSection[Priorities for Connecting Consultants and Users]
@label(Priorities)

The OLC daemon keeps a running queue of the waiting questions.  You can
see the queue with the @cm(list) command.  When a new question comes in,
the OLC daemon assigns a consultant in the following order:
@Begin(Enumerate)
Consultant signed @cm[on -first] with specialty in the
question topic.

Consultant signed @cm[on -duty].

Consultant signed @cm(on -second) with specialty in the question topic.

User Consultant signed @cm[on -urgent].

@End(Enumerate)

@Section[The @cm(Stock Answers) System]
@label(stock)

@SubSection[What is a Stock Answer?]

A stock answer is an answer to a commonly asked question in OLC.  These
stock answers serve two purposes.  First, with a set of stock answers,
consultants can save time by sending pre-prepared answers to the most
common questions.  Second, some stock answers are answers to questions
that are not that common but extremely difficult to answer when they
come up.  Stock answers also act as a "repository of knowledge" about
parts of the Athena system.  They are especially useful when a bug in a
new system results in many similar OLC questions.

These answers are also available directly to users through the
@cm(olc_answers) program, through @cm(help), and by typing
@cm(answers) inside @i(olc).

@SubSection[When to Use Stock Answers]

If a user asks a question that you've heard several times, there's
probably a stock answer for it.  Stock answers are best when the user
would be satisfied with a simple, short answer to his question.  Stock
answers are not as useful when the consultant and user must exchange
several messages to identify and clarify the problem.


@SubSection[How to Access Stock Answers]

To allow changes on-the-fly, the stock answers are stored in an NFS
filesystem.  To use them, type:

answers

at the @b(olcr>) prompt.


This attaches the @b(olc-stock) filesystem and starts the @In(OLC
Browser).  The browser starts in the top level, and you can go down in
the directory tree and select a specific question topic.    The
top level of the stock answers tree includes some miscellaneous
information, including instructions on what to do if the OLC daemon
crashes, and a list of new stock answers.


@SubSection[OLC Browser Commands]

To view a stock answer, or to go inside a browser directory, type the
number of the entry followed by a @b[RETURN].  While in the browser, you
can use the @b[SPACE] key to go to the next page, and @b[-] to go to the
previous page.  The @b[?]  command in the browser prints an explanation
of the available commands.  The @b[u] command allows you to move up in
the stock answer tree.  The @b[r] key will refresh a garbled screen;
refresh is especially useful after displaying the help screen.

To save a stock answer, type @b[s] followed by the number of the answer
to send.  Press @b[RETURN] to save it in the special filename reserved
so that @cm(olcr) can pick up the stock answer.  Typing @b[q] quits the
browser, returning to the "What now?" prompt or @cm(olcr).

Usually, after the "What now?" prompt, the best thing to type is
@cm(edit), so that you can add material to the stock answer or delete
items not pertinent to the current conversation.  Stock answers are not
intended to stand alone; most of them could use a short one-line
introduction and closing.


@SubSection[The @cm(olc_answers) for Users]

To access the stock answers, a user can either type @cm(olc_answers)
at his Unix prompt, or @cm(answers) inside of OLC.

@SubSection[Suggestions and Changes]

If you have any comments, changes, or new stock answers to submit, send
them to @cm[olc-stock].  Mail to olc-stock will show up in the discuss
meeting @b(ostock); further discussion on stock answers occurs
there.  Stock answers will be accepted on just about any supported or
unsupported part of the system; the intention here is to save time for
all of us by pre-writing common answers.


@Section[Consultant Communication via Zephyr]

@SubSection(Zephyr Messages from OLC)

When you connect to a user, OLC will use zephyr messages@foot(The OLC
Daemon will automatically switch to 'write' when there is a problem
with zephyr) to notify you when you are connected, when the user sends
messages, if it is unable to contact the user, and when the user
"dones" or cancels his question.

There are also other OLC zephyr messages that you can subscribe to:
@tabclear()
@tabset(3.5 inches)
@begin(format)

zctl add olc new_question@  \*@\ when a new question is entered

zctl add olc resurrection@  \*@\when a logged out user logs in

zctl add olc lonely_hearts@  \*@\when an unconnected user sends a message

zctl add olc nol@  \*@\when a consultant signs on or off

zctl add olc forward@  \*@\when a question is forwarded

zctl add olc syslog@  \*@\"interesting" OLC errors

zctl add olc syserror@  \*@\ALL OLC errors
@end(format)

@Subsection(Zephyr Messages Between Consultants)

Consultants can exchange messages while they are
logged in by using the @i(consult instance) (sometimes called
"zconsult") over Zephyr.  Some members of the Athena and Network
Services staffs also listen to these messages.

Typical uses of the consult instance would be: informing other
consultants about a broken machine or printer, asking whether OLC has
crashed, and so on.  Extended conversations should be moved to
personal messages.  @i[Remember] that since anyone can listen in to
these Zephyr messages, @cm(zconsult) messages must be brief and
polite.

Users should not send questions over the @i(consult) instance.
Instead, they should either use @cm(olc), or use the unsupported
@i(help) instance.

Neither the @i(consult) instance nor the @i(help) instance should be
used for asking questions which are in OLC.

If OLC is extremely busy, you may want to send out a plea for
additional help over the consult instance. This should not be done
unless the situation is out of hand.


@Heading[Subscribing to Consulting Messages]

You can subscribe to zconsult messages by typing:
@Example(zctl add message consult \*@Foot[The \ is necessary to prevent
the * from being expanded by the shell.])


@Heading[Sending Consulting Messages]

To send a consulting message, use:

@Example(zwrite -i consult)

Please try to keep "chatting" to a minimum.  The message will appear
as a WindowGram for all users subscribing to the the Zephyr "consult"
instance.


@Heading[Un-subscribing to Consulting Messages]

To un-subscribe to consulting messages, use @cm(zctl unsub message
consult \*).  Note that this only turns @cm(zconsult) messages off for
your current login session.  To delete a permanent subscription, type:
@Example(zctl delete message consult \*)


@Section[Policies and Rules to Remember]

In addition to the specific guidelines described above with OLC commands,
there are some more general policies that OLC consultants must follow.
Volunteers are required to sign an agreement stating that they agree to
follow these policies.  User Consultants and volunteers on the Athena
staff are not required to sign agreements, as they are already required
to follow behavior appropriate for an employee of the Institute and
Project Athena.

Serious and flagrant violation of these policies can result in serious
consequences.  (Rudeness and malicious inaccuracy would be examples of
serious policy violations.)  The OLC @In[Volunteer Agreement] may be
terminated on request by the volunteer, or by the OLC Manager if he or
she determines that the volunteer has not followed these policies.  User
Consultants and other Athena staff members may be subject to
disciplinary action in accordance with the Institute's employment
standards.

@Subsection[Rules of Use and Principles of Responsible Use]

At no time should you give a user information that is intended to help
them break one of the @i(Rules of Use) or the @i(Principles of Responsible
Use) (both memos are available through @i(help)).

@SubSection[Politeness]

The most important policy to remember is politeness.  Even when users
become abusive, the consultant must be courteous and considerate.
Imagine that you were talking to the user in person, and treat him or
her accordingly.

Consultants must also be polite to other consultants. Never make
derogatory remarks about other OLC consultants, @i[especially] during
active conversations.  Often, consultants will send hints or help via
@cm(zephyr) or @cm(write) to other consultants who have active OLC
questions.  This is not "stepping on toes"; it is a friendly way of
helping each other out.  Even if you consider the help naive or
unneeded, appreciate it as a well-meant gesture.

When you correct and incorrectly-answered question, simply let the
user know the answer he received was incorrect or incomplete, and
provide the correct answer. You should put a copy as a reply to the
transaction in the discuss meeting, and send a copy to the consultant
involved. If you think the way a consultant has handled a question was
incorrect, please contact the OLC Manager. Do not comment on poor
handling to the user.



@SubSection[Accuracy]

Accuracy is also very important.  Users come to OLC expecting complete,
accurate answers.  Everyone using @cm(olcr) is either an Athena employee
or a certified volunteer, so our accuracy image is crucial if people are
going to continue to use OLC.  If you have doubts about your answer, be
sure to let the user know.

Naturally, we all sometimes make mistakes.  If you catch a mistake in
the logs, please note the mistake in the logs and send a @i[tactful]
correction to the user and the consultant in error.  If you receive a
question and the previous consultant has made a mistake, politely
correct the other consultant's mistake and make sure the user
understands the error.


@SubSection[Promptness]

In an electronic conversation, it is often tempting to imagine that the
person on the other end doesn't exist, and to leave him or her "on the
line" for a while.  Don't.  If a question comes to you, or a user sends
you a message, try to respond to it as soon as you can.  If you are
delayed for some reason, or just outright forget, be sure to send a
short message to the user apologizing for the delay.


@SubSection[Forward Questions You Can't Answer]

It's often embarrassing to admit that you don't know an answer.  However,
if you can't answer a question, it's best to forward it.  The reason we
have a specialty system is that we try to direct questions to people who
are most experienced in particular topics.  If you forward a logged-in
user, be sure to send him a short message explaining that you can't
answer the question, and that the next available consultant will get the
question.


@SubSection[Confidentiality of Conversations]

OLC conversation logs are confidential.  They are for the use of User
Consultants, volunteers, and Athena staff members only.  The reason for
this is that unless the user is informed in advance that the
conversation may be made public, it must remain confidential.

No matter what the temptation, don't forward a conversation outside this
group, post it, or put it in @cm(.plan) files unless you have the
permission of all persons in the conversation.  It @i[is] appropriate to
put relevant conversations into OLC and User Consulting @cm(discuss)
meetings, or to forward them to the @In[Hardware Hotline], when
appropriate. 


@SubSection[Referrals to Athena Staff and other Consultants]

Athena staff members are very busy.
 Therefore, do @i[not] refer a user directly to an Athena
staff member without the staff member's permission.  Unless you are sure
that the staff member would welcome the user's question, ask first.
This saves the staff member's time, and also prevents a user from
grabbing on to a "personal" Athena staff member and pestering him or her
with questions.

A similar guideline applies about referrals to other OLC consultants.
One reason for the specialty system is that consultants who are known
experts in a topic should not be swamped with even simple questions it.
The specialty system and the OLC queue are an attempt to evenly
distribute the load.  Avoid giving out the names of other consultants,
or referring users to them, unless you are sure that they would welcome
the referral.

There are some exceptions to the general rule about staff referrals.
Questions about accounts, quotas, or changing your password address
should be referred to the Accounts Consultants (253-1325,
@i(accounts)).  Questions from faculty about courses or projects
should be referred to the Faculty Liaisons (Anne LaVin, 253-0115, and
Dot Bowe, 253-0170, E40-343A, @i(f_l)).  Questions about minicourses or
documentation may be referred to the Training and Documentation team
(Gary Dryfoos, E40-318, 253-0184).
Feel free to contact these people if you have questions about what
sorts of things they are responsible for.

Often, Athena sponsored projects have questions about software that is
only supported by Athena' Educational Initiatives Group.  Just tell these
people to talk to their Applications Developer or the Faculty Liaisons.


@Section[Tips for Answering Questions]


@SubSection[Maintain a Conversational Tone]

Remember, especially if you are connected to a logged-in user, that you
are having an interactive conversation with a real person.  So try to
keep a conversational tone, imagining that the user were right next to
you, face to face.  Say hello when you send your first message, refer to
him by his first name (@i[never] "Dear User"), and say goodbye before
you forward a question.  It is also customary to sign messages to the
user, although this is probably not necessary.


@SubSection[Keep the User Up to Date]

Between forwarding, delays, and all the other things happening in OLC,
it's easy for a user to get disoriented or feel left out.  If the user
is logged in, keep him up to date on what's going on.  If you have to
spend a while composing a long answer, send a short message saying that
there will be a delay.  If you forward the user, give a short
explanation as to why you can't answer the question.  Few things are
more disorienting to a user than being forwarded to several consultants
in a row, while none of them are saying anything about why he's being forwarded.
the run-around.


@SubSection[Prodding the Slow User to @cm(done)]

Sometimes, a user may take a while to signal that he is @cm(done) with
the question.  Perhaps he is new to OLC, and doesn't know about that
command.  Some discreet prodding can help save time for you, especially
during busy times in OLC.  If you're sending a definite answer to the
user's question, you might send something like:
@Begin(Quotation)
The available printers at Athena are ....  I hope this helps.  Do you
have any more questions?  If not, please type "done", and thanks for
using OLC.
@End(Quotation)
If the user has been idle for a while (ten or so minutes), try a message
like:
@Begin(Quotation)
Are you still there?  If you don't have any more questions, please type
"done" to the OLC prompt, and thanks for using OLC.
@End(Quotation)
This "are you there" message also serves another purpose: when it
attempts to deliver the message, the OLC daemon will notify you if the
user has logged out.

If the user has been idle for over fifteen minutes and he's still
logged in, try fingering him: @b[finger @@workstation], outside of OLC  This will
show the idle time of each of his windows.  If the user hasn't typed
anything for over fifteen minutes, either resolve the question via
@cm(mail), or @cm(forward) it (to pickup).  Use your best judgment
here; if you've asked the user to do something that will take a while,
wait a bit longer.  If you forward the question, be sure to leave a
@cm[comment] to the next consultant saying that the user's been idle.
If the user has been ignoring you (@i[i.e.] he's not idle) for over
fifteen minutes, send one last message and wait a couple more minutes.
Then resolve or forward the question.

Try to discourage users from leaving you "on the line".  If you've given
an answer, encourage them to try it out, pick up the printout, etc. and
@i[then] start a new question if they need more help.

The ten or fifteen minutes mentioned above is just a guideline, of
course.  If you have more time to spare (especially if you're not being
paid for waiting!), use your best judgment.  Some users will require
more time, others less.



@Section[The Discuss System]


@SubSection[What is Discuss?]
@label(discuss)
The @cm(discuss) system, written by members of the @In[Student
Information Processing Board] (SIPB), allows people to attend "meetings"
on a particular topic.  New meetings are announced, and @cm(discuss)
users choose those that they wish to attend.  While attending a meeting,
you can view the entries (called "transactions") in that meeting, and
add new transactions if you have permission.  Each transaction has a
subject and identifies the person who entered it.  You can view
transactions in the order they were entered, or follow a "chain" of
replies to a base transaction.

Many people complain about the user interface and lack of flexibility of
@cm(discuss).  However, it is uniquely designed to work with a networked
workstation environment.  From any workstation, you can access meetings
stored on different machines across the network.  You never need to
worry about where a particular meeting is located.  Since it is the best
networked conferencing system currently available on Athena, OLC and
User Consulting adopted it for their internal use.


@SubSection[OLC's Usage of Discuss]

The main OLC usage of @cm(discuss) is for storage of the OLC logs.
(Recall, each conversation is sent to a log after it is resolved.)  Each
topic has its own @cm(discuss) meeting.  For example, the short name of
the meeting with @i[unix] logs is @i[ounix], and its long name is
@i[OLC-unix].

The meeting @cm(ostock) is a repository for stock answer corrections,
additions, and suggestions.

Finally, one meeting is reserved for FYI (for your information) items of
interest to User Consultants and volunteers.  This @cm[cfyi] meeting
@Index(Consulting_FYI Meeting) contains timely messages (many sent by
mail to @i[cfyi]) about current machine crashes, new releases, and so
on. Everyone should at least scan @i(cfyi).

A meeting for random discussion among consultants and volunteers has
been created.  Its name is @cm(cplay) (long name @in[Consulting_Play]).

While reading of the logs is not required, it is encouraged, especially
for your specialties.  You may wish to attend a couple of meetings in
your specialties so that you can keep up to date on what kind of
questions are being asked, and also so that you can help review and
correct the answers given to those questions.


@SubSection[How to Look at OLC Logs and Other Meetings]

This guide will not try to give you a complete introduction to
@cm(discuss).  However, some basic commands will get you started reading
the OLC logs and the @i[cfyi] meeting. 

Just type @cm(discuss) to start using it.  The first time you use it,
you will be asked whether you want to create a meetings file.  Reply
"yes".  Next, to attend the OLC and Consulting meetings, you must add
them to your personal meetings list.  To add the meetings that don't
contain the OLC logs, enter the following commands inside discuss:
@begin(example)

am menelaus:/usr/spool/discuss/cfyi

am menelaus:/usr/spool/discuss/cplay

am menelaus:/usr/spool/discuss/ostock

am menelaus:/usr/spool/discuss/olcd
@end(example)

To add the o@i(topic) meetings, give the commands:
@begin(example)
am matisse:/usr/spool/discuss/o@i(topic)   [replace @i(topic) with 
the topic you're interested in]
@end(example)
Once you have a particular meeting in your meetings list, you can use
the @cm(go) command to attend it.  (Either the short name or the long
name will work.)  Once in a meeting, you can use the @cm(ls) command to
see the titles of all transactions in the meeting.  You can also use the
@cm(print) command to see a particular transaction by number, or just
the transactions you haven't read ("print new").  Finally, the @cm(quit)
command exits the program.

There are two ways to see new transactions in the meetings to which you
subscribe.  The easiest way is to use the @cm(read_new) (rn) command.
If you enter @cm(discuss) and type @cm(rn), you will see the meetings
with new transactions.  Then, just keep hitting the @b[SPACE] bar to
view the next transaction, or to go to the next meeting, until you have
seen everything new.  Unfortunately, the @cm(rn) command does not let
you skip meetings or transactions without quitting and starting over.
The slower way of reading new transactions is to type the
@cm(check_meetings) command (ckm), and then to type the
@cm(next_meeting) command (nm) to go to each meeting with new
transactions.  Once inside a meeting, you can type "print new" to print
all new transactions, or "print A:B" to print all transactions numbered
A through B.


@SubSection[For More Information on Discuss]

More information about discuss is available in the on-line help. To
get to it, just type @b(help), then go to the section "Communicating
with Other Users", then "Discussion Lists".

@Section[The OLC Staff]


@Subsection[Manager of User Consulting]

Project Athena's On-Line Consulting service is a part of its User
Consulting department.  As such, it is under the supervision of the
full-time Consulting Manager, currently Beth Anderson (@i[beth]).
The Consulting Manager is responsible for the set of end-user
consulting services offered by Project Athena, Consulting's interface
to other divisions and Senior Managers, and oversight of the
Consulting staff, which consists of both full-time and part-time
consultants. (You may sometimes see her helping out in OLC.)


@SubSection[OLC Manager]

The OLC Manager, currently Thom Billadeau is responsible for
the day to day operations of OLC and the evolution of the OLC software
system for use by Consulting.  He is responsible for ensuring that
OLC is properly manned by User Consultants, and for ensuring that
questions are answered courteously and accurately.  He recruits and
screens of new OLC volunteers.  Finally, he is responsible for
keeping User Consultants and volunteers up to date on the current
state of OLC, both in Consultants' meetings and through written
documentation.


@SubSection[OLC Development]

Lucien Van Elsen, a systems developer working for User Services, keeps
the OLC daemon running, fixes bugs in the OLC programs, and makes
improvements.  Mail about bugs in OLC should be reported with
@b(sendbug) (please include information about which client you were
using!), suggestions should be mailed to "olcd".

@begin(comment)
@SubSection[OLC Administrator]

The OLC Administrator (@i[oadmin]) makes sure everything runs smoothly
in OLC.  He or she is responsible for distributing documentation,
keeping complete files, taking statistics on OLC usage, and other
administrative duties.  The OLC Administrator also acts as the main
contact for OLC volunteers, supplying them with documentation and help
with OLC.

Unfortunately, because of Athena budget cuts, we do not currently have
an OLC Administrator.  Many of these responsibilities are now taken by
the OLC Manager and the Manager of Consulting.  However, some things
like distribution of address and volunteer lists are being postponed.
We are trying to simplify the tasks needed to keep OLC running, and
trying to maximize the number of things that can be done electronically.

@end(comment)
@SubSection[User Consultants]

Most User Consultants are part-time Athena student employees.  They are
responsible for answering user questions about Athena.  You can reach an
Athena User Consultant in person, on the phone, or through OLC during
Consulting Hotline hours (room 11-115, 253-4435).  User Consultants are
sometimes also on duty in other clusters, such as the Student Center.


@SubSection[OLC Volunteers]

We have a wide variety of volunteers helping out with OLC.  Some of them
are full-time Athena staff members, while others are part-time student
employees.  Some others are affiliated with the SIPB, while many are
"independent" student volunteers.  Volunteers provide a wide variety
of expertise. Some are system programmers, some documentation
writers, some quality assurance engineers, some operations personnel,
some telecommunications experts, and some experts in particular packages.




@Appendix[Other OLC's]

Currently,  a version of the OLC software is also being run as
@cm[OLTA] (contact Anne LaVin, @i(lavin)) for more information). 

Some other sites are starting to use OLC as well. The ones we know of
are @cm(Iowa State University) and @cm(North Carolina State
University). 


@Appendix[OLC Question Counts]












