.LP
.nr PO 1.25i
.nr LL 6.0i
.nr HM 1.0i
.nr FM 1.0i

.ps 14
.TL
OLC: An On-Line Consulting System for
.UX
.sp 1
.AU
.ps 12
Thomas J. Coppeto
Beth L. Anderson
Daniel E. Geer, Jr.
.AI
Project Athena
Massachusetts Institute of Technology
Cambridge, MA  02139
{tjcoppet,beth,geer}@ATHENA.MIT.EDU

.AU
.ps 12
G. Winfield Treese
.AI
Cambridge Research Laboratory
Digital Equipment Corporation
Cambridge, MA  02139
treese@CRL.DEC.COM
.AU
.ps 11
.AB
Helping users learn the intricacies of
.UX,
particularly in a custom environment, is always a challenge.  Helping
thousands of users in an environment that is distributed both
geographically and computationally is especially difficult.  Project
Athena has developed an ``On-Line Consulting'' system (OLC) that
enables users to ask questions of consultants located ``somewhere on
the network.''  OLC allows a staff on the order of twenty students to
handle the questions and problems of over 8000 users on a network of more
than 900
workstations. This paper describes the motives and design goals for OLC,
its implementation, and some of the results of its three years of operation.
.AE
.sp 4
.pn  0
.ps 11
.NH
Background on Project Athena 
.PP
Project Athena was originally conceived as a five-year experiment in the
uses of computers in undergraduate education at the Massachusetts Institute
of Technology.  With support from Digital Equipment Corporation and
International Business Machines Corp., M.I.T. embarked on the construction
of a distributed computing environment built on scientific/engineering
workstations (VAXstation II and RT/PC).  In addition to this environment,
Athena has funded over one hundred projects for developing educational
software for use in the M.I.T. curriculum.  In 1988, Project Athena was
extended by M.I.T, Digital, and IBM for three years.  An
overview of the Project can be found in ref[1].
.R
.PP
The Project Athena computing environment is built on a network services
model 
of computation.
Virtually every resource used during a login session is supplied by a remote
server:
software, personal files, mail, message-of-the-day, printing,
.I etc.
Athena
currently has installed over eight hundred workstations and seventy server
machines yet the operations staff numbers approximately eight.
A central requirement of all services is that they permit easy
upward growth in numbers.    
The Athena model of computation and building such a distributed environment 
is described more fully in
a series of papers presented at the Winter 1988 USENIX Conference.
.PP
The computing experience of Athena users covers a wide spectrum, from
those who have never used a computer to advanced
.UX
hackers.  Even experienced
.UX
users often have questions,  especially since Athena has augmented the 
basic system
with several additional software packages.
Currently, there are approximately 10,000
registered users of Project Athena.
.NH
The Problem of Consulting
.PP
Each September, more than 1,000 new undergraduates arrive at M.I.T.  Many of
them are eager to start using Athena workstations at once 
while others will wait
until required to do so by enrolling in a class that uses the Athena system.
In either case most students must learn to use the
computing environment during their study at M.I.T.
.PP
.UX
has never been regarded as an easy system to learn, and the process is
complicated by the network server configuration and the
addition of other software packages (
.I e.g.,
the X Window System.)  This problem was recognized early in the
Project, and a consulting staff was established to assist users by
answering their questions
about the system.  Most consultants have been
undergraduates who work for Athena part-time.  In addition to the paid
consultants, many students have volunteered their time to assist other
users with the use of the Athena system. These OLC volunteers were
originally Athena staff and members of the Student Information
Processing Board (SIPB) at M.I.T., but the group has expanded to include
many other users.
.PP
From the beginning, it has been impossible to provide consulting
coverage in all locations twenty-four hours a day, seven days a week.
In 1984 the need to provide some kind of on-line support for consulting
became clear and work on OLC began.
.NH
.pn 0
The On-Line Consulting System
.PP
OLC is designed to be the rendezvous service between users and user
consultants.  Transactions between users and consultants are immediate.
If there are no consultants available at the time a user asks a question,
the question is held until the question is answered, even if the
user logs out. A user may be helped by only one consultant at a time, however,
her question may be passed from consultant to consultant or remain in a
queue until the question is 
resolved. OLC is also designed to take advantage of other services in the
Athena service environment in a way that does not compromise the basic
reliability constraint.
.PP
The complete OLC system consists of three pieces: a user program
.I (olc),
a consultant's response program
.I (olcr),
and the coordinating daemon
.I (olcd).
In addition to these programs, there is a collection of ``stock answers'' or
prepared responses to common questions.   Athena
has also established certain management procedures for using OLC which are
described later in this paper.
.NH 2
Design Goals
.PP
Some aspects of the design of OLC are those common to the design of any
network service.  OLC must be:
.PP
.IP Scalable: 14
One of the goals of Project Athena is to provide a
large-scale 
computing environment with minimal operational overhead. OLC must be 
able to quickly process and maintain large numbers of requests and
to meet increased demand gracefully.
.IP Reliable:
The service should be available whenever any user requires it (all the
time).
.IP Recoverable: 14
If the system crashes, it should
recover with minimal human intervention, preferably with none at all. OLC
should restore its state such that all current conversations are preserved.
.IP Usable: 14
In some ways, OLC provides the equivalent of a ``help'' system.
When a user understands nothing else, he should be able to
easily use OLC to contact a consultant without first asking how to use
the program.
.IP Inexpensive: 14
As the user population grows, it is inevitable that OLC is to become a
service provided 
by users, for users.  OLC must therefore be simple to manage and maintain.
.LP
.NH 2
The OLC Daemon
.PP
This daemon provides a central rendezvous for user questions
such that  consultants can read and answer them. All user-consultant
transactions 
are mediated by the daemon so it can handle proper notification, logging,
and scheduling of the questions and transactions.
.PP
.pn 0
.NH 3
Connections
.PP
The daemon maintains the 
connections between users and consultants. A user may be
connected to only one consultant and vice-versa. Connections
are 
merely symbolic pointers within the daemon. OLC clients do not interact
directly with each other. This has the advantage of maintaining reliable,
current logs of all transactions and state data.  
.PP
.NH 3
Types
.PP
Three different classifications of users are currently 
defined in the OLC daemon:
.PP
1. User who is asking a question
.PP
2. Staff consultant
.PP
3. OLC volunteer
.PP
Any user, including registered consultants, may ask a question. Active
questions entered by consultants do not interfere with their role as
consultants. Consultants come in two flavors but their functions are
identical. The distinction is made merely to allow staff consultants extra
flexibility within the system (see below). 
A consultant is registered in
the OLC database by the OLC manager.
.PP
.NH 3
Specialties & Priorities (Auto-connection)
.PP
Users are best served when their questions are tended to promptly.
Consultants may 
.I
sign on
.R
in OLC so that the daemon will automatically connect them to waiting users.
The daemon will connect the consultant to the first user in the queue whose
question topic matches one of the consultant's declared specialties.
A specialty is a topic in which the consultant has a strong  
background, indicating a routing preference for questions.
The specialty is declared in the OLC database by the OLC manager.
.PP
The daemon will connect new questions with consultants currently signed on.
This is determined by the level at which the consultant signs on and by his
specialty list. A staff consultant may sign on at one of three levels (in
order of priority):
.IP 
on duty
.IP 
on
.IP 
on urgent
.LP
The duty level is the front line; consultants signed on at this level
are connected to users ahead of any other consultants signed on. 
The urgent level is useful when
someone wishes to help users, but only if no other consultants are available.
.PP
The OLC volunteer may only sign on one level. 
If there is more than one consultant on a given level,
a new  question is given to one of those consultants with a specialty in
that question topic. In addition, volunteers will not automatically
connect to questions with topics outside of their specialty list. This
feature allows for volunteers who are knowledgeable in a few areas of
the system, yet
may know little about other areas.
.PP
This design not only serves users promptly, but makes technical matches
between users and consultants.
.PP
.NH 3
.pn 0
Logging
.PP
All transactions between a user and a consultant are stored in a log which
resides on the
server. This feature is necessary so that questions can be transferred
among consultants.
.PP
Upon the resolution of a question the daemon forwards the
conversation log to a third party archive service. The logs are
categorized by the topic of the question asked. The daemon is configured
to work with the 
.I notes 
conferencing system developed at the University of Illinois (ref[3]), or the
.I discuss
networked conferencing system developed by the Student Information
Processing Board at M.I.T. (ref[4]).
These logs are kept as an official record of all
transactions over OLC. Often a consultant will need to refer to a past
conversation for reference or another consultant may scan the logs for
accuracy and polite interaction. 
The OLC logs are a useful mechanism for Project Athena to
evaluate itself by noting common problems and questions about the system.
.PP
The consulting staff uses this information to prepare itself for
commonly asked questions by creating stock answers (see section 3.5). 
The logs are also a useful
pulse of the community.
.PP
.NH 3
Notification
.PP
The daemon will notify users and consultants of any status changes to their
conversation such as a new connection or message (See section 4.4).
.PP
.sp 1
.PP
.in 1i
.DS L
% olc
Welcome to OLC, Project Athena's On-Line Consulting system.
Copyright (c) 1988 by the Massachusetts Institute of Technology.
.sp .5
If you need help with this program, type 'help' at the "olc>" prompt.
.sp .1
There are 2 busy consultants, with 4 waiting users.
.sp 1
There is still one machine in building 4 down due to hardware problems.
This should not affect most people, although some workstations in
buildings 16, 4, and 2 may not work correctly. Repairs may extend over 
the weekend.
                        -- 8:00PM, September 30
.sp 1
Please type a one-word topic for your question.  Type ? for a list of
available topics or ^D to exit.
.DE
.sp .1
Topic: 
.I workstations
.DS L
.sp 0
Please enter your question. End with a ^D or '.' on a line by itself.
.I 
How do I get a clock on my screen?
^D
.R
.sp .4
There is no specialist currently available for topic 'workstations'. Your
request will be forwarded to the first available consultant.
olc> 
.DE 
.B 
Figure 1: 
.R 
The olc startup screen (with typical contents)
.in -1i
.PP
.sp 2
.NH 3
.pn 0
Host Requirements
.PP
The OLC daemon runs on a private secure host to avoid tampering with user
conversations or logs. The host must be accessible via TCP/IP connections
within the distributed environment. In addition it must have enough
accessible disk space to house the active conversations and the resolved
logs. 
.PP
.NH 2
User Client: 
.I olc
.PP
.NH 3
The startup screen
.PP
When a user starts olc, the client displays three pieces of information 
(see Figure 1):
.PP
1. How to get help within the program: every command may be explained
by 'help <command>'. These explanations are straight forward and simple
to avoid generating additional questions.
.PP
2. The status of the OLC queue:  the queue itself is hidden from the
user. However users are generally interested in knowing about how
long it may be until their questions are seen by a consultant. This
status provides the number of consultants and the number of active
users in the queue. The user may request this information  during an OLC
session.
.PP 
3. A short message of the day: Occasionally an event may occur within
the system which causes many users to ask the same question.
To ease the load on consultants  in such an event, 
.I olc 
displays a short message
which may account for down systems, etc. 
This message can be used to display OLC down times,
system problems,  consulting
hours, or even new ways to get help on the system.
.PP
.NH 3 
Use of olc
.PP
After 
.I olc 
displays the message of the day, 
the user is then asked to supply a topic from a predefined set 
and the text of his question. This
is all that the user is required to do until she is connected to a
consultant. 
During the time the user waits, she may send additional messages which will
be held for the consultants in  
the user's log, query the status of the queue, or exit 
.I olc 
and do other
computing in the meantime. When the user re-enters 
.I olc, 
the client will skip
the initial query for a topic and question and place the user at the OLC
prompt. At this point the user may send new messages or replay the
conversation so far.
.PP
The two commands the user must  know are
.I show
and
.I send.
.I Send 
will take additional input from the user which will be appended to the
log on the server. If the user is connected to a consultant, then the
server will notify the consultant of the user's new message. 
.I Show 
will display new messages from the consultant
(see figure 4 for an example).
.PP
.NH 2
Consultant reply program: olcr
.PP
.I Olcr 
is essentially 
.I olc 
with additional commands to manipulate connections
with users. Consultants have the ability to connect to users, send messages
to the connected user, forward or resolve the user
questions (see 
.I 
Figure 5 
.R
for an example).
.PP
.NH 3
The OLC queue
.PP
The OLC queue seen by the consultant is shown in
.I
Figure 2.
.R
The list contains all the essential information in OLC. The two left
columns display the user name, location, and status. The status may be one
of 
.I
unseen, pending, active, 
.R or
.I logout.
.R
The next column lists the consultant's username. 
A consultant listed on the same line
as the user indicates that he is connected to that user. 
The last columns display
the number of consultants who have been connected to that user and the
topic of his question. It is possible to configure the daemon so that it
will forward the question to a log when a certain number of consultants have
been connected to the question but have failed to resolve it. 
This feature prevents the ever increasing size of the queue and bouncing of
unanswerable or difficult questions inside the queue. The OLC Manager (see
.I
section 5
.R
) can take care these forwarded logs at a later time.
.PP
.NH 3 
.pn 0
When a user logs out
.PP
Olcr has the ability to send mail to a user in the event the user should
log out while having a pending question in the queue. This feature enables
consultants to eliminate already answered questions in the queue and allows
the user to see consultant responses. 
.PP
In the Athena system, Mail is forwarded to a central mail hub.
The Athena mail hub is a separate
service which delivers mail to the appropriate address. The olcr client will
notify the consultant if the user is unknown to this service. Specific user
addresses may also be specified for use with more traditional systems.
.PP 
.NH 2
Stock Answers
.PP
After OLC was first put into service, it was discovered that users frequently
asked the same, or very similar, questions.  For example, ``How can I print
my paper?'' is a common question.  There were
also a number of less common but somewhat technical questions, such as
``How can I link my C program with a FORTRAN library?''  It was tedious for
consultants to retype answers to common questions, and difficult to write
answers quickly for more technical topics.  
Over time, consultants began to keep
individual caches of answers, and occasionally these caches would be
shared with other consultants.
.PP
Once the problem was recognized, a solution was obvious.
The consultants gathered a collection of these
``stock answers,'' and a simple browser program was written to enable
consultants to find an appropriate stock answer quickly.  Once found,
the answer could be tailored to the specific question and sent to the user.
.PP
Stock answers are organized in a hierarchy, with the categories and placement
of answers determined by the OLC manager.   The browser interface is
similar to that of
.I notes 
(see 
.I
Figure 3
.R
).
.PP
Single-letter commands are executed immediately with no carriage
return required; an entry is selected by typing its number as
displayed in a menu on the screen.  The browser has full support for saving
entries to files and for adding new entries.  Some experience with the
interface is required to use it easily, but it works very quickly once it 
has been mastered.  Currently, the browser is also available to users
as a supplementary set of on-line documentation.
.PP
.sp 1
olcr> 
.I list
.PP
.TS
tab (/); 
l l l l . 
User/Status/Consultant/Topic
hyland@M66-080-2.MIT.EDU/(pending)//(2) emacs
jamarroq@HAWAII.MIT.EDU/(logout)/geer@E40-342F-2.MIT.EDU/(5) fortran
mcampos@GRILL.MIT.EDU/(logout)/beth@KLEE.MIT.EDU/(2) xwindowsystem
gmbelaus@BECKS.MIT.EDU/(logout)//(1) scribe
twleung@E40-358D-1.MIT.EDU/(logout)//(1) mail
enprahba@RENOIR.MIT.EDU/(pending)//(3) unix
annette@GRUMPY.MIT.EDU/(active)/elsj@M4-035-10.MIT.EDU/(1) other 
carla@SNOOPY.MIT.EDU/(active)/vanharen@FRIES.MIT.EDU/(1) accounts
tjcoppet@PICASSO.MIT.EDU/(pending)//(1) lisp
not connected//treese@CIROCCO.MIT.EDU/  
not connected//tjcoppet@PICASSO.MIT.EDU/
.TE
olcr>                               
.PP
.B 
Figure 2:
.R
The OLC queue as displayed in olcr
.sp 2
.PP
.PP
Currently, an interface for the X Window System (ref [5]) 
is under development.  Advantages of this version include the ability to
view a directory of entries and a particular entry simultaneously as well
as a ``friendlier'' method of finding desired entries.  It is possible that
a more general ``help'' system can be based on this interface.
.NH 
Interaction with Other Athena Services
.NH 2
Athena mail hub
.PP
To control the flow of mail within the Athena network, as well as in and
out of Athena, all mail is sent to a central mail server which
has the information to forward the mail
to the appropriate location. These locations are known as Post Offices, ref[6],
which are essentially 
mail holding servers. The user can use any one of the mail clients
available on Athena to retrieve and read their mail messages without 
knowing about the 
existence of these servers.
.NH 2
Hesiod
.PP
Hesiod, ref[7], provides name service for Project Athena. 
The clients
query the Hesiod service for the location of the OLC server. This
location may be changed at any time without altering the any of the OLC
programs.
.PP
.pn 0
.NH 2
Kerberos
.PP
In an environment of more than 800 public workstations on an insecure
network it is necessary to confirm the identity of 
the
consultant when he is assisting users within the OLC system.
Services at Project Athena use a third party service called Kerberos,
ref[8], 
to
perform this authentication. As a policy, the 
OLC daemon refuses connections from
consultants who fail this authentication mechanism. Currently
no authentication is required to ask a question because
a user may have a question about this authentication
system and turn to OLC
to find the answer. 
.PP
.NH 2
Zephyr
.PP
The OLC daemon sends all notifications directly to the user. Normally
this would occur via a system
.I write 
message to the user's terminal or workstation,
however, this requires the OLC daemon know which machine the user is logged
into at all times.
This is not possible when a user logs out and logs in again at another
machine, and does not make any requests from olc which would update
his location.
To solve the problem of finding a user on the network,
Project Athena has developed a location
and notification service known as 
.I Zephyr,
ref[9]. 
The OLC daemon sends
notifications via this service, and, by default, the user will
receive the notification at the tty or inside a 
.I windowgram
which is essentially a small window containing the notice OLC has sent.
This is however user configurable and if this system fails, the user will
receive the message directly from the UNIX write function.
.PP
.in 1i
.DS L
                           On-Line Consulting Browser
                 /usr/athena/lib/olc/stock/stock_answers/emacs


                 1  Controlling the emacs window size
                 2  Using the mouse buttons in Emacs 
                 3  Moving the cursor without the mouse
                 4  Finding what line you are on
                 5  How to set a mark 
                 6  Line number mode in Emacs
                 7  How to set auto-fill by default
                 8  How to recover Emacs autosave files
                 9  Customizing Emacs using a .emacs file
                10  How to use Emacs with scheme
                11  How to use Emacs with a newer scheme
                12  Using TAGS in Emacs
                13  Rebound keys for VT240

                               ** End of Index **

   olc_browser>  
.DE
.in -1i
.B 
Figure 3:
.R
The OLC Stock Answer browser (a typical display)
.sp 2

.PP
.NH 2
Network dependencies
.PP
The first requirement for a functional OLC system is that 
the OLC server be
operational. If the OLC daemon is running on a working machine the
clients simply need to establish a TCP/IP connection. Generally if the user
can successfully log into a workstation, he can successfully use OLC. The
only third party service requirements are
.I Hesiod
for the name service,
.I Kerberos
for authentication, and of course, the user must be able to obtain the
client. At 
Athena, the
client is delivered via a cluster library server which provides most of
the essential software to workstations in a particular location. If any
one of these should fail, the workstation is unusable.
.PP
Interaction with other services like
.I Zephyr
is non-essential since the daemon is capable of sending notifications
directly to the user's workstation.
.PP
.NH 
Managing OLC
.PP
.NH 2
OLC database
.PP
The database resides on the daemon host. It contains a list of usernames
allowed to act as consultants along with the topics in which they
are specialists. The
usernames may be marked to indicate if the consultant is a volunteer. This file
is stored in ASCII text so it may be edited easily.
.PP
The OLC topics are listed in a separate file and also stored in ASCII text. 
Since the
daemon will file conversations by topic, it is necessary that the logging
mechanism be updated for any changes to this topic file. Either file may be
edited without 
halting the daemon. 
.PP
.NH 2
.pn 0
The OLC queue
.PP
Some difficult questions may linger in the queue, especially if the
user logs out since logged out users will not be automatically connected to
a consultant. It is advantageous to keep the OLC queue short. 
Large queues
often contain many questions from users who logged out and did not provide
sufficient 
information so that a consultant could send a definite answer.
.PP
In general, every question is answerable by at least
one member of the Athena staff. It is ultimately
the job of the OLC manager to find the answer to difficult questions. 
In rare cases, such as
requests about network addresses of remote hosts or debugging of
large programs, the user is given information on how to help himself.
Often this is a reference to materials off-line.
.PP
.NH 2
Orientation
.PP
The OLC manager is also responsible for orienting new consultants and
volunteers with the proper use of the 
.I olcr
client. An olcr manual exists but orientation is geared toward 
handling difficult situations with users that might lead to misunderstandings
or arguments. Since OLC is one of the major user interfaces to Project
Athena, it is necessary to ensure smooth communication between users and
consultants.
.PP
.NH 
Problems and Future Directions
.PP
Soon OLC will
allow consultants to answer multiple questions simultaneously. The
advantage is that other users may be served while a consultant is waiting
for one user to respond, i.e. consultants will be more efficiently utilized. 
.PP
As more OLC volunteers are added, OLC approaches the model of a
system of users consultation  provided by users. These volunteers are largely
responsible for the success of OLC. The  number of
volunteers will gradually increase to fill the need.
.PP
An invaluable source of information about the functionality of the system
and consultant performance can be found in the OLC logs. However, the 
man-power required to read over 6000 questions each term is greater than
what Athena is 
able to provide. 
.PP
The limits of OLC scale are dependent upon the limits of the OLC server
(an estimated 300 questions). With some work, the OLC system can be
expanded to utilize multiple servers simultaneously. Each OLC server
may be responsible for some area of specialty or area of administration.
The limits on the type of scale is dependent upon the limits of
Athena's authentication, notification, and name services across internet
regions. 
.PP
.NH
Conclusion
.PP
A team of 10 consultants and 20 volunteers provide help to
users 24 hours each day. Even when a particular consultant may not know the
answer to a question or problem, it is reassuring to the user to know that
he is able to contact another person on the network. 
OLC has proven to be the solution for providing user assistance on a
broadly
distributed network system.
.PP
.NH 
.pn 0
Acknowledgments
.PP
The original design of Project Athena's OLC (based on an on line consulting
system provided by Information Services at M.I.T.) was done by Bill Saphir.
Dan Morgan and G. Winfield Treese of Project Athena continued the
implementation through to a usable system.
.PP
We would also like to thank Marc Campos, Theodore Leung, and Gregory Belaus
for maintaining 
and providing
new ideas for the OLC system; Carla Fermann, Chris VanHaren, and Linda Kim
for reviewing early drafts of this paper.
.PP
.NH 
Sample OLC sessions
.PP
The following pages contain sample 
.I olc
and 
.I olcr
sessions. The text contained in the boxes are asynchronous notifications
sent by the daemon via 
.I Zephyr
or 
.I /bin/write.
.sp 5i
.DS L
.I
(continued from Figure 1) 
.R
.B1
Message from OLC daemon...
You are connected to consultant Tom Coppeto (tjcoppet@PICASSO.MIT.EDU)
Tom has received your question.
.B2
.DE
.DS L
.B1
Message from OLC daemon...
Tom has sent a reply.
To read it, use the 'show' command from olc.
.B2
.DE
olc> 
.I show
.DS L
.sp -.5
time: 88/09/28 03:07:23
.sp .5
Hi Joe,
.sp .5
To get a clock on your screen type:
              xclock &
When your cursor changes to an upside down L, click the left mouse button
where you want the clock to appear.
.sp .5
                                      - Tom
.DE
olc> 
.I send
.DS L
.sp .1
Enter your message. End with a ^D or '.' on a line by itself.
.I 
Thank you.
-Joe
^D
.R
.sp .3
.DE
What now?
.I send
.DS L
.sp .-.5
Message sent.
.DE
olc> 
.I done
.DS L
.sp ..2
Using this command means that the consultant has satisfactorily answered
your question.  If this is not the case, you can exit using the 'quit' command,
and OLC will save your question until a consultant can answer it.  If you
wish to withdraw your question, use the 'cancel' command.
.DE
.sp -.5
Really done? [y/n]
.I y
.PP
.DS L
.sp -.5
Goodbye from OLC.  Glad to be of service!
%
.pn 0
.B1
Message from OLC daemon...
Tom has marked your question resolved.
.B2
.DE
.PP
.B 
.sp .5
Figure 4:
.R
An example olc session with joe user.
.sp 20
.PP
.bp
.bp 
.PP
.sp 5
.DS L
.B1
Message from OLC daemon on MATISSE.MIT.EDU...
You are connected to user Joe User (jruser@SOMEWHERE.MIT.EDU)
.B2
.DE
olcr> 
.I replay
.sp .2
.DS L
Log Initiated for user Joe User (jruser@SOMEWHERE.MIT.EDU)
        (88/09/28 03:14:45)

Topic:          workstations
.sp .5
Question:
How do a get a clock on my screen?
___________________________________________________________

--- Question grabbed by consultant tjcoppet@PICASSO.MIT.EDU.
    [88/09/28 03:15:03]
.sp .6
--- Connected to consultant tjcoppet@PICASSO.MIT.EDU
    [88/09/28 03:15:04]
.DE
olcr> 
.I 
chtopic xwindowsystem
.R
.DS L
.sp -.4
Topic changed to 'xwindowsystem'
.DE
olcr> 
.I send
.sp -.4
.DS L
Enter your message. End with a ^D or '.' on a line by itself.
.I 
Hi Joe,
.sp .5
To get a clock on your screen type:
               xclock &
 When your cursor changes to an upside down L, click the left mouse button
 where you want the clock to appear.
.sp .5
                                       - Tom
^D
.R
.DE
.sp .1
What now? 
.I send
.DS L
.sp -.4
Message sent.
olcr> 
.B1
.sp .5
Message from OLC daemon...
OLC message sent from user.
.B2
.DE
olcr> 
.I show
.DS L
.sp .1
time: 88/09/28 03:08:46
Thank you.
-Joe
olcr>
.sp .5 
.B1
Message from OLC daemon...
User is done with question.
.B2
.DE
olcr> 
.I done
.sp .1
Enter a title for this conversation: 
.I 
how to get an xclock
.R
.DS L
.sp -.5
Question resolved.
olcr>
.DE
.B 
Figure 5:
.R
Example olcr session
.sp 2
.PP
.bp
.PP
.NH
.pn 0
References
.PP
.IP 1.
E. Balkovich, S.R. Lerman, and R.P. Parmelee, "Computing in Higher
Education: The Athena Experience," 
.I
Communications of the ACM
.B 28
.R
(11), pp 1214-1224, ACM (November 1985).
.IP 2.
G.W. Treese, "Berkeley Unix on 1000 Workstations: Athena Changes to
4.3BSD," pp. 175-182 in
.I
USENIX Conference Proceedings,
.R
Dallas, Texas (February 1988).
.IP 3
R.B. Essick IV and R. Kolstad, "Notesfile Reference Manual,"
.I
UNIX User's Supplementary Documents,
.R
February 1983.
.IP 4.
K. Raeburn, J. Rochlis, W. Sommerfeld, and S. Zanarotti, 
.I "Discuss:
An Electronic Conferencing System for a Distributed Computing Environment,"
.R
in 
.I
USENIX Association Winter Conference 1989 Proceedings,
.R
February 1989.
.IP 5. 
R.W. Scheifler and J. Gettys, "The X Window System,"
.I
ACM Transactions on Graphics
.B
5
.R
(2), pp. 79-109 (April 1987).
.IP 6
M.T. Rose, "Post Office Protocol (revised)," 
University of Delaware, 1985.
.IP 7.
Stephen P. Dyer, "The 
.I Hesiod 
name server," In 
.I
USENIX Association Winter Conference 1988 Proceedings,
.R
pp. 183-190, February 1988.
.IP 8.
J.G. Steiner, B.C. Neuman, and J.I. Schiller, "Kerberos: An Authentication
Service for Open Network Systems," pp. 191-202 in 
.I
USENIX Conference Proceedings
.R
Dallas, Texas (February 1988).
.IP 9.
C. Anthony DellaFera, "The
.I Zephyr
notification service," In 
.I 
USENIX Association Winter Conference 1988 Proceedings,
.R
pp. 213-220, February 1988.
.I
Project Athena Technical Plan: Section E.4.1: Zephyr Notification Service,
.R
M.I.T. Project Athena, Cambridge, Massachusetts (December 21, 1987).
.LP
.PP










