/**********************************************************************
 * Macros to deal with allocation properly
 *
 * $Author: brlewis $
 * $Source: /afs/athena.mit.edu/astaff/project/eosdev/src/include/RCS/memory.h,v $
 * $Header: /afs/athena.mit.edu/astaff/project/eosdev/src/include/RCS/memory.h,v 1.4 91/11/15 14:51:40 brlewis Exp Locker: brlewis $
 *
 * Copyright 1989, 1990 by the Massachusetts Institute of Technology.
 *
 * For copying and distribution information, please see the file
 * <mit-copyright.h>.
 **********************************************************************/

#ifndef lint
static char rcsid_memory_h[] = "$Header: /afs/athena.mit.edu/astaff/project/eosdev/src/include/RCS/memory.h,v 1.4 91/11/15 14:51:40 brlewis Exp Locker: brlewis $";
#endif /* lint */

#ifndef __MEMORY_MACROS__
#define __MEMORY_MACROS__

char *malloc();
char *realloc();

#define New(type) ((type *)malloc((unsigned)sizeof (type)))
#define NewArray(type, n) ((type *)malloc((unsigned)sizeof(type) * (n)))
#define BiggerArray(type,old,n) ((type *)realloc((char *)(old), \
						 (unsigned)(sizeof(type)*(n))))
#define newstring(s) malloc((unsigned)strlen(s)+1)

#endif /* __MEMORY_MACROS__ */


