#ifndef __FTPLIBRARY_H
#define __FTPLIBRARY_H


#ifdef __cplusplus
    extern "C" {
#endif
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/ftp.h>
#include <netinet/in.h>
#include <netdb.h>

#ifdef _AIX
int accept (int, struct sockaddr_in*, int*);
char *bcopy (char*, char*, size_t);
int bind (int, const void*, int);
int connect (int, struct sockaddr_in*, int);
int gethostname (char*, size_t);
int getsockname (int, struct sockaddr_in*, int*);
int getpeername (int, struct sockaddr_in*, int*);
int getsockopt (int, int, int, void*, int*);
int listen(int, int);
int setsockopt (int, int, int, (size_t);
int socket (int, int, int);
void free (void*);
void *malloc (size_t);
#endif
		  

      
#define EXIT(con,e) \
  ( con -> errno = e,  \
    ( (con->func != NULL) && (e < 0) )? \
       (*(con->func))(con,e,FtpMessage(e)) : 0, \
     e\
  )
   
#define MAX_ANSWERS 10 /* Number of known goodest answers for reqest */
#define QUIT 0
#define Ctrl(x) ((x) - '@')
#define FREE(x) memset ( &x , '\0' , sizeof x )
#define CUT(x) ((x)&0xff)

typedef int STATUS;
typedef char String[256];


typedef struct
{
  int sock;
  FILE *data;
  char mode;
  int errno;
  int ch;
  STATUS (*func)();
  STATUS (*debug)();
} FTP;

#define FtpSetErrorHandler(con,f) con->func = f;
#define FtpSetDebugHandler(con,f) con->debug = f; 

#define FtpAccount(ftp,acc)       FtpCommand(ftp,"ACCT %s",acc,230,EOF)
#define FtpUser(ftp,user)         FtpCommand(ftp,"USER %s",user,230,331,332,EOF)
#define FtpPassword(ftp,pas)      FtpCommand(ftp,"PASS %s",pas,230,332,EOF)
#define FtpType(ftp,type)         FtpCommand(ftp,"TYPE %s",type,200,EOF)
#define FtpChdir(ftp,dir)         FtpCommand(ftp,"CWD %s",dir,200,250,EOF)
#define FtpMkdir(ftp,dir)         FtpCommand(ftp,"MKD %s",dir,200,257,EOF)
#define FtpRm(ftp,dir)            FtpCommand(ftp,"DELE %s",dir,200,250,EOF)
#define FtpGetFile(ftp,file)      FtpCommand(ftp,"RETR %s",file,\
				 	   200,125,150,250,EOF)
#define FtpPutFile(ftp,file)      FtpCommand(ftp,"STOR %s",file,\
				 	  200,125,150,250,EOF)
#define FtpAscii(ftp)             FtpType(ftp,"A")
#define FtpBinary(ftp)            FtpType(ftp,"I")
#define FtpOpenRead(ftp,file)     FtpData(ftp,"RETR %s",file,"r")
#define FtpOpenWrite(ftp,file)    FtpData(ftp,"STOR %s",file,"w")
#define FtpOpenAppend(ftp,file)   FtpData(ftp,"APPE %s",file,"r")
#define FtpDirectory(ftp,pat,out) FtpRetr(ftp,"LIST %s",pat,out)
#define FtpDir(ftp,out)           FtpRetr(ftp,"LIST","",out)
#define FtpGet(ftp,in,out)        FtpRetr(ftp,"RETR %s",in,out)


FILE
  * FtpFullOpen(char * file,char * mode );
STATUS
  FtpBye (FTP * con),
  FtpClose ( FTP *),
  FtpConnect ( FTP **con,char *hostname),
  FtpDebugDebug ( FTP *con, int errno, char * Message),
  FtpDebugError ( FTP *con, int errno, char * Message),
  FtpFullClose(FILE *),
  FtpRetr ( FTP *con , char * command , char * inp , char * out),
  FtpGetString ( FTP * con , char * str ),
  FtpInitMessageList(),
  FtpLogin ( FTP **con, char * host , char * user , char * pass , char * acct),
  FtpMove ( FTP *con,char * old,char *new),
  FtpData( FTP * con , char * command , char * param , char * mode ),
  FtpPort ( FTP *con ,int ,int ,int ,int ,int ,int ),
  FtpPut ( FTP * con , char * inp , char * out),
  FtpRead ( FTP * con),
  FtpOpenDir( FTP * con , char * files ),
  FtpSendMessage( FTP * con , char * Message ),
  FtpWrite ( FTP * con , char c),
  FtpGood ( ... ),
  FtpCommand ( ... );


int
  FtpGetMessage( FTP * con , char * Message),
  FtpNumber ( char * Message );

char 
  *FtpPwd(FTP *con),
  *FtpMessage(int Number);

void
    FtpDebug ( FTP * con );


#ifdef __cplusplus
}
#endif
      

#endif /* __FTPLIBRARYH_ */



