#include "FtpLibrary.h"

static FTP *ftp_table[256];
static STATUS syntax();

FILE * FtpFullOpen(char * file , char * mode )
{
  FTP *ftp;
  FILE *tmp;
  String Host,User,Passwd,RemoteFile;
  STATUS i;

  if ( ! syntax (file,Host,User,Passwd,RemoteFile))
    {
      tmp=fopen(file,mode);
      ftp_table[(int)fileno(tmp)] = NULL;
      return tmp;
    }
  if ( (i=FtpLogin(&ftp,Host,User,Passwd,NULL)) < 1 )
    return NULL;

  FtpBinary(ftp);

  switch(mode[0])
    {
    case 'r': 
	if (FtpOpenRead(ftp,RemoteFile)<1) 
	  return NULL;
	ftp_table[(int)fileno(ftp->data)] = ftp;
	return ftp->data;
    case 'w':
	if (FtpOpenWrite(ftp,RemoteFile)<1)
	  return NULL;
	ftp_table[(int)fileno(ftp->data)] = ftp;
	return ftp->data;
    case 'a':
	if (FtpOpenAppend(ftp,RemoteFile)<1)
	  return NULL;
	ftp_table[(int)fileno(ftp->data)] = ftp;
	return ftp->data;
    }
  /* Error Mode */
  return NULL;
}

STATUS   FtpFullClose(FILE *f)
{
  FTP *ftp=ftp_table[(int)fileno(f)];
  if (ftp == NULL)
    return fclose(f);
  FtpClose(ftp);
  return FtpBye(ftp);
}

static STATUS syntax ( String source ,
		       String host ,
		       String user ,
		       String passwd ,
		       String file)

{
  char *in,*out;
  host[0] = user[0] = passwd[0] = file[0] = '\0';
  for ( in = source , out = host;
       *in !='\0' && *in != '/' ;
       *out++ = *in++);
  *out = '\0';
  if ( *in == '\0' ) return 0;
  in++;
  for ( out = user;
       *in !='\0' && *in != '/' ;
       *out++ = *in++);
  *out = '\0';
  if ( *in == '\0' ) return 0;
  in++;
  for ( out = passwd;
       *in !='\0' && *in != ':' ;
       *out++ = *in++);
  *out = '\0';
  if ( *in == '\0' ) return 0;
  in++;
  for ( out = file;
       *in !='\0';
       *out++ = *in++);
  *out = '\0';
  return 1;
}
  
