# --------- genindex configuration (preliminary) ---------

# path (need only standard utilities + compress)
PATH=/bin:/usr/ucb

# root directory of listing (anon ftp disk pathname)
# and ftp's file prefix after chroot (usually "/")
# if not set here, 1st and 2nd arguments to genindex are used
# second argument defaults to "/"
#ROOT="/home/ftp"
#PREFIX="/"

# name of ftpserver (aliasname `ftp', if available)
SERVERNAME="unknown"
SERVERADDR="an-internet-address"
SERVERORG="your organization"

# mail address of ftpadmin
FTPADM="ftpadm@$SERVERNAME"

# other server information (optional)
ACCESS="no restrictions"
LOCATION="town, country, optional coordinates"

# uid of anonymous ftp user -- sorry, there is no portable way
# to grep it from passwd, YP or whatever-you-use
ANONUSER="ftp"

# mail program
MAILPROG="/bin/mail"

# location of file containing pathnames to be ignored
# format: one regex per line; regex compared with full pathname (but
# without prefix). "." does not have special meaning.
# matching directories are pruned (subdirs are ignored)
# example: "./etc" matches directory /etc and all subdirs
#   "*/amiga" matches all files and directories with exact name "amiga"
#   "*/.*" matches files and directories beginning with a dot
IGNORENAME="/home/ftp/.ignore-index"

# tmp directory, ~ 5 MB needed (for 1 GB archive size)
case x"${TMPDIR}" in x) TMPDIR=/tmp ;; esac
export TMPDIR

# location of GNU find
GFIND=/usr/gnu/bin/gfind

# usual or special ls
LS=/bin/ls

# sort options, comment SORTOPTS out if you don't want to sort
# sort is not fully tested --cross 28aug92
bypath="+4"
#bydate="+2.7n +2.3M +2.0n +3n +3.3n"	# POSIX only!
#reverse="-r"
caseinsensitive="-f"
other="-T $TMPDIR"
SORTOPTS="$bypath $reverse $caseinsensitive $other"

# diff args
DIFF=diff
DIFFARGS="-c1"

# server's home timezone (not INDEX listing timezone!)
SERVERZONE="`$GFIND /dev/null -printf '%TZ'`"

# end of configuration
