/************************************************************************
 *									*
 * 	Background File Transfer Program (BFTP)				*
 *									*
 *	Written at USC/Information Sciences Institute			*
 *	September, 1988							*
 *									*
 *	BFTP is Public Domain, and may be used for any purpose as	*
 *	long as this notice is not removed.  USC-ISI does not assume	*
 *	any responsibility for the correctness, performance, or use	*
 *	of this software.						*
 *									*
 ************************************************************************/

/*
*	bftp.h
*/

/* --- Customize these parameters for your site! --- */

#ifdef SUNOS4
#define FXPATH "/nfs/u5/deschon/bftp/sunos4/fts"    /* used in bftp & bftptool */
#define BFTPPATH "/nfs/u5/deschon/bftp/sunos4/bftp" /* used in bftpd */
#else
#ifdef BSD4_3
#define FXPATH "/nfs/u5/deschon/bftp/vax/fts"
#define BFTPPATH "/nfs/u5/deschon/bftp/vax/bftp"
#else
#define FXPATH "/nfs/u5/deschon/bftp/sunos3/fts"    /* used in bftp & bftptool */
/* (was /nfs/u3/pd/bin/fts) */
#define BFTPPATH "/nfs/u5/deschon/bftp/sunos3/bftp" /* used in bftpd */
#endif
#endif

#define MAILPATH "/usr/ucb/mail"	/* used by fts */
#define SITESTR "isi.edu"	    /* default mailbox = login@sitestr */

/* ------------------------------------------------- */

#define REQPREFIX "bftp"
#define SAVEPREFIX "bftp-save"
#define NULLSTR	""

#define DEFAULT_BYTESZ 8
#define DEFAULT_PORT 21

#define boolean int

#ifndef FALSE
#define FALSE		0		/* logical false */
#define TRUE		!FALSE		/* logical true */
#endif

#define COPY 0		/* transfer mode */
#define MOVE 1
#define DFILE 2
#define VERIFY 3
#define VERIFY_SRC 4

#define APPE 0		/* creation mode */
#define STOR 1
#define STOU 2

#define DST 0
#define SRC 1

#define ASCII 0
#define EBCDIC 1
#define IMAGE 2
#define LOCAL 3
#define NOTYPE 4

#define NONPRINT 0
#define TELNET 1
#define CCNTRL 2
#define NOFORM 3

#define STREAM 0
#define BLOCK 1
#define COMP 2
	
#define FIL 0
#define RECORD 1
#define PAGE 2

#define MAXLEN 100	/* standard string length */
#define MAX_SAVES 50	/* max number of save files shown */

struct hostinfo {
	char	host[MAXLEN];	/* Domain name of FTP server host */
	char	user[MAXLEN];	/* User name for login */
	char	passwd[MAXLEN];	/* Password for login */
	char	acct[MAXLEN];	/* Account for login */
	char	dir[MAXLEN];	/* Pathname - directory part */
	char	file[MAXLEN];	/* Pathname - file part */
	short	port;		/* Port number to use */
};

struct fileinfo {
	char 	filetype[10],	/* Ascii plus form, Ebcdic plus form,
				  (form = Non-print, Telnet, 
				  			or Carriage-control)
				  Image, or Local plus Byte-size */
		stru,		/* File, Record, or Page */
		mode;		/* Stream, Block, Compressed */
	int  	reqtype,	/* COPY, MOVE, DFILE, VERIFY, NOMODE */
		creation,	/* STOR, STOU, APPE */
		multflag;	
};

struct reqinfo {
	char 	rpasswd[MAXLEN],
		mailbox[MAXLEN],
		mailfile[MAXLEN],	/* *** MAXPATHLEN ? */
		cmdfile[MAXLEN]; 	/* *** MAXPATHLEN ? */
	int	interval,
		ntries;
};

struct conninfo {
	int   socket ;	/* Socket number */
	FILE *fpin ;         /* File Pointer for input side of Telnet conn*/
	FILE *fpout ;        /* File Pointer for output side */
};
