.\" @(#)mbftptool.1
.TH MBFTPTOOL 1C "2 October 1989"
.nh
.SH NAME
mbftptool \- Multiple-site Background FTP Tool
.SH SYNOPSIS
.B mbftptool
[
.B \-c
] 
.SH DESCRIPTION
.LP
The
.B mbftptool
is a mouse and window oriented user interface to the Background File
Transfer Program (BFTP).
.B mbftptool
may be used to submit a request to have a file transfered to multiple
sites via the standard internet File Transfer Protocol (FTP),
which is described in RFC-959.
.LP
BFTP makes use of third party FTP, so the source and the destination hosts do
not have to be operational at the time the request is submitted.
Transfers are scheduled locally via the system batch processor,
.BR at .
Therefore the exact time of a file transfer will take place depends on how
often jobs are run from the system batch queue.
.LP
For more information on BFTP see 
.BR RFC-1068 .
.SH OPTIONS
.HP
.B \-c
.br
In conference mode, when 
.I filename
is transfered, a file 
.I .filename
is created and transfered.  This "dot-file" is produced using the command

.BI "sum " filename " > " .filename

and is used by the MMConf software to verify that the latest version of
.I filename
is present at all sites participating in a multi-media conference.
.SH COMMANDS
.HP
.B MBFTPTool Initialization
.br
When the MBFTPTool is started, it prompts for the local password, which
will be checked against the password for the current user and used as
the default value when transfers performed.
To enter the password and bring up the tool window, select the
.B Done
command or type a carriage return.
The password may be left blank if no default is desired.
.TP
.B Transfer
.br
Perform the requested transfer(s) now.
.TP
.B ShowParams
.br
Display/undisplay the parameters subwindow.
.HP
.B Submit
.br
Place the request in the batch queue.  The
.BR mbftptool " will create a subwindow, prompting for the"
.BR StartTime ", the " Mailbox ", and the " RequestKeyword .
.TP
.B Quit
.br
Exit the 
.BR mbftptool .
.TP
.B Dist
.br
When a default password has been entered, this field is used to select
a distribution mode.  Otherwise the mode will default to
.BR Src->Dsts .
.TP
.B Reset
.br
Reset any commands that are currently in progress for destinations
marked with a check.
.TP
.B Verbose
.br
Display FTP commands and responses in the destination status subwindow.
.TP
.B RequestStorage
.br
Display/undisplay the request storage window.
.B LoadReq
is used to read in the
.IR request-file " corresponding to the name appearing in the"
.BR RequestName " field."
.BR StoreReq " is used to save the current request in a"
.IR request-file .
.BR PurgeReq " is used to delete the"
.IR request-file .
.SH SPECIAL MOUSE FUNCTIONS
.HP   
.B LEFT Mouse Button
.br
The left mouse button is used to position the cursor in a text field,
and to select a command.
.HP
.B CENTER Mouse Button
.br
The center mouse button is used to display help information in a popup 
window.  To test this feature, position the mouse pointer over a 
command/field label, such as
.BR Transfer , 
and hold down the center mouse button.
.HP
.B RIGHT Mouse Button
.br
The right mouse button is used to display and fill in default values.
To test this feature, position the mouse pointer over the label for a
field, such as a 
.B Host
field.  Depress the right mouse button, highlight
a value on the menu, and release the mouse button.
.SH FILES
.LP
The 
.B mbftptool
reads the default directory from the file
.BR mbftp.confid .
Hosts used to initialize the host meus are read from
.BR mbftp.allhosts .
The default destination hosts are read from
.BR mbftp.confhosts .
These initialization files are all optional.
.LP
The 
.B mbftptool
creates a number of files that are used to keep track of requests that
are in progress:
.in 8
.BI bftp 123456789 .cmd
.br
.BI bftp 123456789 .list
.br
.BI bftp 123456789 .msg
.br
.BI bftp 123456789 .req
.LP
The files that are saved via the 
.B StoreReq
command are as follows:
.in 8
.BI bftp-save. request-name
.LP
The
.B mbftptool
usually stores request files in the home directory of the user who is logged
on.  To have the
.B mbftptool
store these files in another directory, use the system
.B setenv 
command to set
.BR $BFTPDIR , 
for example
.in 8
.BI "setenv BFTPDIR ~" "yourname/.bftp"
.LP
.SH "SEE ALSO"
.BR at (1),
.BR bftp (1C),
.BR bftptool (1C),
.BR cron (8),
.BR crontab (5),
.BR ftp (1C),
.BR ftpd (8C)
.SH AUTHOR
Annette DeSchon, USC Information Sciences Institute
.SH BUGS
Please report bugs to Annette DeSchon <deschon@isi.edu>, 213-822-1511.
