/************************************************************************
 *									*
 * 	Background File Transfer Program (BFTP)				*
 *									*
 *	Written at USC/Information Sciences Institute			*
 *									*
 *      BFTP is Public Domain, and may be used for any purpose as	*
 *      long as this notice is not removed.  USC-ISI does not assume	*
 *	any responsibility for the correctness, performance, or use	*
 *	of this software.						*
 *									*
 ************************************************************************/

/*  mbftp_tool.c
 *
 *  The "mbftptool" SunView user interface, is implemented in this module.
*/

#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <pwd.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <suntool/sunview.h>
    /* includes <sunwindow/window_hs.h>, which includes <sys/time.h> */
#include <sys/resource.h>
#include <suntool/panel.h>
#include <sunwindow/notify.h>
#include <suntool/textsw.h>

/* FTS */

#include <netinet/in.h>	
#include "fts.h"
	/* bftp.h is included in fts.h */
	
extern FILE 	*tracefp,  /* File to save trace of Telnet history */
		*logfp;    /* File to compose message */

extern char
  *crypt(),
   bftp_dir[MAXPATHLEN],
   def_user[L_cuserid],
   def_mailbox[101],
   def_hostname[80],
   def_passwd[80],
   def_dir[100];

extern boolean
  conference,
  parse_date(),
  host_okay(),
  read_req(),
  write_req(),
  empty_str();

extern int 
  init_param_help(),
  init_req_help(),
  init_submit_help(),
  find_errors(),
  type_choice();

extern void 
  copy_fileparams(),
  display_dir_menu(),
  display_login_menu(),
  display_passw_menu(),
  display_sfile_menu(),
  dummy_event_proc(),
  update_params(),
  name_dotfile(),
  hint_event_proc(),
  init_user(),
  init_host_menu(),
  init_src_file_menu(),
  init_passw_menu(),
  init_login_menu(),
  init_dir_menu(),
  init_req(),
  init_attr_lists(),
  no_spaces(),
  destroy_req_frame(),
  init_rs_location(),
  make_sumit_frame(),
  rStorage_proc();
	
extern Menu dir_menu;
extern Window popup_frame;
extern Textsw fts_sw;
extern Attr_avlist 
  app_attr,
  byte_attr,
  form_attr,
  mode_attr,
  mult_attr,
  stou_attr,
  stru_attr,
  type_attr,

  dir_attr,
  file_attr,
  host_attr,
  login_attr,
  pass_attr;

static short icon_image[] = {
#include "bftp.icon"
};
DEFINE_ICON_FROM_IMAGE(bftp_icon, icon_image);

/* Required for tool_lib.c */

Frame tool_frame;

/* *********************** */


static Panel_item 
  pPass_item, 
  pDone_item, 
  pMsg_item;
static Window pFrame, tool_panel;

extern Window popup_frame;

#define MAX_DEST 4	
	/* due SunView limit on fd's */
	/* Don't forget to update the help strings if this changed! */
struct xxx {
	char str[80];
	};
struct xxx hosts[MAX_DEST];

static int 
  max_dest = MAX_DEST,	/* must be cut back to 3 for sunos3 */
  tool_top = 0, 	/* keep track of last window location */
  prev_show_val = 0,	/* keep track of toggle value */
  prev_useHost_val = 0, /* keep track of toggle value */
  dFrame_y[MAX_DEST],	/* calculate position of each dest frame */
  dest_pid[MAX_DEST],
  dest_client[MAX_DEST];
static boolean 
  toolsetup = FALSE,
  erase_dest_files = FALSE,
  user_set_host[MAX_DEST];

static Textsw dStatus_sw[MAX_DEST];
static Window
  dest_frame[MAX_DEST], 
  dest_panel[MAX_DEST];

/* Panel items */
	
extern Panel_item
  /* Popup Window */
	quitSW_item, keyword_item,
	interval_item, tries_item, startTime_item, mailbox_item,
  /* Parameters subwindow */
	type_item, format_item, byteSize_item, stru_item, 
  	mode_item, stou_item, append_item, multiple_item;

Panel_item sFile_item;
static Panel_item 
  /* Commands subwindow */
	quit_item, resetAll_item, 
	submitAll_item, transferAll_item,
	param_item, storage_item,
  /* Parameters */
	verbose_item, dist_item,
  	src_msg, sDir_item,
	sHost_item, sLogin_item, sPass_item, sPassDef_msg,
	conf_msg, cFile_item, cFileDef_msg,
	useDHost_item, dShow_item,
  /* Destination Subwindows */
	dHost_item[MAX_DEST], 
	dLogin_item[MAX_DEST], 
	dLoginDef_msg[MAX_DEST],
	dPass_item[MAX_DEST], 
	dPassDef_msg[MAX_DEST],
	dFile_item[MAX_DEST], 
	dFileDef_msg[MAX_DEST],
	dDir_item[MAX_DEST];


#define SAME_AS_SRC "(same as Src)"
#define SAME_AS_CONF "(same as Conf)"
#define SAME_AS_HERE "(same as Here)"
static char 
  same_as_login[100], same_as_pass[100];

#define text_print(str) (void)textsw_insert(fts_sw, str, strlen(str))
#define print_nofile(i)\
  (void)textsw_insert(dStatus_sw[i], "Error: Source file not found\n", 29)
#define set_status(i,str)\
  panel_set(useDHost_item, PANEL_CHOICE_STRING,	i, str, 0)
#define scroll_to_end(i)\
  textsw_possibly_normalize(dStatus_sw[i],\
			    (int)window_get(dStatus_sw[i],TEXTSW_LENGTH))

/* Table of item, corresponding hint text, and event_proc for optional
   fields for which the default value is displayed as a hint:
*/

struct hint_record {
     Panel_item *field_item, *msg_item;
     void (*event_proc)();
   } hint_list[] = {
	&cFile_item, 	&cFileDef_msg, 	  display_sfile_menu,
	&sPass_item,    &sPassDef_msg,    display_passw_menu,
	&dFile_item[0], &dFileDef_msg[0], display_sfile_menu,
	&dLogin_item[0], &dLoginDef_msg[0],  display_login_menu,
	&dPass_item[0], &dPassDef_msg[0], display_passw_menu,
	&dFile_item[1], &dFileDef_msg[1], display_sfile_menu,
	&dLogin_item[1], &dLoginDef_msg[1],  display_login_menu,
	&dPass_item[1], &dPassDef_msg[1], display_passw_menu,
	&dFile_item[2], &dFileDef_msg[2], display_sfile_menu,
	&dLogin_item[2], &dLoginDef_msg[2],  display_login_menu,
	&dPass_item[2], &dPassDef_msg[2], display_passw_menu,
	&dFile_item[3], &dFileDef_msg[3], display_sfile_menu,
	&dLogin_item[3], &dLoginDef_msg[3],  display_login_menu,
	&dPass_item[3], &dPassDef_msg[3], display_passw_menu,
	NULL, 		NULL, 		  NULL 
	};

#include "help_strings.h"

struct help_record {
   union u_tag {
     Panel_item *ip;
     char	*cp;
     } uval;
   } helplist[1000];

static void
init_help()
{
   int i = 0, j = 0;

#define set_ptr(item) helplist[i++].uval.ip = &item
#define set_str(str) helplist[i++].uval.cp = str
#define last_str() helplist[i++].uval.cp = NULL

   set_ptr(quit_item);
   set_str(quit_help);
   last_str();

   set_ptr(resetAll_item);
   set_str("Reset stops any transfers marked with");
   set_str("  a 'check' that are in progress.");
   last_str();

   set_ptr(param_item);
   set_str("ShowParams is used to display the file transfer parameters.");
   set_str(toggle_help);
   last_str();

   set_ptr(storage_item);
   set_str(reqSW1_help);
   set_str(reqSW2_help);
   set_str(toggle_help);
   last_str();

   i = init_req_help(i);

   for (j=0; j<MAX_DEST; j++) {
      set_ptr(dHost_item[j]);
      set_str(dhost_help);
      last_str();

      set_ptr(dLogin_item[j]);
      set_str(dlogin_help);
      set_str(paren_help);
      last_str();

      set_ptr(dPass_item[j]);
      set_str(dpass_help);
      set_str(paren_help);
      last_str();

      set_ptr(dFile_item[j]);
      set_str(dfile_help);
      set_str(paren_help);
      last_str();

      set_ptr(dDir_item[j]);
      set_str(ddir1_help);
      set_str(ddir2_help);
      set_str(ddir3_help);
      set_str(ddir4_help);
      set_str(ddir5_help);
      last_str();
      }

   /* *** add conf_msg */

   set_ptr(cFile_item);
   set_str("File name that will be used on the conference (destination) hosts.");
   set_str(paren_help);
   last_str();

   i = init_submit_help(i);

   set_ptr(dist_item);
   set_str(
   "The Distribution mode may be:");
   set_str(
   "  Src->Here->Dsts  Two part transfer: source to local host, followed by");
   set_str(
   "                       transfer from local host to checked destinations.");
   set_str(
   "  Here->Dsts       Transfer file from local host to checked destinations.");
   last_str();

   set_ptr(pDone_item);
   set_str("Click on 'Done' or type a carriage-return when the");
   set_str("  local password has been typed.");
   last_str();

   set_ptr(pPass_item);
   set_str("The local password is the password of the user currently logged on.");
   set_str("  It will be used as the default in the event that a password for");
   set_str("  the source host or a destination host is not explicitly entered.");
   set_str("  If no local password is supplied, the distribution mode will be");
   set_str("  limited to 'Src->Dsts'.");
   last_str();

   set_ptr(cFile_item);
   set_str("File name that will be used on the conference (destination) hosts.");
   set_str(paren_help);
   last_str();

   set_ptr(useDHost_item);
   set_str("Click a box to specify that a destination host be used when the");
   set_str("  'Transfer', 'Submit', or 'Reset' command is clicked.  Click the");
   set_str("  host name to display/undisplay the corresponding destination window.");
   last_str();

   set_ptr(dShow_item);
   set_str("Click the name of a host to display/undisplay the corresponding");
   set_str("  destination window.  The status of the last transfer is shown");
   set_str("  to the left of the host name.");
   last_str();

   set_ptr(submitAll_item);
   set_str("Submit is used to queue requests for all");
   set_str("  destination hosts marked with a 'check'.");
   last_str();

   set_ptr(transferAll_item);
   set_str("Transfer causes the BFTP server to connect to the specified");
   set_str("  hosts and perform the file transfer, while you wait, for");
   set_str("  each destination marked with a 'check'.");
   last_str();

   set_ptr(verbose_item);
   set_str("The Verbose flag specifies that a detailed log of the");
   set_str("  FTP commands be displayed in each destination status");
   set_str("  window when the 'Transfer' command is selected.");
   last_str();

   /* *** add src_msg */

   set_ptr(sHost_item);
   set_str(sHost_help);
   last_str();

   set_ptr(sLogin_item);
   set_str(sLogin_help);
   last_str();

   set_ptr(sPass_item);
   set_str(sPass_help);
   last_str();

   set_ptr(sFile_item);
   set_str(sFile1_help);
   set_str(sFile2_help);
   last_str();

   set_ptr(sDir_item);
   set_str(sDir1_help);
   set_str(sDir2_help);
   set_str(sDir3_help);
   set_str(sDir4_help);
   set_str(sDir5_help);
   last_str();

   i = init_param_help(i);

   /* end the list */
   helplist[i++].uval.ip = NULL;
}

static void
show_conf_fields(yes)
   boolean yes;
{
   panel_set(conf_msg, PANEL_SHOW_ITEM, (yes)?TRUE:FALSE, 0);
   panel_set(cFile_item, PANEL_SHOW_ITEM, (yes)?TRUE:FALSE, 0);
   panel_set(cFileDef_msg, PANEL_SHOW_ITEM, 
	     (yes && !(strlen((char *)panel_get(cFile_item, PANEL_VALUE))))?
	   	TRUE:FALSE, 
	     0);
}

void
show_dest_file(yes)
   boolean yes;
{
   int i;

   if (conference &&
       (!yes || !(int)panel_get(dist_item, PANEL_VALUE)))
      show_conf_fields(yes);

   for (i=0;i<max_dest;i++) {
      panel_set(dFile_item[i], PANEL_SHOW_ITEM, (yes)?TRUE:FALSE, 0);
      panel_set(dFileDef_msg[i], PANEL_SHOW_ITEM, 
		(yes && !strlen((char *)panel_get(dFile_item[i], PANEL_VALUE)))?
	     		TRUE:FALSE, 
		0);
      }
}

show_src_fields(yes)
   boolean yes;
{
  panel_set(sHost_item, PANEL_SHOW_ITEM, (yes)?TRUE:FALSE, 0);
  panel_set(sLogin_item, PANEL_SHOW_ITEM, (yes)?TRUE:FALSE, 0);
  panel_set(sPass_item, PANEL_SHOW_ITEM, (yes)?TRUE:FALSE, 0);
  panel_set(sPassDef_msg, PANEL_SHOW_ITEM,
	    (yes && strlen(def_passwd) &&
	     !strlen((char *)panel_get(sPass_item, PANEL_VALUE)))?
		  TRUE:FALSE,
	    0);
}

boolean
host_matches(h1,h2)
   char *h1, *h2;
{
   u_long addr1, addr2;

   return(((!strcmp(h1, h2)) ||
	   (resolve_name(h1, &addr1, 1) && 
	    resolve_name(h2, &addr2, 1) &&
	    addr1 == addr2)
	  )?TRUE:FALSE);
}

static void
src_to_dsts()
{
   int i;
   char *cp, *src;

   src = (char *)panel_get(sHost_item, PANEL_VALUE);
   for (i=0;i<max_dest;i++) {
	   cp = (char *)panel_get(dShow_item, PANEL_CHOICE_STRING, i);
	   panel_set(useDHost_item, 
		     	PANEL_TOGGLE_VALUE, 	i, 
		     ((!empty_str(cp)) && !host_matches(cp, src))?TRUE:FALSE, 
		     	0);
	   }
   if (conference)
      panel_set(conf_msg, PANEL_LABEL_STRING, "Conf --", 0);
   else
      panel_set(storage_item, PANEL_SHOW_ITEM, TRUE, 0);
   panel_set(submitAll_item, PANEL_SHOW_ITEM, TRUE, 0);
   show_src_fields(TRUE);
   if (!strcmp(def_dir,(char *)panel_get(sDir_item, PANEL_VALUE)))
      panel_set(sDir_item, PANEL_VALUE,"",0);
   panel_set(tool_panel, PANEL_CARET_ITEM, sFile_item, 0);

   prev_useHost_val = (int)panel_get(useDHost_item, PANEL_VALUE);
} /* src_to_dsts */

static void
dist_proc(item, value, event)
   Panel_item item;
   unsigned int value;
   Event *event;
{
   int i;
   char *cp, *src;

   switch (value) {
      case 1: /* Here->Dsts */
         panel_set(src_msg, PANEL_LABEL_STRING, "Here --", 0);
	 for (i=0;i<max_dest;i++) {
	    cp = (char *)panel_get(dShow_item, PANEL_CHOICE_STRING, i);
	    panel_set(useDHost_item, 
		      PANEL_TOGGLE_VALUE, 	i, 
		      ((!empty_str(cp)) && !host_matches(cp, def_hostname))
		        ?TRUE:FALSE, 
		      0);
	   }
	 panel_set(submitAll_item, PANEL_SHOW_ITEM, TRUE, 0);
	 show_src_fields(FALSE);
	 if (!strlen((char *)panel_get(sDir_item, PANEL_VALUE)))
	    panel_set(sDir_item, PANEL_VALUE, def_dir, 0);
	 show_conf_fields(FALSE);
	 break;
      case 0: /* Src->Here->Dsts */
         panel_set(src_msg, PANEL_LABEL_STRING, "Src --", 0);
	 src = (char *)panel_get(sHost_item, PANEL_VALUE);
	 for (i=0;i<max_dest;i++) {
	   cp = (char *)panel_get(dShow_item, PANEL_CHOICE_STRING, i);
	   panel_set(useDHost_item, 
		     	PANEL_TOGGLE_VALUE, 	i, 
		     ((!empty_str(cp)) && !host_matches(cp, def_hostname) &&
		      !host_matches(cp, src))
		        ?TRUE:FALSE, 
		     	0);
	   }
	 panel_set(submitAll_item, PANEL_SHOW_ITEM, FALSE, 0);
	 show_src_fields(TRUE);
	 if (!strcmp(def_dir,(char *)panel_get(sDir_item, PANEL_VALUE)))
	    panel_set(sDir_item, PANEL_VALUE,"",0);
	 if ((int)panel_get(append_item, PANEL_VALUE) ||
                 !(int)panel_get(multiple_item, PANEL_VALUE))
	    show_conf_fields(TRUE);
	 break;
       }
   panel_set(tool_panel, PANEL_CARET_ITEM, sFile_item, 0);

   prev_useHost_val = (int)panel_get(useDHost_item, PANEL_VALUE);
} /* dist_proc */

/* Routines used in Notify procs for commands subwindow */

static boolean
new_y_positions()
{
   int i;
   Rect *fRect = (Rect *)window_get(tool_frame, WIN_RECT, 0),
   	*rscreen;                  /* Rect for screen */
   struct screen screen;

   if (tool_top != fRect->r_top) {
      tool_top = fRect->r_top;

      /* get screen dimensions */
      win_screenget((int)window_get(tool_frame, WIN_FD), &screen);
      rscreen = &screen.scr_rect;

      for (i=0;i<max_dest;i++) {
	 dFrame_y[i] = fRect->r_height - 10 + i*65;
         if ((fRect->r_top+dFrame_y[i]+150) > rscreen->r_height)
	    dFrame_y[i] = (i*65) - 30 - fRect->r_height;
         }
      return(TRUE);
      }
   return(FALSE);
} /* new_y_positions */

void
update_screen(src, dst, fil)
   struct hostinfo *src, *dst;
   struct fileinfo *fil;
{
   int i;
   boolean show_file;

   panel_set(sHost_item, PANEL_VALUE, src->host, 0);
   panel_set(sLogin_item, PANEL_VALUE, src->user, 0);
   panel_set(sPass_item, PANEL_VALUE, src->passwd,
   	PANEL_LABEL_BOLD, (strlen(src->passwd))?TRUE:FALSE,
	0);
   panel_set(sDir_item, PANEL_VALUE, src->dir, 0);
   panel_set(sFile_item, PANEL_VALUE, src->file, 0);

   /* copy source stuff into all of the dst structures and screens */

   /* Fill in the first destination host if it is blank */
   if (!strlen((char *)panel_get(dHost_item[0], PANEL_VALUE))) {
      panel_set(dHost_item[0], PANEL_VALUE, dst->host, 0);
      panel_set(dShow_item,
	    	    PANEL_CHOICE_STRING,	0,
						dst->host,
		    0);
      panel_set(useDHost_item,
		    PANEL_TOGGLE_VALUE,		0, 
				!host_matches(dst->host, 
				  (char *)panel_get(sHost_item, PANEL_VALUE))
						?TRUE:FALSE,
   		    0);
      }

   (void)new_y_positions();
   for (i = 0; i<max_dest ; i++) {
      /* Show each current destination */
      if ((int)panel_get(useDHost_item, PANEL_TOGGLE_VALUE, i)) {
	 panel_set(dShow_item, PANEL_TOGGLE_VALUE, i, TRUE, 0);
	 window_set(dest_frame[i], 
	 	WIN_SHOW, 	TRUE, 
   		WIN_X,		0,
		WIN_Y,		dFrame_y[i],
		0);
         }

      /* set all destination parameters that are not the same as the default */
      if (!strcmp(def_user, dst->user))  /* they're equal */
	 dst->user[0] = '\0';
      panel_set(dLogin_item[i], PANEL_VALUE,dst->user, 0);
      if (!strcmp(def_passwd, dst->passwd))  /* they're equal */
	 dst->passwd[0] = '\0';
      panel_set(dPass_item[i], 
		PANEL_VALUE, 		dst->passwd,
	  	PANEL_LABEL_BOLD, 	(strlen(dst->passwd))?TRUE:FALSE,
		0);
      panel_set(dDir_item[i], PANEL_VALUE, dst->dir, 0);
      if (!strcmp(src->file, dst->file)) /* they're equal */
	 dst->file[0] = '\0';
      show_file = ((!fil->multflag) ||(fil->creation==APPE))?TRUE:FALSE;
      panel_set(dFile_item[i], 
		PANEL_VALUE, 		dst->file, 
	  	PANEL_SHOW_ITEM, 	show_file,
		0);
      if (!strlen(dst->file))
	 panel_set(dFileDef_msg[i],
		   PANEL_SHOW_ITEM,        show_file,
		   0);
      }

   update_params(fil);

   prev_show_val = (int)panel_get(dShow_item, PANEL_VALUE);
   prev_useHost_val = (int)panel_get(useDHost_item, PANEL_VALUE);
} /* update_screen */

#define SUBMIT_OK 20
#define SUBMIT_BAD 21
#define TRANSFER_OK 22
#define TRANSFER_BAD 23

static Notify_value
my_wait3_handler(me, pid, status, rusage)
   int *me;
   int pid;
   union wait *status;
   struct rusage *rusage;
{
   int i;
	
   if (WIFEXITED(*status)) {
      for (i=0;i<max_dest;i++) if (&dest_client[i] == me) break;
      if (i < max_dest) {
         panel_set(useDHost_item,
	    	PANEL_CHOICE_STRING,	i,
			(status->w_retcode == TRANSFER_OK)?"Completed":
			(status->w_retcode == SUBMIT_OK)?"Submitted":
			"Failed",
   		0);
	 if (status->w_retcode == TRANSFER_OK ||
	     status->w_retcode == SUBMIT_OK)
	    erase_dest_files = TRUE;
         }
      return(NOTIFY_DONE);
      }
   return(NOTIFY_IGNORED);
}

/* *** debugging stuff ***
print_fds(str)
   char *str;
{
   int nfds, fd;
   
   printf("%s:\n",str);
   nfds = getdtablesize();
   for (fd = 0; fd < nfds; fd++)
	printf("%2d:%2d ", fd, fcntl(fd, F_GETFL,0));
   printf("\n\n");
}
*/

static void
copy_src(src)
   struct hostinfo *src;
{
   strcpy(src->host, 
	  ((int)panel_get(sHost_item, PANEL_SHOW_ITEM))?
	   (char *)panel_get(sHost_item, PANEL_VALUE):
	   def_hostname);
   strcpy(src->user, 
	  ((int)panel_get(sLogin_item, PANEL_SHOW_ITEM))?
	   (char *)panel_get(sLogin_item, PANEL_VALUE):
	   def_user);
   strcpy(src->passwd, 
	  ((int)panel_get(sPass_item, PANEL_SHOW_ITEM))?
	   (char *)panel_get(sPass_item, PANEL_VALUE):
	   def_passwd);
   if (!strlen(src->passwd))
      strcpy(src->passwd, def_passwd);
   strcpy(src->dir, (char *)panel_get(sDir_item, PANEL_VALUE));
   strcpy(src->file, (char *)panel_get(sFile_item, PANEL_VALUE));
   src->port = DEFAULT_PORT;
   src->acct[0] = '\0';
} /* copy_src */

static void
copy_dst(src, dst, index)
   struct hostinfo *src, *dst;
   int index;
{
   strcpy(dst->host, (char *)panel_get(dHost_item[index], PANEL_VALUE));
   strcpy(dst->user, (char *)panel_get(dLogin_item[index], PANEL_VALUE));
   if (!strlen(dst->user))
         strcpy(dst->user, def_user);
   strcpy(dst->passwd, (char *)panel_get(dPass_item[index], PANEL_VALUE));
   if (!strlen(dst->passwd))
         strcpy(dst->passwd, (strlen(def_passwd))?def_passwd:src->passwd);
   strcpy(dst->dir, (char *)panel_get(dDir_item[index], PANEL_VALUE));
   dst->port = DEFAULT_PORT;
   dst->acct[0] = '\0';

   /* if visable, copy it, otherwise make it empty */
   if ((int)panel_get(dFile_item[index], PANEL_SHOW_ITEM)) {
         strcpy(dst->file, (char *)panel_get(dFile_item[index], PANEL_VALUE));
	 if (!strlen(dst->file)) {
	    if (conference)
	       strcpy(dst->file, (char *)panel_get(cFile_item, PANEL_VALUE));
	    if (!strlen(dst->file))
	       strcpy(dst->file, src->file);
	    }
	 }
   else
         dst->file[0] = '\0';
} /* copy_dst */

/* Used in tool_lib.c */
void
copy_screen(src, dst, fil)
   struct hostinfo *src, *dst;
   struct fileinfo *fil;
{
   copy_src(src);
   copy_dst(src, dst, 0);	/* copy the first destination frame */
   copy_fileparams(&fil);
}

static boolean
write_dotfile(filename)
   char *filename;
{
   FILE *xxx, *stream;
   char temp[60], dotfile[100];

   /* check that file exists */
   if (xxx = fopen(filename,"r")) {
      fclose(xxx);
   
      sprintf(temp, "sum %s", filename); 
      if (stream = popen(temp,"r")) {
	 fgets(temp,sizeof(temp),stream);
	 pclose(stream);
	 name_dotfile(filename, dotfile);
	 if (xxx = fdopen(open(dotfile, (O_WRONLY|O_CREAT), 0600), "w")) {
	    fputs(temp, xxx);
	    fclose(xxx);
	    return(TRUE);
	    }
         }
      }
   return(FALSE);
}

static boolean
make_dotfiles(src, multflag)
   struct hostinfo *src;
   boolean multflag;
{
   int i;
   FILE *xxx, *stream;
   char temp[100], filespec[100], filename[100];

   if (!strlen(src->dir) || src->dir[0] != '/') {
      strcpy(filespec, getenv("HOME"));
      if ((i = strlen(filespec)) && filespec[i-1] != '/')
	 strcat(filespec, "/");
      }
   else
      filespec[0] = '\0';
   strcat(filespec, src->dir);
   if ((i = strlen(filespec)) && filespec[i-1] != '/')
      strcat(filespec, "/");
   strcat(filespec, src->file);

   if (!multflag)
      return(write_dotfile(filespec));
   else {
      sprintf(temp, "ls -1 %s", filespec); 
      if (stream = popen(temp,"r")) {
	 fgets(temp,sizeof(temp),stream);
	 while (i = strlen(temp)) {
	   /* for each file that matches */
	   temp[i-1] = '\0'; /* get rid of LF */
	   strcpy(filename, temp);
	   temp[0] = '\0';
	   if (!write_dotfile(filename)) {
	      pclose(stream);
	      return(FALSE);
	      }
	   fgets(temp,sizeof(temp),stream);
           }
	 pclose(stream);
         }
      }
   return(TRUE);
} /* make_dotfiles */

Notify_value
my_pipe_reader(me, fd)
   int *me, fd;
{
   int i, n;
   char c[2];

   for (i=0;i<max_dest;i++) if (&dest_client[i] == me) break;
   if (i < max_dest)
      while (fd_select(fd))
         if (n = read(fd, c, 1)) {
	    c[1] = '\0';
	    (void)textsw_insert(dStatus_sw[i], c, n);
	    if (c[0] == '\n')
	       break;
	    }
	 else {
	    if (close(fd) == -1)
	       perror("close0");
	    dest_pid[i] = 0;
	    (void) notify_set_input_func(&dest_client[i],
                                      NOTIFY_FUNC_NULL, fd);
	    break;
	    }
   return(NOTIFY_DONE);
} /* my_pipe_reader */

static void
transfer_going(i)
   int i;
{
   (void)textsw_insert(dStatus_sw[i], "Transfer already in progress!\n", 30);
   set_status(i, "Running");
}

static Notify_value
part1_wait_handler(me, p_id, status, rusage)
   int *me;
   int p_id;
   union wait *status;
   struct rusage *rusage;
{
   struct server_struct ssh, dsh;
   struct fileinfo fil;
   char temp[100], path[100];
   boolean verbose,
         no_dotfile = TRUE;
   int fd, nfds, retcode, pid, fildes[2];
   int i, index;
	
   if (WIFEXITED(*status)) {
      for (index=0;index<max_dest;index++) 
	 if (&dest_client[index] == me) 
	    break;
      if (index < max_dest) {
	 dest_pid[index] = 0;
	 if (status->w_retcode != TRANSFER_OK)
	    set_status(index, "Failed");
	 else { /* TRANSFER_OK */
	    verbose = (int)panel_get(verbose_item, PANEL_VALUE);
	    copy_fileparams(&fil);
	    strcpy(ssh.h.host, def_hostname);
	    strcpy(ssh.h.dir, def_dir);
	    strcpy(ssh.h.user, def_user);
	    strcpy(ssh.h.passwd, def_passwd);
	    if ((int)panel_get(cFile_item, PANEL_SHOW_ITEM))
	       strcpy(ssh.h.file, (char *)panel_get(cFile_item, PANEL_VALUE));
	    if (!strlen(ssh.h.file))
	       strcpy(ssh.h.file, (char *)panel_get(sFile_item, PANEL_VALUE));
	    ssh.h.port = DEFAULT_PORT;
	    ssh.h.acct[0] = '\0';
	    if (make_dotfiles(&ssh.h, fil.multflag))
	       no_dotfile = FALSE;

	    for (i = index;i<max_dest;i++) 
	       if ((int)panel_get(useDHost_item, PANEL_TOGGLE_VALUE, i)) {
		  scroll_to_end(i);
		  if (dest_pid[i]) 
		     transfer_going(i);
		  else {
		    copy_dst(&ssh.h, &dsh.h, i);
		    if (find_errors(dStatus_sw[i], &ssh.h, &dsh.h, &fil))
		       set_status(i, "Failed");
		    else {
		       if (pipe(fildes) == -1) {
			  sprintf(temp,"pipe %d",i);
			  perror(temp);
			  exit(1);
			  }
		       (void) notify_set_input_func(&dest_client[i], 
						    my_pipe_reader, fildes[0]);
		       if (pid = fork()) {
			  (void)close(fildes[1]);
			  if (pid == -1) {
			     perror("fork");
			     (void)close(fildes[0]);
			     (void) notify_set_input_func(&dest_client[i],
	 				NOTIFY_FUNC_NULL, fildes[0]);
			     }
			  else {
			     dest_pid[i] = pid;
			     (void)notify_set_wait3_func(&dest_client[i],
	 				my_wait3_handler, pid);
			     set_status(index, "Part2...");
			     }
		         }
		       else { /* this is the child process */
			 if (dup2(fildes[1], 1) == -1) {
			    perror("dup2");
			    (void)close(fildes[1]);
			    exit(1);
			    }

			 nfds = getdtablesize(); /* Get max number of fd's */
			 (void)close(0);	/* Close all fd's except fd 1 */
			 for (fd = 2; fd < nfds; fd++)
			    (void)close(fd);

			 if (conference)
			    if (no_dotfile ||
				(strlen(dsh.h.file) && 
				 strcmp(dsh.h.file, ssh.h.file)))
			       /* they are not the same */
			       conference = FALSE; 
			                 /* just in the child process */

			 tracefp = (verbose)?stdout:NULL;
			 logfp = stdout;

			 format_time(0, temp);
			 fprintf(logfp,"\n  %s: starting...\n\n", temp);
	
			 sprintf(path,"%s%d",REQPREFIX, time(NULL)+i);
			 sprintf(temp, "%s.req", path);
		    
			 retcode = xfer(&ssh, &dsh, &fil, temp, NULL);
	 
			 sprintf(temp,"rm %s.list 1> /dev/null 2>&1\n", path);
			 system(temp);

			 format_time(0, temp);
			 fprintf(logfp,"\n  %s: completed %ssuccessfully.\n\n", 
				 temp, (retcode == OK)?"":"un");
			 fflush(logfp);
			 exit((retcode == OK)?TRANSFER_OK:TRANSFER_BAD);
		         }
		       }
		    }
		}
	    }
         }
      return(NOTIFY_DONE);
      }
   return(NOTIFY_IGNORED);
} /* part1_wait_handler */

static void
part1_fork(index)
   int index;
{
   struct server_struct ssh, dsh;
   struct fileinfo fil;
   char temp[100], path[100];
   int fd, nfds, retcode, pid, fildes[2];
   boolean verbose;

   scroll_to_end(index);
   if (dest_pid[index])
      transfer_going(index);

   verbose = (int)panel_get(verbose_item, PANEL_VALUE);

   copy_fileparams(&fil);
   copy_src(&ssh.h);

   strcpy(dsh.h.host, def_hostname);
   strcpy(dsh.h.dir, def_dir);
   strcpy(dsh.h.user, def_user);
   strcpy(dsh.h.passwd, def_passwd);
   dsh.h.port = DEFAULT_PORT;
   dsh.h.acct[0] = '\0';

   /* if visable, copy it, otherwise make it empty */
   if ((int)panel_get(cFile_item, PANEL_SHOW_ITEM)) {
      strcpy(dsh.h.file, (char *)panel_get(cFile_item, PANEL_VALUE));
      if (!strlen(dsh.h.file)) {
	 if ((int)panel_get(dFile_item[index], PANEL_SHOW_ITEM))
	    strcpy(dsh.h.file, 
		   (char *)panel_get(dFile_item[index], PANEL_VALUE));
	 if (!strlen(dsh.h.file))
	    strcpy(dsh.h.file, ssh.h.file);
         }
      }
   else
      dsh.h.file[0] = '\0';

   if (find_errors(dStatus_sw[index], &ssh.h, &dsh.h, &fil)) {
      set_status(index, "Failed");
      return;
      }

   if (pipe(fildes) == -1) {
         sprintf(temp,"pipe %d",index);
         perror(temp);
	 exit(1);
         }
   (void) notify_set_input_func(&dest_client[index], 
   				my_pipe_reader, fildes[0]);
   if (pid = fork()) {
         (void)close(fildes[1]);
         if (pid == -1) {
            perror("fork");
	    (void)close(fildes[0]);
	    (void) notify_set_input_func(&dest_client[index],
	 				NOTIFY_FUNC_NULL, fildes[0]);
	    return;
	    }
	 dest_pid[index] = pid;
	 (void)notify_set_wait3_func(&dest_client[index],
	 				part1_wait_handler, pid);
	 set_status(index, "Part1...");
         }
   else { /* this is the child process */
         if (dup2(fildes[1], 1) == -1) {
	    perror("dup2");
	    (void)close(fildes[1]);
	    exit(1);
	    }

	 nfds = getdtablesize();        /* Get max number of fd's */
	 (void)close(0);		/* Close all fd's except fd 1 */
	 for (fd = 2; fd < nfds; fd++)
	    (void)close(fd);

	 conference = FALSE;
	    /* don't need dot-file on src->here transfer */

	 tracefp = (verbose)?stdout:NULL;
	 logfp = stdout;

	 format_time(0, temp);
	 fprintf(logfp,"\n  %s: starting...\n\n", temp);
	
	 sprintf(path,"%s%d",REQPREFIX, time(NULL));
	 sprintf(temp, "%s.req", path);
	 
	 retcode = xfer(&ssh, &dsh, &fil, temp, NULL);
	 
	 sprintf(temp,"rm %s.list 1> /dev/null 2>&1\n", path);
	 system(temp);

	 format_time(0, temp);
	 fprintf(logfp,"\n  %s: completed %ssuccessfully.\n\n", temp, 
			(retcode == OK)?"":"un");
	 fflush(logfp);
	 exit((retcode == OK)?TRANSFER_OK:TRANSFER_BAD);
         }
} /* part1_fork */

static void
close_dframe(i)
   int i;
{
   boolean blank = FALSE, set, bad = FALSE;
   char *cp;
	
   /* If the frame is open, copy the host name and close it */
   if ((int)window_get(dest_frame[i], WIN_SHOW)) {
      cp = (char *)panel_get(dHost_item[i], PANEL_VALUE);
      set = (int)panel_get(useDHost_item, PANEL_TOGGLE_VALUE, i);
      if (!strlen(cp)) {
	 blank = TRUE;
	 user_set_host[i] = FALSE;
         }
      else
	 if (strcmp(cp, (char *)panel_get(dShow_item, PANEL_CHOICE_STRING,i)))
	    /* they don't match */
	    if (!host_okay(cp))
	       bad = TRUE;
	    else
	       user_set_host[i] = TRUE;
      panel_set(useDHost_item,
      		/* Decide whether to mark the dest host "inuse" */
		PANEL_TOGGLE_VALUE,	i, 
					((!set) || blank || bad)? FALSE:TRUE,
		/* Clear the status */
	    	PANEL_CHOICE_STRING,	i,
					(set && bad)?"Bad Host":" ",
		0);
      /* Make the dest window disappear */
      window_set(dest_frame[i], WIN_SHOW, FALSE, 0);
      panel_set(dShow_item,
	    	PANEL_CHOICE_STRING,	i,
					(blank || bad)?" ":cp,
      		PANEL_TOGGLE_VALUE,     i,
					FALSE,
   		0);
      }
} /* close_dframe */

/* Notify Procs for the Commands Subwindow */

static Notify_value
clear_dest(frame, status)
   Frame frame;
   Destroy_status status;
{
   int i;
   
   for (i=0;i<max_dest;i++) 
   	if (dest_frame[i] == frame) {
	   close_dframe(i);
	   break;
	   }
   prev_useHost_val = (int)panel_get(useDHost_item, PANEL_VALUE);
   prev_show_val = (int)panel_get(dShow_item, PANEL_VALUE);
}

static void
reset_all(item, event)
   Panel_item item;
   Event *event;
{
   int i;

   for (i=0;i<max_dest;i++) {
      if ((int)panel_get(useDHost_item, PANEL_TOGGLE_VALUE, i))
         if (dest_pid[i]) {
	    kill(dest_pid[i], SIGKILL);
	    dest_pid[i] = 0;
	    set_status(i, "Reset");
	    }
      }
}

static void
set_buttons(status)
   boolean status;
{
   /* these items use the popup_frame and must be cleared */
   panel_set(transferAll_item, PANEL_SHOW_ITEM, status, 0);
   panel_set(submitAll_item, PANEL_SHOW_ITEM, status, 0);
/* ***   panel_set(explain_item, PANEL_SHOW_ITEM, status, 0); */

   if (!conference) {
      panel_set(storage_item, PANEL_SHOW_ITEM, status, 0);
      if (!status)
	 destroy_req_frame();
      }
}

void
quit_popup(item, event)
   Panel_item item;
   Event *event;
{
   reset_all(0,0);
   window_destroy(popup_frame);
   set_buttons(TRUE);
}

static struct reqinfo req;

void
do_submit(item, event)
   Panel_item item;
   Event *event;
{
   FILE *xxx;
   struct server_struct ssh, dsh;
   struct fileinfo fil;
   char temp[100], path[100], timestr[100];
   boolean verbose;
   int i, fd, nfds, retcode, pid, fildes[2];
   u_long now, start;

   now = time(NULL);

   /* parse the start time */
   strcpy(timestr, (char *)panel_get(startTime_item, PANEL_VALUE));
   if (empty_str(timestr))
      start = now;
   else if (!parse_date(timestr, &start)) {
      sprintf(temp," Date '%s' not parsed.\n",timestr);
      text_print(temp);
      panel_set(startTime_item, PANEL_VALUE, "now", 0);
      return;
      }

   /* copy request parameters from screen */
   init_req(&req);
   strcpy(req.rpasswd, (char *)panel_get(keyword_item, PANEL_VALUE));
   if (empty_str(req.rpasswd)) req.rpasswd[0] = '\0';
   strcpy(req.mailbox, (char *)panel_get(mailbox_item, PANEL_VALUE));
   if (!mailbox_ok(req.mailbox, temp)) {
      text_print(" Invalid mailbox.\n");
      panel_set(mailbox_item, PANEL_VALUE, def_mailbox, 0);
      return;
      }
   req.interval = atoi((char *)panel_get(interval_item, PANEL_VALUE));
   req.ntries = atoi((char *)panel_get(tries_item, PANEL_VALUE));

   verbose = (int)panel_get(verbose_item, PANEL_VALUE);
   copy_fileparams(&fil);
   copy_src(&ssh.h);

   for (i=0;i<max_dest;i++) {
      close_dframe(i);
      if ((int)panel_get(useDHost_item, PANEL_TOGGLE_VALUE, i)) {
	 scroll_to_end(i);
	 if (dest_pid[i])
	    transfer_going(i);
	 else {
	    copy_dst(&ssh.h, &dsh.h, i);
	    if (find_errors(dStatus_sw[i], &ssh.h, &dsh.h, &fil)) {
	       set_status(i, "Failed");
	       }
	    else {
	       if (pipe(fildes) == -1) {
		  sprintf(temp,"pipe %d",i);
		  perror(temp);
		  exit(1);
		  }
	       (void) notify_set_input_func(&dest_client[i], 
   				my_pipe_reader, fildes[0]);
	       if (pid = fork()) {
		  (void)close(fildes[1]);
		  if (pid == -1) {
		        perror("fork");
			(void)close(fildes[0]);
			(void)notify_set_input_func(&dest_client[i],
	 				NOTIFY_FUNC_NULL, fildes[0]);
		        }
		  else {
		        dest_pid[i] = pid;
			(void)notify_set_wait3_func(&dest_client[i],
	 				my_wait3_handler, pid);
			set_status(i, "Running");
		        }
		  }
	       else { /* this is the child process */
		  if (dup2(fildes[1], 1) == -1) {
		        perror("dup2");
			(void)close(fildes[1]);
			exit(1);
		        }

		  nfds = getdtablesize(); 	/* Get max number of fd's */
		  (void)close(0);		/* Close all fd's except fd 1 */
		  for (fd = 2; fd < nfds; fd++)
		    (void)close(fd);

		  if (conference)
		       if (strlen(dsh.h.file) && strcmp(dsh.h.file, ssh.h.file))
				       /* they are not the same */
			 conference = FALSE; /* just in the child process */

		  sprintf(path, "%s%d", REQPREFIX, start+i);

		  sprintf(temp, "%s.req", path);
		  sprintf(req.mailfile, "%s.msg", path);
		  sprintf(req.cmdfile, "%s.cmd", path);
		  write_req(temp, &req, &ssh.h, &dsh.h, &fil, NULL);

		  sprintf(temp, "%s.cmd", path);
		  xxx = fdopen(open(temp, (O_WRONLY|O_CREAT), 0600), "w");
		  fprintf(xxx,  "%s -v %s %s.req\n", 
			     FXPATH, (conference)?"-c":"", path);
		  fclose(xxx);

		  sprintf(temp, "%s.msg", path);
		  xxx = fdopen(open(temp, (O_WRONLY|O_CREAT), 0600), "w");
		  queue_req(&req, (now > start) ? now : start, temp);
		  print_req(xxx, &req, &ssh.h, &dsh.h, &fil, FALSE);
		  fprintf(xxx, "\n%s\n", temp);
		  fclose(xxx);
		  strcat(temp, "\n\n");
		  printf(temp);
		  exit(SUBMIT_OK);
		  }
	       }
	    }
	 }
      }

   window_destroy(popup_frame);
   set_buttons(TRUE);
   prev_useHost_val = (int)panel_get(useDHost_item, PANEL_VALUE);
   prev_show_val = (int)panel_get(dShow_item, PANEL_VALUE);
} /* do_submit */

static void
transfer_all(item, event)
   Panel_item item;
   Event *event;
{
   struct server_struct ssh, dsh;
   struct fileinfo fil;
   char temp[100], path[100];
   int i, fd, nfds, retcode, pid, fildes[2];
   boolean verbose,
      no_dotfile = TRUE,
      two_step = (conference && strlen(def_passwd) &&
		  (!(int)panel_get(dist_item, PANEL_VALUE)))?TRUE:FALSE;
   u_long now;

   destroy_req_frame();
   if (two_step) {
      for (i=0;i<max_dest;i++) {
	 if ((int)panel_get(useDHost_item, PANEL_TOGGLE_VALUE, i))
	    set_status(i, " ");
	 close_dframe(i);
         }
      for (i=0;i<max_dest;i++) 
	  if ((int)panel_get(useDHost_item, PANEL_TOGGLE_VALUE, i)) {
	     part1_fork(i);
      	     break;
	     }
      }
   else {
      now = time(NULL);
      verbose = (int)panel_get(verbose_item, PANEL_VALUE);
      copy_src(&ssh.h);
      copy_fileparams(&fil);
      if (conference && 
	  (strlen(def_passwd) ||
	   (!strcmp(ssh.h.user, def_user) &&
	    host_matches(ssh.h.host, def_hostname)
	  )))
	 if (make_dotfiles(&ssh.h, fil.multflag))
	    no_dotfile = FALSE;
      for (i=0;i<max_dest;i++) {
         close_dframe(i);
	 if ((int)panel_get(useDHost_item, PANEL_TOGGLE_VALUE, i)) {
	    scroll_to_end(i);
	    if (dest_pid[i])
	       transfer_going(i);
	    else {
	       copy_dst(&ssh.h, &dsh.h, i);
	       if (find_errors(dStatus_sw[i], &ssh.h, &dsh.h, &fil))
		  set_status(i, "Failed");
	       else {
		  if (pipe(fildes) == -1) {
		     sprintf(temp,"pipe %d",i);
		     perror(temp);
		     exit(1);
		     }
		  (void) notify_set_input_func(&dest_client[i], 
   				my_pipe_reader, fildes[0]);
		  if (pid = fork()) {
		     (void)close(fildes[1]);
		     if (pid == -1) {
		        perror("fork");
			(void)close(fildes[0]);
			(void)notify_set_input_func(&dest_client[i],
	 				NOTIFY_FUNC_NULL, fildes[0]);
		        }
		     else {
		        dest_pid[i] = pid;
			(void)notify_set_wait3_func(&dest_client[i],
	 				my_wait3_handler, pid);
			set_status(i, "Running");
		        }
		     }
		  else { /* this is the child process */
		     if (dup2(fildes[1], 1) == -1) {
		        perror("dup2");
			(void)close(fildes[1]);
			exit(1);
		        }

		     nfds = getdtablesize(); 	/* Get max number of fd's */
		     (void)close(0);		/* Close all fd's except fd 1 */
		     for (fd = 2; fd < nfds; fd++)
		        (void)close(fd);

		     if (conference)
		        if (no_dotfile || 
			    ((strlen(dsh.h.file) &&
			      strcmp(dsh.h.file, ssh.h.file))))
			       /* they are not the same */
			   conference = FALSE; /* just in the child process */

		     tracefp = (verbose)?stdout:NULL;
		     logfp = stdout;

		     format_time(0, temp);
		     fprintf(logfp,"\n  %s: starting...\n\n", temp);
	
		     sprintf(path,"%s%d",REQPREFIX, now+i);
		     sprintf(temp, "%s.req", path);
	 
		     retcode = xfer(&ssh, &dsh, &fil, temp, NULL);
	 
		     sprintf(temp,"rm %s.list 1> /dev/null 2>&1\n", path);
		     system(temp);

		     format_time(0, temp);
		     fprintf(logfp,
			     "\n  %s: completed %ssuccessfully.\n\n", temp, 
			     (retcode == OK)?"":"un");
		     fflush(logfp);
		     exit((retcode == OK)?TRANSFER_OK:TRANSFER_BAD);
		     }
		  }
	       }
	    }
         }
      }
   prev_useHost_val = (int)panel_get(useDHost_item, PANEL_VALUE);
   prev_show_val = (int)panel_get(dShow_item, PANEL_VALUE);
} /* transfer_all */

static void
sFile_event_proc(item, event)
     Panel_item item;
     Event *event;
{
   int i;

   if (erase_dest_files && event_is_ascii(event)) {
      erase_dest_files = FALSE;
      /* delete all of the dest files */
      for (i=0;i<max_dest;i++) {
	 panel_set(dFile_item[i], PANEL_VALUE, "", 0);
	 panel_set(dFileDef_msg[i], PANEL_SHOW_ITEM, TRUE, 0);
         }
      if (conference) {
	 panel_set(cFile_item, PANEL_VALUE, "", 0);
	 if ((int)panel_get(cFile_item, PANEL_SHOW_ITEM))
	    panel_set(cFileDef_msg, PANEL_SHOW_ITEM, TRUE, 0);
         }
      }
   no_spaces(item, event);
} /* sFile_event_proc */

make_dest_frames()
{
   int i, row;

   (void)new_y_positions();
   for (i=0;i<max_dest;i++) {
      row = 0;
      user_set_host[i] = FALSE;

      dest_frame[i] = window_create(tool_frame, FRAME,
   		WIN_X,	0,
		WIN_Y,	dFrame_y[i],
		FRAME_NO_CONFIRM, 	TRUE,
		FRAME_DONE_PROC,  	clear_dest,
		0);
	
      dest_panel[i] = window_create(dest_frame[i], PANEL,
   		0);
      dHost_item[i] = panel_create_item(dest_panel[i], PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(2),
		PANEL_LABEL_Y,		ATTR_ROW(row),
		ATTR_LIST, 		host_attr,
		0);
      dDir_item[i] = panel_create_item(dest_panel[i], PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(2),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		PANEL_VALUE,	(char *)panel_get(sDir_item, PANEL_VALUE),
		ATTR_LIST,		dir_attr,
		0);
      if (strlen(def_dir))
	panel_set(dDir_item[i], PANEL_EVENT_PROC, display_dir_menu, 0);
		
      dLogin_item[i] = panel_create_item(dest_panel[i], PANEL_TEXT,
		ATTR_LIST,		login_attr,
		PANEL_EVENT_PROC,       hint_event_proc,
		0);
      dLoginDef_msg[i] = panel_create_item(dest_panel[i], PANEL_MESSAGE,
   		PANEL_LABEL_X,	     (int)panel_get(dLogin_item[i],
						    PANEL_VALUE_X),
		PANEL_LABEL_Y,	     (int)panel_get(dLogin_item[i],
						    PANEL_VALUE_Y),
	        PANEL_LABEL_STRING,  same_as_login,
		0);

      dFile_item[i] = panel_create_item(dest_panel[i], PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(2),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		ATTR_LIST,		file_attr,
		PANEL_EVENT_PROC,	hint_event_proc,
		0);
      dFileDef_msg[i] = panel_create_item(dest_panel[i], PANEL_MESSAGE,
   		PANEL_LABEL_X,	     (int)panel_get(dFile_item[i],
						    PANEL_VALUE_X),
		PANEL_LABEL_Y,	     (int)panel_get(dFile_item[i],
						    PANEL_VALUE_Y),
	        PANEL_LABEL_STRING,  (!conference)?SAME_AS_SRC:
				     (strlen(def_passwd))?SAME_AS_HERE:
				     SAME_AS_CONF,
		0);

      dPass_item[i] = panel_create_item(dest_panel[i], PANEL_TEXT,
		ATTR_LIST,		pass_attr,
		PANEL_EVENT_PROC,       hint_event_proc,
		0);
      dPassDef_msg[i] = panel_create_item(dest_panel[i], PANEL_MESSAGE,
   		PANEL_LABEL_X,	     (int)panel_get(dPass_item[i],
						    PANEL_VALUE_X),
		PANEL_LABEL_Y,	     (int)panel_get(dPass_item[i],
						    PANEL_VALUE_Y),
	        PANEL_LABEL_STRING,  (strlen(def_passwd))?same_as_pass:
				     SAME_AS_SRC,
		0);
      window_fit(dest_panel[i]);
      window_fit_width(dest_frame[i]);

      dStatus_sw[i] = window_create(dest_frame[i], TEXTSW,
 		WIN_HEIGHT,		ATTR_ROW(8),
		TEXTSW_IGNORE_LIMIT,    TEXTSW_INFINITY,
   		TEXTSW_READ_ONLY, 	TRUE,
		0);
	
      window_fit(dStatus_sw[i]);
      window_fit(dest_frame[i]);
    }
} /* make_dest_frames */

static void
addDest_proc(item, value, event) 
   Panel_item item;
   unsigned int value;
   Event *event; 
{
   int i;
   boolean change;

   change = new_y_positions();
   for (i=0;i<max_dest;i++) 
      if ((1<<i & value) ||
	  (empty_str((char *)panel_get(dShow_item, 
				       PANEL_CHOICE_STRING, i)) &&
	   (int)window_get(dest_frame[i],WIN_SHOW))) {
	 if (change || (prev_show_val < value))
	    window_set(dest_frame[i], 
		       WIN_SHOW, 	TRUE, 
		       WIN_X,		0,
		       WIN_Y,		dFrame_y[i],
		       0);
         }
      else
	 close_dframe(i);
   prev_useHost_val = (int)panel_get(useDHost_item, PANEL_VALUE);
   prev_show_val = (int)panel_get(dShow_item, PANEL_VALUE);
} /* addDest_proc */

static void
newDest_proc(item, value, event) 
   Panel_item item;
   unsigned int value;
   Event *event; 
{
   int i;
   boolean change;

   change = new_y_positions();
   if (prev_useHost_val < value)
      for (i=0;i<max_dest;i++)
	 if ((1<<i & value) == (prev_useHost_val ^ value)) {
	    if (empty_str((char *)panel_get(dShow_item, 
					    PANEL_CHOICE_STRING, i)) &&
		!(int)window_get(dest_frame[i], WIN_SHOW)) {
	       change = TRUE;
	       window_set(dest_frame[i], WIN_SHOW, TRUE, 0);
	       }
	    break;
	    }  
   if (change)
      for (i=0;i<max_dest;i++)
	 if (window_get(dest_frame[i], WIN_SHOW))
	    window_set(dest_frame[i], 
		       WIN_SHOW, 	TRUE, 
		       WIN_X,		0,
		       WIN_Y,		dFrame_y[i],
		       0);
   prev_useHost_val = value;
} /* newDest_proc */

static void
param_proc(item, event)
   Panel_item item;
   Event *event; 
{
   if ((int)window_get(pFrame, WIN_SHOW))
      window_set(pFrame, WIN_SHOW, FALSE, 0);
   else
      window_set(pFrame, 
		 WIN_SHOW, 	TRUE, 
		 WIN_X,		ATTR_COL(17),
		 WIN_Y,		ATTR_ROW(2),
		 0);
}

static void
create_param_frame()
{
   Window params;
   int row = 0;

   pFrame = window_create(tool_frame, FRAME,
   		WIN_X, 			ATTR_COL(17),
		WIN_Y, 			ATTR_ROW(2),
   		FRAME_LABEL, 		"FTP Parameters",
		FRAME_SHOW_LABEL,	TRUE,
		FRAME_NO_CONFIRM, 	TRUE,
		FRAME_DONE_PROC, 	param_proc,
		0);
   params = window_create(pFrame, PANEL,
   		PANEL_ITEM_X_GAP,	15,
		0);
		
   stru_item = panel_create_item(params, PANEL_CYCLE,
		PANEL_LABEL_X,          ATTR_COL(0),
		PANEL_LABEL_Y,          ATTR_ROW(row),
		ATTR_LIST,		stru_attr,
		0);
   mode_item = panel_create_item(params, PANEL_CYCLE,
		ATTR_LIST,              mode_attr,
		0);
   type_item = panel_create_item(params, PANEL_CYCLE,
   		PANEL_LABEL_X,		ATTR_COL(0),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		ATTR_LIST,              type_attr,
		PANEL_VALUE,		type_choice(IMAGE),
		0);

   format_item = panel_create_item(params, PANEL_CYCLE,
		ATTR_LIST,              form_attr,
		PANEL_SHOW_ITEM, 	FALSE,
					 /* because of type IMAGE */
		0);
   byteSize_item = panel_create_item(params, PANEL_TEXT,
		ATTR_LIST,              byte_attr,
   		PANEL_LABEL_X,		(int)panel_get(format_item, 
						PANEL_LABEL_X),
		PANEL_LABEL_Y,
					(int)panel_get(format_item, 
						PANEL_LABEL_Y),
		0);
   multiple_item = panel_create_item(params, PANEL_CYCLE,
   		PANEL_LABEL_X,		ATTR_COL(0),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		ATTR_LIST,              mult_attr,
		0);
   append_item = panel_create_item(params, PANEL_CYCLE,
		ATTR_LIST,              app_attr,
		0);
   stou_item = panel_create_item(params, PANEL_CYCLE,
   		PANEL_LABEL_X,		ATTR_COL(0),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		ATTR_LIST,              stou_attr,
		0);
   window_fit(params);
   window_fit(pFrame);
}/* create_param_frame */

static boolean
new_host(i)  /* i is the entry being checked */
   int i;
{
   int j;
   boolean value = TRUE;

   /* eliminate duplicate entry */
   for (j = i-1; j >= 0; j--) {
      if (!strcmp(hosts[i].str, hosts[j].str)) { /* they match */
	 value = FALSE;
	 break;
         }
      if (user_set_host[j] && 
	  !strcmp(hosts[i].str, 
		  (char *)panel_get(dHost_item[j], PANEL_VALUE))) {
	  /* they match */
	 value = FALSE;
	 break;
         }
      }
   /* check validity of host name */
   if (value)
      if (!host_okay(hosts[i].str))
	 value = FALSE;

   return(value);
} /* new_host */

static void
get_hosts()
{
   int i, j;
   char filename[100];
   FILE *listp;

   /* Read in current hosts list from file mbftp.confhosts */
   sprintf(filename,"%smbftp.confhosts", bftp_dir);
   if ((listp = fopen(filename, "r")) == NULL) {
      for (i=0; i<max_dest; i++)
	  hosts[i].str[0]= '\0';
      }
   else {
      for (i=0; i<max_dest; ) {
	 if (fgets(hosts[i].str, sizeof(hosts[i].str), listp) == NULL) {
	    /* add the local host if needed */
	    if (conference && !strlen(def_passwd)) {
	       strcpy(hosts[i].str, def_hostname);
	       if (new_host(i))
		   i++;
		 else
		   hosts[i].str[0] = '\0';
	       }
	    /* clear out the rest of the entries */
	    while (i<max_dest) {
		 hosts[i].str[0]= '\0';
		 i++;
	         }
	    fclose(listp);
	    }
	 else {
	    /* get rid of line-feed */
	    hosts[i].str[strlen(hosts[i].str)-1]= '\0';
	    if (new_host(i))
	       i++;
	    else
	       hosts[i].str[0] = '\0';
	    }
         }
      }
   for (i = j = 0;i<max_dest && j<max_dest; i++) {
	 if (!user_set_host[i]) {
	    panel_set(dHost_item[i], PANEL_VALUE, hosts[j].str, 0);
	    panel_set(dShow_item, PANEL_CHOICE_STRING, i, hosts[j].str, 0);
	    set_status(i, " ");
	    j++;
	    }
       }
} /* get_hosts */   					

static void
close_proc()
{
   int i;
	
   for (i=0;i<max_dest;i++)
      close_dframe(i);
   prev_useHost_val = (int)panel_get(useDHost_item, PANEL_VALUE);
   prev_show_val = (int)panel_get(dShow_item, PANEL_VALUE);
   window_set(tool_frame, FRAME_CLOSED, TRUE, 0);
}

static void
quit_proc(item, event)
   Panel_item item;
   Event *event;
{
   int i;
   
   for (i=0;i<max_dest;i++)
      if (dest_pid[i])
	 kill(dest_pid[i], SIGKILL);
      
   window_destroy(tool_frame);
}

static void
submit_proc(item, event)
   Panel_item item;
   Event *event;
{
   set_buttons(FALSE);
   window_set(pFrame, WIN_SHOW, FALSE, 0);
   make_submit_frame(&req, 40, 3, 
		     (int)panel_get(verbose_item, PANEL_ITEM_X),
		     (int)panel_get(verbose_item, PANEL_ITEM_Y));
}

static void
create_tool_panel()
{
   Menu menu;
   char conf_str[60];
   int i,
       bwidth = 8,
       row = 0;

   window_destroy(tool_panel);

   tool_panel = window_create(tool_frame, PANEL,
		WIN_X,			0,
		WIN_Y,			0,
   		PANEL_ITEM_X_GAP,	15,
		0);

   if (conference) {
      sprintf(conf_str, "MBFTP Tool    ConfID: %s",
	      strlen(def_dir)?def_dir:"not set ");
      conf_str[strlen(conf_str)-1] = '\0';
      window_set(tool_frame, FRAME_LABEL, conf_str, 0);
      }
   transferAll_item = panel_create_item(tool_panel, PANEL_BUTTON,
	   	PANEL_LABEL_X,		ATTR_COL(0),
		PANEL_LABEL_Y,		ATTR_ROW(0),
   		PANEL_LABEL_IMAGE,
		    panel_button_image(tool_panel, "Transfer", bwidth,0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	transfer_all,
		0);
   param_item = panel_create_item(tool_panel, PANEL_BUTTON,
   		PANEL_LABEL_IMAGE,
			panel_button_image(tool_panel, "ShowParams", bwidth, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	param_proc,
		0);
   submitAll_item = panel_create_item(tool_panel, PANEL_BUTTON,
   		PANEL_LABEL_IMAGE,
		    panel_button_image(tool_panel, "Submit", bwidth, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	submit_proc,
		0);
		
   quit_item = panel_create_item(tool_panel, PANEL_BUTTON,
   		PANEL_LABEL_X,		ATTR_COL(0),
		PANEL_LABEL_Y,		(ATTR_ROW(++row)+(row*8)),
   		PANEL_LABEL_IMAGE,
			panel_button_image(tool_panel, "Quit", bwidth, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	quit_proc,
		0);
   if (conference) {
      if (strlen(def_passwd))
	 dist_item = panel_create_item(tool_panel, PANEL_CYCLE,	
		PANEL_LABEL_STRING,     "Dist:",
		PANEL_CHOICE_STRINGS,   "Src->Here->Dsts",
				 	"Here->Dsts",
				 	0,
		PANEL_VALUE,            0,
		PANEL_DISPLAY_LEVEL,    PANEL_CURRENT,
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	dist_proc,
		0);
      }
   else {
      storage_item = panel_create_item(tool_panel, PANEL_BUTTON,
   		PANEL_LABEL_IMAGE,
		   panel_button_image(tool_panel, "RequestStorage", bwidth, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	rStorage_proc,
		0);
      init_rs_location(ATTR_COL(17), ATTR_ROW(8));
      }

   resetAll_item = panel_create_item(tool_panel, PANEL_BUTTON,
   		PANEL_LABEL_X,		ATTR_COL(0),
		PANEL_LABEL_Y,		(ATTR_ROW(++row)+(row*8)),
   		PANEL_LABEL_IMAGE,
			panel_button_image(tool_panel, "Reset", bwidth, 0),
		PANEL_EVENT_PROC,	dummy_event_proc,
		PANEL_NOTIFY_PROC,	reset_all,
		0);
   verbose_item = panel_create_item(tool_panel, PANEL_CYCLE,
   		PANEL_LABEL_STRING,	"Verbose:",
		PANEL_CHOICE_STRINGS, 	"FALSE", "TRUE", 0,
		PANEL_VALUE,		0,
		PANEL_DISPLAY_LEVEL,	PANEL_CURRENT,
		PANEL_EVENT_PROC,	dummy_event_proc,
		0);

   row++;
   src_msg = panel_create_item(tool_panel, PANEL_MESSAGE,
   		PANEL_LABEL_X,          ATTR_COL(0),
		PANEL_LABEL_Y,          ATTR_ROW(++row),
		PANEL_LABEL_STRING,     "Src --",
		0);
   sDir_item = panel_create_item(tool_panel, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(2),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		PANEL_VALUE, 		def_dir,
		ATTR_LIST,		dir_attr,
		0);
   if (strlen(def_dir))
      panel_set(sDir_item, PANEL_EVENT_PROC, display_dir_menu, 0);

   sFile_item = panel_create_item(tool_panel, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(2),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		ATTR_LIST,		file_attr,
		PANEL_EVENT_PROC,       sFile_event_proc,
		0);
   sHost_item = panel_create_item(tool_panel, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(2),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		ATTR_LIST, 		host_attr,
		0);
   sLogin_item = panel_create_item(tool_panel, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(2),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		ATTR_LIST,		login_attr,
		0);
   sPass_item = panel_create_item(tool_panel, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(2),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		ATTR_LIST,		pass_attr,
		0);
   if (strlen(def_passwd)) {
      panel_set(sPass_item, PANEL_EVENT_PROC, hint_event_proc, 0);
      sPassDef_msg = panel_create_item(tool_panel, PANEL_MESSAGE,
   		PANEL_LABEL_X,	     (int)panel_get(sPass_item,
						    PANEL_VALUE_X),
		PANEL_LABEL_Y,	     (int)panel_get(sPass_item,
						    PANEL_VALUE_Y),
	        PANEL_LABEL_STRING,  same_as_pass,
		0);
      }
   if (conference) {
      conf_msg = panel_create_item(tool_panel, PANEL_MESSAGE,
   		PANEL_LABEL_X,		ATTR_COL(0),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		PANEL_LABEL_STRING,	"Here --",
		0);
      cFile_item = panel_create_item(tool_panel, PANEL_TEXT,
   		PANEL_LABEL_X,		ATTR_COL(2),
		PANEL_LABEL_Y,		ATTR_ROW(++row),
		ATTR_LIST,		file_attr,
		PANEL_EVENT_PROC,       hint_event_proc,
		0);
      cFileDef_msg = panel_create_item(tool_panel, PANEL_MESSAGE,
   		PANEL_LABEL_X,	      (int)panel_get(cFile_item, PANEL_VALUE_X),
		PANEL_LABEL_Y,	      (int)panel_get(cFile_item, PANEL_VALUE_Y),
		PANEL_LABEL_STRING,	SAME_AS_SRC,
		0);
      }

   switch (max_dest) {
   case 4:
     useDHost_item = panel_create_item(tool_panel, PANEL_TOGGLE,
        	PANEL_LABEL_STRING, 	"Dsts -- ", 
		PANEL_SHOW_MENU,	FALSE,
	        PANEL_LABEL_X,		ATTR_COL(0),
	        PANEL_LABEL_Y,          ATTR_ROW(++row),
		PANEL_LAYOUT,		PANEL_VERTICAL,
		PANEL_CHOICE_STRINGS,	" ",
					" ",
					" ",
					" ",
					0,
		PANEL_MARK_XS,		ATTR_COL(10),
					ATTR_COL(10),
					ATTR_COL(10),
					ATTR_COL(10),
					0,
		PANEL_CHOICE_XS,	ATTR_COL(0),
					ATTR_COL(0),
					ATTR_COL(0),
					ATTR_COL(0),
					0,
		PANEL_NOTIFY_PROC,	newDest_proc,
		PANEL_EVENT_PROC,	dummy_event_proc,
   		0);
     dShow_item = panel_create_item(tool_panel, PANEL_TOGGLE,
   		PANEL_LABEL_STRING,     "",
		PANEL_SHOW_MENU,	FALSE,
		PANEL_LAYOUT,		PANEL_VERTICAL,
		PANEL_FEEDBACK,		PANEL_INVERTED,
		PANEL_CHOICE_STRINGS,	"",
					"",
				  	"",
					"",
					0,
		PANEL_CHOICE_XS,	ATTR_COL(13),
					ATTR_COL(13),
					ATTR_COL(13),
					ATTR_COL(13),
					0,
		PANEL_CHOICE_YS,
			(int)panel_get(useDHost_item, PANEL_CHOICE_Y, 0),
			(int)panel_get(useDHost_item, PANEL_CHOICE_Y, 1),
			(int)panel_get(useDHost_item, PANEL_CHOICE_Y, 2),
			(int)panel_get(useDHost_item, PANEL_CHOICE_Y, 3),
					0,
		PANEL_NOTIFY_PROC,	addDest_proc,
		PANEL_EVENT_PROC,	dummy_event_proc,
   		0);
     break;
   case 3:
     useDHost_item = panel_create_item(tool_panel, PANEL_TOGGLE,
        	PANEL_LABEL_STRING, 	"Destinations", 
		PANEL_SHOW_MENU,	FALSE,
	        PANEL_LABEL_X,		ATTR_COL(0),
	        PANEL_LABEL_Y,          ATTR_ROW(++row),
		PANEL_LAYOUT,		PANEL_VERTICAL,
		PANEL_CHOICE_STRINGS,	" ",
					" ",
					" ",
					0,
		PANEL_MARK_XS,		ATTR_COL(10),
					ATTR_COL(10),
					ATTR_COL(10),
					0,
		PANEL_CHOICE_XS,	ATTR_COL(0),
					ATTR_COL(0),
					ATTR_COL(0),
					0,
		PANEL_NOTIFY_PROC,	newDest_proc,
		PANEL_EVENT_PROC,	dummy_event_proc,
   		0);
     dShow_item = panel_create_item(tool_panel, PANEL_TOGGLE,
   		PANEL_LABEL_STRING,     "",
		PANEL_SHOW_MENU,	FALSE,
		PANEL_LAYOUT,		PANEL_VERTICAL,
		PANEL_FEEDBACK,		PANEL_INVERTED,
		PANEL_CHOICE_STRINGS,	"",
					"",
				  	"",
					0,
		PANEL_CHOICE_XS,	ATTR_COL(13),
					ATTR_COL(13),
					ATTR_COL(13),
					0,
		PANEL_CHOICE_YS,
			(int)panel_get(useDHost_item, PANEL_CHOICE_Y, 0),
			(int)panel_get(useDHost_item, PANEL_CHOICE_Y, 1),
			(int)panel_get(useDHost_item, PANEL_CHOICE_Y, 2),
					0,
		PANEL_NOTIFY_PROC,	addDest_proc,
		PANEL_EVENT_PROC,	dummy_event_proc,
   		0);
   }

   window_fit(tool_panel);
   window_fit(tool_frame);

   /* initialize the destination hosts */
   make_dest_frames();

   get_hosts();
   /* set the values for useDHost_item, and decide whether to show
      sHost_item, sLogin_item, and sPass_item */
   if (!conference || !strlen(def_passwd))
      src_to_dsts();
   else
      dist_proc(dist_item, (int)panel_get(dist_item, PANEL_VALUE), 0);

   menu = (Menu)window_get(tool_frame, WIN_MENU);
   menu_set((Menu_item)menu_find(menu, MENU_STRING, "Close", 0),
	    MENU_ACTION_PROC, close_proc, 0);
   menu_set((Menu_item)menu_find(menu, MENU_STRING, "Quit", 0),
	    MENU_ACTION_PROC, quit_proc, 0);

   toolsetup = TRUE;
} /* create_tool_panel */

static void
copy_password()
{
   struct passwd *pwd;
   char *namep;

   strcpy(def_passwd, (char *)panel_get(pPass_item, PANEL_VALUE));
   setpwent();
   if (empty_str(def_passwd) || (pwd = getpwnam(def_user)) == NULL) {
	 def_passwd[0] = '\0';
	 create_tool_panel();
	 create_param_frame();
	 panel_set(sDir_item, PANEL_VALUE, "", 0);
         }
   else {
	 namep = crypt(def_passwd, pwd->pw_passwd);
	 if (!strcmp(namep, pwd->pw_passwd)) {
	    /* password is valid */
	    create_tool_panel();
	    create_param_frame();
            }
	 else {
            panel_set(pPass_item, PANEL_VALUE, "", 0);
	    panel_set(pMsg_item, 
		      PANEL_LABEL_STRING, 
		          "   Password incorrect; re-enter, or type <RETURN>.", 
		      0);
	    }
         }
   endpwent();
} /* copy_password */

static void
get_word(item, event)
   Panel_item item;
   Event *event;
{
  /* return is the same as "Done" */
  if ('\015' == (char)event_id(event))
     copy_password();
  else
     no_spaces(item, event);
}

static char dir[100];

/* Read in the default directory from file mbftp.confid */
char *
get_confid()
{
   char temp[100];
   int i;
   FILE *listp;

   dir[0] = '\0';
   if (conference) {
      sprintf(temp,"%smbftp.confid", bftp_dir);
      if ((listp = fopen(temp, "r")) != NULL) {
	 if (fgets(dir, sizeof(dir), listp) != NULL) {
	    if (dir[strlen(dir)-1] == '\n')
	       dir[strlen(dir)-1]= '\0';
	    if (dir[strlen(dir)-1] != '/')
	       strcat(dir, "/");
	    /* check validity of directory name */
	    sprintf(temp,"%s/%s",getenv("HOME"), dir);
	    if ((i = open(temp, O_RDONLY)) < 0)
	       dir[0]= '\0';
	    else
	       close(i);
	    }
	 fclose(listp);
         }
      }
   return(dir);
} /* get_confid */		

static Notify_value
read_init_files(me, signal, when)
   int *me;
   int signal;
   Notify_signal_mode when;
{
   char conf_str[60], *cp, *src;
   int i;

   if (toolsetup) {
      cp = get_confid();
      if (!strlen(def_dir)) {
	 if (strlen(cp)) {
	    /* add dir_menu */
	    init_dir_menu();
	    panel_set(sDir_item, PANEL_EVENT_PROC, display_dir_menu, 0);
	    for (i=0;i<max_dest;i++)
	       panel_set(dDir_item[i], 
	                 PANEL_EVENT_PROC, display_dir_menu, 
			 0);
	    }
         }
      else
	 if (!strlen(cp)) {
	    /* delete menu */
	    panel_set(sDir_item, PANEL_EVENT_PROC, no_spaces, 0);
	    for (i=0;i<max_dest;i++)
	       panel_set(dDir_item[i], PANEL_EVENT_PROC, no_spaces, 0);
	    menu_destroy(dir_menu);
	    }

      /* if the current dir is the same as the old default, update it */
      if (conference && strlen(def_passwd)) {
	if (!strcmp(def_dir, (char *)panel_get(sDir_item, PANEL_VALUE)) &&
	     (int)panel_get(dist_item, PANEL_VALUE)) /* Here->Dsts */
	       panel_set(sDir_item, PANEL_VALUE, cp, 0);
	for (i=0;i<max_dest;i++) 
	  if (!strcmp(def_dir, (char *)panel_get(dDir_item[i], PANEL_VALUE)))
	    panel_set(dDir_item[i], PANEL_VALUE, cp, 0);
      }

      strcpy(def_dir, cp);
      if (conference) {
	 sprintf(conf_str, "MBFTP Tool    ConfID: %s",
		 strlen(def_dir)?def_dir:"not set ");
	 conf_str[strlen(conf_str)-1] = '\0';
	 window_set(tool_frame, FRAME_LABEL, conf_str, 0);
         }

      get_hosts();
      /* set the values for useDHost_item */
      if (conference && strlen(def_passwd))
	switch ((int)panel_get(dist_item, PANEL_VALUE)) {
	case 1: /* Here->Dsts */
	    for (i=0;i<max_dest;i++) {
	      cp = (char *)panel_get(dShow_item, PANEL_CHOICE_STRING, i);
	      panel_set(useDHost_item, 
		     	PANEL_TOGGLE_VALUE, 	i, 
		     ((!empty_str(cp)) && !host_matches(cp, def_hostname))
		        ?TRUE:FALSE, 
		     	0);
	      }
	    break;
	  case 0: /* Src->Here->Dsts */
	     src = (char *)panel_get(sHost_item, PANEL_VALUE);
	     for (i=0;i<max_dest;i++) {
	        cp = (char *)panel_get(dShow_item, PANEL_CHOICE_STRING, i);
		panel_set(useDHost_item, 
		     	PANEL_TOGGLE_VALUE, 	i, 
		     ((!empty_str(cp)) && !host_matches(cp, def_hostname) &&
		      !host_matches(cp, src))
		        ?TRUE:FALSE, 
		     	0);
	        }
	  }
      else { /* Src->Dsts */
	 src = (char *)panel_get(sHost_item, PANEL_VALUE);
	 for (i=0;i<max_dest;i++) {
	   cp = (char *)panel_get(dShow_item, PANEL_CHOICE_STRING, i);
	   panel_set(useDHost_item,
		     PANEL_TOGGLE_VALUE,     i,
		     ((!empty_str(cp)) && !host_matches(cp, src))?TRUE:FALSE,
		     0);
	   }
         }
    }
   prev_useHost_val = (int)panel_get(useDHost_item, PANEL_VALUE);

   return(NOTIFY_IGNORED);
} /* read_init_files */

/* Notify Proc */

password_done(item, value, event)
        Panel_item item;
        unsigned int value;
        Event *event;
{
   copy_password();
}

static void
tool_help(name)
   char *name;
{
   fprintf(stderr,"Multiple-site Background File Transfer Program\n\n");
   frame_cmdline_help(name);
}

main(argc, argv)
   int argc;
   char **argv;
{
   int  client, 
        tempargc = argc;
   char **tempargv = argv;

   while (--tempargc > 0 && *++tempargv)
      if (!strncmp("-c", *tempargv, 2)) {
	 conference = TRUE;
	 break;
         }

   (void)notify_set_signal_func(&client, read_init_files, SIGUSR1, NOTIFY_SYNC);

   init_help();

   /* if the table size is small, cut back to 3 destinations */
   max_dest = (getdtablesize() > 32)? MAX_DEST: 3;

   init_user();
   if (strlen(def_user)) {
      sprintf(same_as_login,"(default is \"%s\")", def_user);
      sprintf(same_as_pass, "(password for \"%s\")", def_user);
      }
   else {
      strcpy(same_as_login, "(same as current login)");
      sprintf(same_as_pass, same_as_login);
      }

   init_req(&req);
   init_src_file_menu();
   init_login_menu();
   init_passw_menu();
   init_host_menu();
   init_attr_lists();

   strcpy(def_dir, get_confid());
   if (strlen(def_dir))
      init_dir_menu();

   /* create tool frame */
   tool_frame = window_create(NULL, FRAME,
   		FRAME_LABEL, 		"MBFTP Tool",
		FRAME_ICON,  		&bftp_icon, 
		FRAME_CMDLINE_HELP_PROC, tool_help,
		FRAME_ARGS,		argc, argv,
		WIN_ERROR_MSG,		"Can't create window.",
		FRAME_NO_CONFIRM, 	TRUE,
		0);
   tool_panel = window_create(tool_frame, PANEL,
   		PANEL_ITEM_X_GAP,	15,
		0);

   /* create preliminary fields */
   pPass_item = panel_create_item(tool_panel, PANEL_TEXT,
   	PANEL_LABEL_STRING,
		"MBFTPTool Initialization -- Enter default (local) password: ",
	PANEL_VALUE,		"",
	PANEL_EVENT_PROC,	get_word,
	PANEL_VALUE_DISPLAY_LENGTH, 2,
	PANEL_MASK_CHAR,	' ',
	0);
   pDone_item =  panel_create_item(tool_panel, PANEL_BUTTON,
   	PANEL_LABEL_X,		ATTR_COL(0),
	PANEL_LABEL_Y,		ATTR_ROW(1),
   	PANEL_LABEL_IMAGE, panel_button_image(tool_panel, "Done", 4, 0),
	PANEL_NOTIFY_PROC, 	password_done,
	PANEL_EVENT_PROC,	dummy_event_proc,
	0);
   pMsg_item = panel_create_item(tool_panel, PANEL_MESSAGE,
	PANEL_LABEL_STRING,     " ",
	0);
				 
   window_fit(tool_panel);
   window_fit(tool_frame);

   window_main_loop(tool_frame);
   exit(0);
}
