    /*********************************************************************\
    *  Copyright (c) 1991 by Wen-King Su (wen-king@vlsi.cs.caltech.edu)   *
    *                                                                     *
    *  You may copy or modify this file in any manner you wish, provided  *
    *  that this notice is always included, and that you hold the author  *
    *  harmless for any loss or damage resulting from the installation or *
    *  use of this software.                                              *
    \*********************************************************************/

#include "server_def.h"

#define ERR(S) { send_error(from,ub,S); return; }

int max_nlen   = FILE_NAME_LIMIT;
int inetd_mode =               0;
int dbug       =               0;
int   udp_port =    DEF_FSP_PORT;
char *home_dir =    DEF_FSP_HOME;
char *run_uid  =               0;

/****************************************************************************
*  This is the dispatch loop for message that has been accepted.
*    bytes: size of the message received.
*       ub: pointer to the message buffer.
*      old: true if this message contains old sequence number (retransmit).
*       hp: pointer to the entry for the client host who sent this message.
*     from: pointer to the socket address structure of the client host.
****************************************************************************/

server_get_packet(bytes,ub,old,hp,from)
    int   bytes,old;
    UBUF *ub;
    HTAB *hp;
    struct sockaddr_in *from;
{
    unsigned long  inet_num;
    unsigned short port_num;
    unsigned l1, l2;
    char *s1, *s2, *pe;
    FILE *fp;
    PPATH pp;

    l1 = ub->len;
    l2 = bytes - l1 - UBUF_HSIZE;
    s1 = ub->buf;
    s2 = ub->buf + l1;

    if(dbug) fprintf(stderr,"rcv (%c,%d,%d,%lu) <--- %d.%d.%d.%d\n",
		ub->cmd, l1, l2, ub->pos,
		((unsigned char *)(&hp->inet_num))[0],
		((unsigned char *)(&hp->inet_num))[1],
		((unsigned char *)(&hp->inet_num))[2],
		((unsigned char *)(&hp->inet_num))[3]);

    if(!old) { hp->last_key = hp->next_key;
	       hp->next_key = get_next_key() + ((hp->last_key+1) & 0x00ff); }

    ub->key  = hp->next_key;
    inet_num = hp->inet_num;
    port_num = from->sin_port;

    switch(ub->cmd)
    {
      case CC_VERSION : { ERR(VERSION_STR); }

      case CC_BYE     : { if(!old) hp->active = 0;
			  server_reply(from,ub,0,0);
			  return; }
			
      case CC_GET_DIR : { if((pe = check_path(s1,l1,&pp)) ||
			     (pe = server_get_dir(&pp,&fp))) ERR(pe);
			  send_file(from,ub,fp,l2,s2);
			  fclose(fp);
			  return; }

      case CC_GET_FILE: { if((pe = check_path(s1,l1,&pp)) ||
		             (pe = server_get_file(&pp,&fp))) ERR(pe);
			  send_file(from,ub,fp,l2,s2);
			  fclose(fp);
			  return; }

      case CC_DEL_FILE: { if(!old)
			    if((pe = check_path(s1,l1,&pp)) ||
			       (pe = server_del_file(&pp,inet_num))) ERR(pe);
			  server_reply(from,ub,0,0);
			  return; }

      case CC_DEL_DIR : { if(!old)
			    if((pe = check_path(s1,l1,&pp)) ||
			       (pe = server_del_dir(&pp,inet_num))) ERR(pe);
			  server_reply(from,ub,0,0);
			  return; }

      case CC_UP_LOAD : { if(!old)
			    if(pe = server_up_load(s1,l1,ub->pos,
						   inet_num,port_num)) ERR(pe);
			  server_reply(from,ub,0,0);
			  return; }

      case CC_INSTALL : { if(!old)
			    if((pe = check_path(s1,l1,&pp)) ||
			       (pe = server_install(&pp,inet_num,port_num)))
								       ERR(pe);
			  server_reply(from,ub,0,0);
			  return; }

      case CC_MAKE_DIR: { if(!old)
			    if((pe = check_path(s1,l1,&pp)) ||
			       (pe = server_make_dir(&pp,inet_num))) ERR(pe);
			  if(pe = server_get_pro(&pp,s1,inet_num)) ERR(pe);
			  server_reply(from,ub,strlen(ub->buf)+1,0);
			  return; }

      case CC_GET_PRO : { if((pe = check_path(s1,l1,&pp)) ||
			     (pe = server_get_pro(&pp,s1,inet_num))) ERR(pe);
			  server_reply(from,ub,strlen(ub->buf)+1,0);
			  return; }

      case CC_SET_PRO : { if(!old)
			    if((pe = check_path(s1,l1,&pp)) ||
			       (pe = server_set_pro(&pp,s2,inet_num))) ERR(pe);
			  if(pe = server_get_pro(&pp,s1,inet_num)) ERR(pe);
			  server_reply(from,ub,strlen(ub->buf)+1,0);
			  return; }

      case CC_GRAB_FILE: { if(pe = check_path(s1,l1,&pp)) ERR(pe);
			   if(!old && !ub->pos)
			     if(pe = server_secure_file(&pp,inet_num,port_num))
								       ERR(pe);
			   if(pe = server_grab_file(&pp,&fp,inet_num,port_num))
								       ERR(pe);
			   send_file(from,ub,fp,l2,s2);
			   fclose(fp);
			   return; }

      case CC_GRAB_DONE: { if(pe = check_path(s1,l1,&pp)) ERR(pe);
			   if(!old)
			     if(pe = server_grab_done(&pp,inet_num,port_num))
								       ERR(pe);
			   server_reply(from,ub,0,0);
			   return; }

    }
}

arg_err()
{
    fputs("arg: -h absolute_path    set home directory.\n",stderr);
    fputs("     -p udp_port_number  set port number.\n",stderr);
    fputs("     -u uid_number       assume this uid after startup.\n",stderr);
    fputs("     -d                  turn on debug mode.\n",stderr);
    exit(1);
}

main(argc,argv)
    int argc;
    char **argv;
{
    int t;

    inetd_mode = !strcmp(argv[0],"in.fspd");

    if(inetd_mode)
    {
	init_inetd();
	freopen("/dev/null","r",stdin);
	freopen("/dev/null","w",stdout);
	freopen("/dev/null","w",stderr);
    }

    for(t = 1; t < argc; t++)
    {
	if(argv[t][0] == '-') switch(argv[t][1])
	{
	    case 'd':	dbug++; break;

	    case 'h':	if(argv[t][2]) home_dir = argv[t]+2; else
			if(argv[t+1] ) home_dir = argv[++t]; else
								arg_err();
			break;

	    case 'u':	if(argv[t][2]) run_uid = argv[t]+2; else
			if(argv[t+1] ) run_uid = argv[++t]; else
								arg_err();
			break;

	    case 'p':	if(argv[t][2]) udp_port = atoi(argv[t]+2); else
			if(argv[t+1] ) udp_port = atoi(argv[++t]); else
								arg_err();
			break;

	    default : arg_err();

	} else arg_err();
    }

    if(!inetd_mode)
    {
	init_network(udp_port);
	if(!dbug) { freopen("/dev/null","r",stdin);
		    freopen("/dev/null","w",stdout);
		    freopen("/dev/null","w",stderr); }
    }

    if(run_uid) if(setuid(atoi(run_uid)) != 0) exit(1);
    init_home_dir();
    init_htab();

    srandom(getpid());

    if(inetd_mode) {	      server_loop(120*1000L); }  /* 2 minutes */
	      else { while(1) server_loop(      -1L); }

    exit(0);
}
