    /*********************************************************************\
    *  Copyright (c) 1991 by Wen-King Su (wen-king@vlsi.cs.caltech.edu)   *
    *                                                                     *
    *  You may copy or modify this file in any manner you wish, provided  *
    *  that this notice is always included, and that you hold the author  *
    *  harmless for any loss or damage resulting from the installation or *
    *  use of this software.                                              *
    \*********************************************************************/

#include "common_def.h"

/****************************************************************************
*  HTAB is structure for storing client information for one client machine.
*  They makes it easy to reuse regular unix tool's source for new purposes.
****************************************************************************/

typedef struct HTAB HTAB;

struct HTAB {	unsigned long	inet_num;	/* inet number of client     */
		unsigned long   last_acc;	/* last sucessful access time*/
		unsigned short	next_key;	/* next key client should use*/
		unsigned short	last_key;	/* previous key client used  */
		unsigned short   acc_cnt;	/* number of successful acc  */
		unsigned short  active:1;   	/* session continuing.	     */
		unsigned short inhibit:1; };	/* deny access permission.   */

/*****************************************************************************
* The PPATH structure is filled in by the function check_path when given a
* path string.  See server_file.c for more info.
*****************************************************************************/

typedef struct { char *fullp;
		 char *f_ptr;
		 int   f_len;
		 char *d_ptr;
		 int   d_len; } PPATH;

extern init_htab();
extern HTAB *find_host();
extern char *check_path();

extern char *server_make_dir();
extern char *server_del_dir();
extern char *server_del_file();
extern char *server_get_dir();
extern char *server_get_file();
extern char *server_get_pro();
extern char *server_set_pro();
extern char *server_up_load();
extern char *server_install();
extern char *server_secure_file();
extern char *server_grab_file();
extern char *server_grab_done();

extern int dbug;
extern char *home_dir;
extern int max_nlen;
