    /*********************************************************************\
    *  Copyright (c) 1991 by Wen-King Su (wen-king@vlsi.cs.caltech.edu)   *
    *                                                                     *
    *  You may copy or modify this file in any manner you wish, provided  *
    *  that this notice is always included, and that you hold the author  *
    *  harmless for any loss or damage resulting from the installation or *
    *  use of this software.                                              *
    \*********************************************************************/

#include "server_def.h"

/****************************************************************************
* This file contains routines to maintain client database.
****************************************************************************/

extern char *realloc(), *malloc(), *ctime();

static HTAB     *htab;		/* client data base.			*/
static unsigned  hcnt;		/* number of clients.			*/
static unsigned  htot = 0;	/* available entries in the data base.	*/
static HTAB     hzero;

#define HALLOC_SIZE 30

/****************************************************************************
* Returns an entry from the database corresponding to to the inet number.
* A new entry is created is it is not found.
* The database is a linear array of sorted structures.
* Entries are searched using binary search on the array.
****************************************************************************/

HTAB *find_host(inet_num)
    unsigned long inet_num;
{
    unsigned	  l, h, m, i;
    unsigned long inum;
    HTAB	  *hs, *hd;

    for(l = 0, h = hcnt-1; (m = (l + h) >> 1) != l; )	/* binary search */
    {
	inum = htab[m].inet_num;
	if(inum > inet_num) h = m; else
	if(inum < inet_num) l = m; else { htab[m].acc_cnt++; return(htab+m); }
    }

    if(htab[m].inet_num < inet_num) m++;  /* locate first entry that is > */

    if((hcnt+1) > htot)			/* need more space */
    {
	htot += HALLOC_SIZE;		/* add HALLOC_SIZE entries at a time */

	if(!(htab = (HTAB *) realloc(htab,sizeof(HTAB)*htot)))
				    { perror("grow_htab realloc"); exit(1); }
    }

    for(i = hcnt-m, hs = htab+hcnt, hd=htab+hcnt+1; i--; *--hd = *--hs);

    htab[m]=hzero;
    htab[m].inet_num = inet_num;
    htab[m].last_key = get_next_key()  ;
    htab[m].next_key = get_next_key()+1;
    hcnt++;
    return(htab+m);
}

/****************************************************************************
* Write out the client table in the .HTAB_DUMP file.
****************************************************************************/

dump_htab()
{
    int i;
    FILE *fp;
    HTAB *hp;

    if(!(fp = fopen(".HTAB_DUMP","w"))) return;

    for(i = hcnt-2, hp = htab+1; i--; hp++)
    {
	fprintf(fp,"%d.%d.%d.%d\t%5d %c %s",
			    ((unsigned char *)(&hp->inet_num))[0],
			    ((unsigned char *)(&hp->inet_num))[1],
			    ((unsigned char *)(&hp->inet_num))[2],
			    ((unsigned char *)(&hp->inet_num))[3],
			    hp->acc_cnt,
			    (hp->inhibit) ? '*' : ((hp->active) ? '+' : ' '),
			    ctime(&(hp->last_acc)));
    }

    fclose(fp);
}

/****************************************************************************
* Client database initialization routine.  Reads in .ROGUE_HOSTS.
****************************************************************************/

init_htab()		/* always have 2 entries -- 0, MAXINT */
{
    FILE *fp;
    HTAB	*hp;
    char  buf[1024];
    unsigned int i1,i2,i3,i4;
    unsigned long hnum;

    if(!(htab = (HTAB *) malloc(sizeof(HTAB)*HALLOC_SIZE)))
				{ perror("grow_htab malloc"); exit(1); }
    htab[0] = hzero;
    htab[1] = hzero;
    htab[1].inet_num = ~0;
    hcnt = 2;
    htot = HALLOC_SIZE;

    if(fp = fopen(".ROGUE_HOSTS","r"))
    {
	while(fgets(buf,sizeof(buf),fp))
	{
	    if(*buf < '0' || *buf > '9') continue;

	    sscanf(buf,"%d.%d.%d.%d",&i1,&i2,&i3,&i4);
	    ((unsigned char *) (&hnum))[0] = i1;
	    ((unsigned char *) (&hnum))[1] = i2;
	    ((unsigned char *) (&hnum))[2] = i3;
	    ((unsigned char *) (&hnum))[3] = i4;
	    hp = find_host(hnum);
	    hp->inhibit = 1;
	}
	fclose(fp);
    }
}
