    /*********************************************************************\
    *  Copyright (c) 1991 by Wen-King Su (wen-king@vlsi.cs.caltech.edu)   *
    *                                                                     *
    *  You may copy or modify this file in any manner you wish, provided  *
    *  that this notice is always included, and that you hold the author  *
    *  harmless for any loss or damage resulting from the installation or *
    *  use of this software.                                              *
    \*********************************************************************/

#include "common_def.h"

/****************************************************************************
* These structures are used to implement a opendir/readdir mechanism similar
* to that of the normal opendir/reader mechanism in unix.
****************************************************************************/

typedef struct DDLIST {	struct DDLIST *next;
			char          *path;
			RDIRENT  **dep_root;
			int         ref_cnt; } DDLIST;

typedef struct RDIR { DDLIST   *ddp;
		      RDIRENT **dep; } RDIR;

typedef struct rdirent { unsigned long  d_fileno;
			 unsigned short d_reclen;
			 unsigned short d_namlen;
			 char          *d_name; } rdirent;

extern UBUF     *client_interact();
extern RDIRENT **get_dir_blk();
extern rdirent  *util_readdir();
extern RDIR     *util_opendir();

extern int client_trace;
extern int client_intr_state;
extern int key_persists;
extern unsigned long target_delay;
extern unsigned long udp_sent_time;
extern unsigned short client_buf_len;
extern unsigned short client_net_len;
