/* ntp_compat.h,v 3.1 1993/07/06 01:06:49 jbj Exp
 * Collect all machine dependent idiosyncrasies in one place.
 */

#ifndef __ntp_machine
#define __ntp_machine

/*
    Various options.
    They can defined with the DEFS directive in the Config file if they
    are not defined here.
 
WHICH NICE

  HAVE_ATT_NICE     - Use att nice
  HAVE_BSD_NICE     - Use bsd setprioirty

KERNEL MUCKING - If you porting to a new system see xntpd/ntp_unixclock.c and
		 util/tickadj.c to see what these do. This is very system 
	         dependent stuff!!!
		 
  HAVE_LIBKVM       - Use libkvm to read kernal memory
  HAVE_READKMEM     - Use read to read kernal memory 
  NOKMEM	    - Don't read kmem
  HAVE_N_UN         - Have u_nn nlist struct.

WHICH SETPGRP TO USE - Not needed if NTP_POSIX_SOURCE is defined since you
		       better of setsid!

  HAVE_ATT_SETPGRP  - setpgrp(void) instead of setpgrp(int, int)


Signaled IO -  Signled IO defines. 

  HAVE_SIGNALED_IO  - Enable signaled io. Assumes you are going to use SIGIO
		      for tty and udp io.
  USE_UDP_SIGPOLL   - Use SIGPOLL on socket io. This assumes that the
		      sockets routines are defined on top of streams.
  USE_TTY_SIGPOLL   - Use SIGPOLL on tty io. This assumes streams.
  UDP_BACKWARDS_SETOWN - SunOS 3.5 or Ultirx 2.0 system.
	      

WHICH TERMINAL MODEL TO USE - I would assume HAVE_POSIX_TTYS if 
		      NTP_POSIX_SOURCE was set but cann't.  The 
		      posix tty driver is too restrictive on most systems.
		      It defined if you define STREAMS.

  HAVE_SYSV_TTYS    - Use SYSV termio.h
  HAVE_BSD_TTYS     - Use BSD stty.h
  HAVE_POSIX_TTYS   - "struct termios" has c_line defined

THIS MAKES PORTS TO NEW SYSTEMS EASY - You only have to wory about
		                       kernal mucking.

  NTP_POSIX_SOURCE  - Use POSIX functions over bsd functions and att functions.
		      This is NOT the same as _POSIX_SOURCE.
		      It is much weeker!


STEP SLEW OR TWO STEP - The Default is to step.

  SLEWALWAYS  	    - setttimeofday can not be used to set the time of day at 
		      all. 
  STEP_SLEW 	    - setttimeofday can not set the seconds part of time
		      time use setttimeofday to set the seconds part of the
		      time and the slew the seconds.
  FORCE_NTPDATE_STEP - even if SLEWALWAYS is defined, force a step of
		      of the systemtime (via settimeofday()). Only takes
		      affect if STEP_SLEW isn't defined.

MISC  

  USE_PROTOTYPES    - Prototype functions
  DOSYNCTODR        - Resync TODR clock  every hour.
  RETSIGTYPE        - Define signal function type.
  NO_SIGNED_CHAR_DECL - No "signed char" see include/ntp.h
  LOCK_PROCESS      -  Have plock.

  HAVE_UNISTD_H     - Maybe should be part of NTP_POSIX_SOURCE ?

You could just put the defines on the DEFS line in machines/<os> file.
I don't since there are lost of different types compiler that a systemm might
have, some that can do proto typing and others that cannot on the saem system.
I get a chanse to twiddle some of the configuration paramasters at compile
time based on compler/machine combinatsions by using this include file.
See convex, aix and sun configurations see how complex it get.

*/
  

/*
 * RS6000 running AIX.
 */
#if defined(SYS_AIX)
#define HAVE_SIGNALED_IO
#ifndef _BSD
#define NTP_STDC
#define NTP_POSIX_SOURCE
/*
 * Keep USE_PROTOTYPES and _NO_PROTO in step.
 */
#if  defined(_NO_PROTO)&&defined(USE_PROTOTYPES)
#undef USE_PROTOTYPES
#endif
#if  !defined(_NO_PROTO)&&!defined(USE_PROTOTYPES)
#define USE_PROTOTYPES
#endif
#endif /*_BSD */
#endif /* RS6000 */

/*
 * SunOS 4.X.X
 * Note: posix version has NTP_POSIX_SOURCE and HAVE_SIGNALED_IO
 */
#if defined(SYS_SUNOS4)
#define NO_SIGNED_CHAR_DECL
#define HAVE_LIBKVM 
#define HAVE_MALLOC_H
#define HAVE_BSD_NICE
#define	RETSIGTYPE	void
#endif

/*
 * Sinix-M
 */
#if defined(SYS_SINIXM)
#undef HAVE_SIGNALED_IO
#undef USE_TTY_SIGPOLL
#undef USE_UDP_SIGPOLL
#define NO_SIGNED_CHAR_DECL 
#define STEP_SLEW 		/* TWO step */
#define	RETSIGTYPE void
#define NTP_POSIX_SOURCE
#define HAVE_ATT_SETPGRP
#define HAVE_ATT_NICE
#endif

/*
 * SunOS 5.1 or SunOS 5.2 or Solaris 2.1 or Solaris 2.2
 */
#if defined(SYS_SOLARIS)
#define HAVE_SIGNALED_IO
#define USE_TTY_SIGPOLL
#define USE_UDP_SIGPOLL
#define NO_SIGNED_CHAR_DECL 
#define STEP_SLEW 		/* TWO step */
#define	RETSIGTYPE void
#define NTP_POSIX_SOURCE
#define HAVE_ATT_SETPGRP
#define HAVE_ATT_NICE
#endif

/*
 * Convex
 */
#if  defined(SYS_CONVEXOS10)||defined(SYS_CONVEXOS9)
#define HAVE_SIGNALED_IO
#define HAVE_N_UN
#define HAVE_READKMEM 
#define HAVE_BSD_NICE
#if defined(convex) 
#define	RETSIGTYPE int
#define NO_SIGNED_CHAR_DECL
#else
#if defined(__stdc__)&&!defined(USE_PROTOTYPES)
#define USE_PROTOTYPES
#endif
#if !defined(__stdc__)&&defined(USE_PROTOTYPES)
#undef  USE_PROTOTYPES
#endif
#define NTP_POSIX_SOURCE
#define HAVE_ATT_SETPGRP
#endif
#endif

/*
 * IRIX 4.X and IRIX 5.x
 */
#if defined(SYS_IRIX4)||defined(SYS_IRIX5)
#define HAVE_SIGNALED_IO
#define ADJTIME_IS_ACCURATE
#define LOCK_PROCESS
#define USE_PROTOTYPES
#define HAVE_ATT_SETPGRP
#define HAVE_BSD_NICE
#define NOKMEM
#define NTP_POSIX_SOURCE
#endif

/*
 * Ultrix
 * Note: posix version has NTP_POSIX_SOURCE and HAVE_SIGNALED_IO
 */
#if defined(SYS_ULTRIX)
#define S_CHAR_DEFINED
#define HAVE_READKMEM 
#define HAVE_BSD_NICE
#define	RETSIGTYPE	void
#endif

/*
 * AUX
 */
#if defined(SYS_AUX2)||defined(SYS_AUX3)
#define NO_SIGNED_CHAR_DECL
#define HAVE_READKMEM
#define HAVE_ATT_NICE
#define LOCK_PROCESS
#define NTP_POSIX_SOURCE
/*
 * This requires that _POSIX_SOURCE be forced on the
 * compiler command flag. We can't do it here since this
 * file is included _after_ the system header files and we
 * need to let _them_ know we're POSIX. We do this in
 * compilers/aux3.gcc...
 */
#define SLEWALWAYS
#define FORCE_NTPDATE_STEP
#define	RETSIGTYPE	void
#define HAVE_ATT_SETPGRP
#define HAVE_BSD_TTYS
#define LOG_NTP LOG_LOCAL1
#define HAVE_SIGNALED_IO
#endif

/*
 * Next
 */
#if defined(SYS_NEXT)
#define DOSYNCTODR
#define HAVE_READKMEM
#define HAVE_BSD_NICE
#define HAVE_N_UN
#undef NTP_POSIX_SOURCE
#endif

/*
 * HPUX
 */
#if defined(SYS_HPUX)
#define NTP_POSIX_SOURCE
#define HAVE_SIGNALED_IO
#define HAVE_UNISTD_H
#define NO_SIGNED_CHAR_DECL
#define LOCK_PROCESS
#define RETSIGTYPE      void
#if (SYS_HPUX < 10)
#define NOKMEM
#else
#define HAVE_READKMEM
#endif
#endif

/*
 * bsdi
 */
#if defined(SYS_BSDI)
#define HAVE_SIGNALED_IO
#define HAVE_LIBKVM
#define NTP_POSIX_SOURCE
#define HAVE_BSD_NICE
#endif

/*
 * DECOSF1
 */
#if defined(SYS_DECOSF1)
#define HAVE_SIGNALED_IO
#define HAVE_READKMEM
#define NTP_POSIX_SOURCE
#endif

/*
 * I386
 */
#if defined(SYS_I386)
#define HAVE_READKMEM 
#define S_CHAR_DEFINED 
#define HAVE_BSD_NICE
#endif

/*
 * Mips
 */
#if defined(SYS_MIPS)
#define NOKMEM 
#define HAVE_BSD_NICE
#endif

/*
 * SEQUENT
 */
#if defined(SYS_SEQUENT)
#define HAVE_BSD_NICE
#endif

/*
 * Sony
 */
#if defined(SYS_SONY)
#define NO_SIGNED_CHAR_DECL 
#define HAVE_READKMEM
#define HAVE_BSD_NICE
#endif

/*
 * VAX
 */
#if defined(SYS_VAX)
#define NO_SIGNED_CHAR_DECL 
#define HAVE_READKMEM 
#define HAVE_BSD_NICE
#endif


#ifndef	RETSIGTYPE
#if defined(NTP_POSIX_SOURCE)
#define	RETSIGTYPE	void
#else
#define	RETSIGTYPE	int
#endif
#endif

#endif /* __ntp_machine */
