void setcfg()
{
/*
	this subroutine opens the configuration file named
	nbstime.cfg and sets the various global parameters
	based on the contents.  if the file does not exist
	the globals are not altered and the default configuration
	is used.  the global parameters are defined in the main
	program preamble.
*/
#include <stdio.h>
#include <ctype.h>
FILE *fopen();
FILE *iop;
extern FILE *jop;
int j,eol;
char c;
char *peof,*perr;
extern int utcdif;         /* local time - utc in hours */
extern int dsflag;         /* daylight savings time? 1=yes, 0=no */
extern int cmport;         /* 0=use com1, 1=use com2 */
extern int atflag;         /* 1=AT-type machine with CMOS clock, 0= not */
extern char number[30];    /* number to dial with trailing <cr> and 0 */
extern int echo;           /* expect echoes from modem? 1=yes, 0=no */
extern int hs;             /* 1 = use 1200 baud, 0=use 300 baud     */
extern int lpt;             /* 1=  pulse lp on time, 0= do not pulse */
extern int setclk;         /*  1= set computer clock, 0= do not set */
extern int wrtdif;         /* 1= write diff to file, 0= do not write*/
	perr="\n Syntax error in config. file ";
	peof=" -- premature EOF \n ";
	iop=fopen("nbstime.cfg","rt");
	if(iop == 0)
	{
	printf("\n can't open file nbstime.cfg, use default configuration.");
	return;
	}
/*
	first line of file is full telephone number. read it and store
	after ATD which starts command to modem
*/
	eol=0;
	for(j=3; (j<29) && (eol==0); j++)
	{
	c=getc(iop);
	switch(c)
	   {
	   case EOF:
	      printf("%s %s",perr,peof);
	      abort();
	      break;
	   case '\n':
	      number[j]='\r';        /*terminate with carriage return*/
	      number[j+1]=0;        /* and then a null */
	      eol=1;
	      break;
	   default:
	      number[j]=c;
	      break;
	   }
	}
	if(eol == 0)
	{
	printf("%s -- telephone # too long. \n",perr);
	abort();
	}
/*
	next line contains comport, 1 for com1, 2 for com2 in col 1.
	second char sets echo: B=0, anything else =1,
	third character is baud rate, h=1200, l=300;
	fourth character is line printer y=yes, n=no.
	fifth character is set clocks, s=set, d=disable set.
	rest of line is ignored and may be used for a comment
*/
	c=getc(iop);
	switch (c)
	{
	case EOF:
	   printf("%s %s",perr,peof);
	   abort();
	   break;
	case '1':
	   cmport=0;
	   break;
	case '2':
	   cmport=1;
	   break;
	default:
	   printf("%s -- comport not 1 or 2 \n",perr);
	   abort();
	   break;
	}
	c=getc(iop);
	switch(c)
	{
	case EOF:
	   printf("%s %s", perr,peof);
	   abort();
	   break;
	case 'b':
	case 'B':
	   echo=0;
	   break;
	case 'e':
	case 'E':
	   echo=1;
	   break;
	default:
	   printf("\n Warning, Line 2 Char 2 not e or b -- e assumed.");
	   echo=1;
	   break;
	}
	c=getc(iop);
	switch (c)
	{
	case EOF:
	   printf("%s %s",perr,peof);
	   abort();
	case 'h':
	case 'H':
	   hs=1;
	   break;
	case 'l':
	case 'L':
	   hs=0;
	   break;
	default:
	   printf("\n Warning, Line 2 Char 3 not h or l -- h assumed.");
	   hs=1;
	   break;
	}
	c=getc(iop);
	switch (c)
	{
	case EOF:
	   printf("%s %s",perr,peof);
	   abort();
	case 'y':
	case 'Y':
	   lpt=1;
	   break;
	case 'n':
	case 'N':
	   lpt=0;
	   break;
	default:
	   printf("\n Warning, Line 2 Char 4 not y or n -- n assumed.");
	   lpt=0;
	   break;
	}
	c=getc(iop);
	switch (c)
	{
	case EOF:
	   printf("%s %s",perr,peof);
	   abort();
	case 's':
	case 'S':
	   setclk=1;
	   break;
	case 'd':
	case 'D':
	   setclk=0;
	   break;
	default:
	   printf("\n Warning, Line 2 Char 5 not s or d -- d assumed.");
	   setclk=0;
	   break;
	}
	c=getc(iop);
	switch (c)
	{
	case EOF:
	   printf("%s %s",perr,peof);
	   abort();
	case 'a':
	case 'A':
	   wrtdif=1;
	   if(  (jop=fopen("nbstime.dif","at")) == 0)
	      {
	      printf("\n Cannot open file for writing time difference");
	      wrtdif=0;
	      }
	   break;
	case 'n':
	case 'N':
	   wrtdif=0;
	   break;
	default:
	   printf("\n Warning, Line 2 Char 6 not a or n -- n assumed.");
	   wrtdif=0;
	   break;
	}
	while( ( (c=getc(iop)) != '\n') && (c != EOF) );/*skip rest of line*/
	if(c == EOF)
	{
	printf("%s %s",perr,peof);
	abort();
	}
/*
	next line contains utcdif as number for hours or symbol for zone
*/
	c=getc(iop);
	switch (c)
	{
	case 'p':
	case 'P':
	   utcdif=-8;
	   break;
	case 'm':
	case 'M':
	   utcdif=-7;
	   break;
	case 'c':
	case 'C':
	   utcdif=-6;
	   break;
	case 'e':
	case 'E':
	   utcdif=-5;
	   break;
	case 'z':
	case 'Z':
	   utcdif=0;
	   break;
	case '-':
	case '+':
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	   ungetc(c,iop);
	   fscanf(iop,"%d",&utcdif);
	   break;
	default:
	   printf("\n %s -- syntax error in Line 3 -- utc dif.\n",perr);
	   abort();
	   break;
	}
	while( ( (c=getc(iop) ) != '\n') && (c != EOF));/*skip to next line*/
	if(c == EOF)
	{
	printf("%s %s",perr,peof);
	abort();
	}
	j=fscanf(iop,"%d \n%d",&dsflag,&atflag);
	if(j == EOF)
	{
	printf("%s %s",perr,peof);
	abort();
	}
	if(j != 2)
	{
	printf("%s -- syntax error in AT flag or ds flag \n",perr);
	abort();
	}
	fclose(iop);
}
